/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl.vasa;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.sms.provider.VasaProviderInfo;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vsphere.client.commonservice.util.QueryServiceUtil;
import com.vmware.vsphere.client.h5.storage.data.vasa.StorageProviderSystemInfoEx;
import com.vmware.vsphere.client.sms.StorageProviderInfo;
import com.vmware.vsphere.client.sms.StorageProviderSystemInfo;
import java.util.HashMap;
import java.util.List;

public class VasaPropertyProvider
implements PropertyProviderBean {
    private static final String STORAGE_SYSTEMS_PROP = "storageProviderSystems";
    private static final String NAME_PROP = "name";
    private static final String URL_PROP = "url";
    private static final String DS_TYPE_PROP = "summary.type";
    private static final String VSAN_DS_TYPE = "vsan";
    private final QueryService _queryService;

    public VasaPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @ModelMetadata(type={"Folder"}, propertyNamespace="vasa", property="storageProviderSystemInfoEx")
    public StorageProviderSystemInfoEx[] getStorageProviderSystemInfoEx(ManagedObjectReference vcRef) {
        StorageProviderSystemInfo[] storageSystemItems = (StorageProviderSystemInfo[])QueryServiceUtil.queryProperty((QueryService)this._queryService, (ManagedObjectReference)vcRef, (String)STORAGE_SYSTEMS_PROP);
        if (storageSystemItems == null || storageSystemItems.length == 0) {
            return new StorageProviderSystemInfoEx[0];
        }
        StorageProviderSystemInfoEx[] result = new StorageProviderSystemInfoEx[storageSystemItems.length];
        int numberOfVsanStorageArrays = 0;
        for (int i = 0; i < result.length; ++i) {
            result[i] = StorageProviderSystemInfoEx.newInstance(storageSystemItems[i]);
            if (!this.hasVsanStorageProviders(storageSystemItems[i])) continue;
            ++numberOfVsanStorageArrays;
        }
        if (numberOfVsanStorageArrays > 0) {
            this.populateVsanDatastoreNames(vcRef, result);
        }
        return result;
    }

    private boolean hasVsanStorageProviders(StorageProviderSystemInfo itemInfo) {
        String providerNamespace;
        if (itemInfo.storageArray == null || itemInfo.storageProviderInfoList == null || itemInfo.storageProviderInfoList.isEmpty()) {
            return false;
        }
        StorageProviderInfo providerInfo = (StorageProviderInfo)itemInfo.storageProviderInfoList.get(0);
        return providerInfo.providerInfo instanceof VasaProviderInfo && VSAN_DS_TYPE.equalsIgnoreCase(providerNamespace = ((VasaProviderInfo)providerInfo.providerInfo).namespace);
    }

    private void populateVsanDatastoreNames(ManagedObjectReference vcRef, StorageProviderSystemInfoEx[] systemInfoItems) {
        ResultSet vsanDsData = this._queryService.select(new String[]{NAME_PROP, URL_PROP}).from(new String[]{Datastore.class.getSimpleName()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate(DS_TYPE_PROP, PropertyPredicate.ComparisonOperator.EQUAL, (Object)VSAN_DS_TYPE), new PropertyPredicate("@instanceUuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)vcRef.getServerGuid())}).fetch();
        if (vsanDsData == null) {
            return;
        }
        List dsItems = vsanDsData.getItems();
        if (dsItems == null || dsItems.isEmpty()) {
            return;
        }
        HashMap<String, String> vsanUuidToDatastoreName = new HashMap<String, String>();
        for (StorageProviderSystemInfoEx infoEx : systemInfoItems) {
            if (infoEx.storageArray == null || infoEx.storageArray.name == null) continue;
            String vsanUuid = infoEx.storageArray.name;
            if (!vsanUuidToDatastoreName.containsKey(vsanUuid)) {
                for (ResourceItem resourceItem : dsItems) {
                    String vsanUrlProp = (String)resourceItem.get(URL_PROP);
                    if (vsanUrlProp == null || vsanUrlProp.indexOf(vsanUuid) < 0) continue;
                    vsanUuidToDatastoreName.put(vsanUuid, (String)resourceItem.get(NAME_PROP));
                    break;
                }
            }
            infoEx.storageArrayFriendlyName = (String)vsanUuidToDatastoreName.get(vsanUuid);
        }
    }
}

