/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder;

import com.vmware.vim.binding.vim.option.OptionValue;
import com.vmware.vise.data.common.DynamicObject;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vsphere.client.folder.VcServerSettingsBaseDataBuilder;
import com.vmware.vsphere.client.folder.VcServerSettingsInfo;
import java.util.Map;
import java.util.TreeMap;

public class VcServerSettingsDataBuilder
extends VcServerSettingsBaseDataBuilder<OptionValue> {
    private OptionValue[] _settings;

    public VcServerSettingsDataBuilder(FeatureStateService featureStateService, OptionValue[] settings) {
        super(featureStateService);
        this._settings = settings;
    }

    public DynamicObject buildVcSettingsData() {
        if (ArrayUtil.isNullOrEmpty((Object[])this._settings)) {
            return null;
        }
        DynamicObject vcSettings = new DynamicObject();
        vcSettings.type = "type://vcServer/settings";
        Map<String, String[]> settingsBySections = VcServerSettingsInfo.SETTINGS_BY_SECTIONS_VCDB_UI_ENABLED;
        int sectionsCount = settingsBySections.keySet().size();
        vcSettings.properties = new NameValuePair[sectionsCount];
        int sectionIndex = 0;
        for (String sectionKey : settingsBySections.keySet()) {
            DynamicObject vcSectionSettings = this.buildVcSectionSettings(sectionKey);
            vcSettings.properties[sectionIndex] = new NameValuePair(sectionKey, (Object)vcSectionSettings);
            ++sectionIndex;
        }
        return vcSettings;
    }

    public DynamicObject buildVcSectionSettings(String section) {
        if (ArrayUtil.isNullOrEmpty((Object[])this._settings)) {
            return null;
        }
        TreeMap<String, OptionValue> vcSettingsLookup = this.createSettingsLookup(this._settings);
        String[] settingsKeys = this.getSettingsKeysForSection(section, vcSettingsLookup.keySet());
        DynamicObject sectionSettings = new DynamicObject();
        sectionSettings.properties = new NameValuePair[settingsKeys.length];
        int propIndex = 0;
        for (String key : settingsKeys) {
            Object prop = vcSettingsLookup.get(key).getValue();
            sectionSettings.properties[propIndex] = new NameValuePair(key, prop);
            ++propIndex;
        }
        return sectionSettings;
    }

    @Override
    protected String getSettingKey(OptionValue setting) {
        return setting.key;
    }
}

