/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder.impl;

import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;

public class SystemFoldersNameProvider
implements PropertyProviderBean {
    private static final String RESOURCE_BUNDLE_NAME = "SystemFoldersNameProvider";

    @type(value="Folder")
    public String getName(ManagedObjectReference rootFolderRef) throws Exception {
        String vcName = this.getVCenterName(rootFolderRef);
        if (vcName == null) {
            return "";
        }
        return vcName;
    }

    private String getVCenterName(ManagedObjectReference rootFolderRef) throws Exception {
        if (rootFolderRef == null || StringUtil.isNullOrEmpty((String)rootFolderRef.getServerGuid())) {
            throw new MethodFault(this.getLocalizedString("error.nullObject"));
        }
        VcService service = VimSessionUtil.getService((String)rootFolderRef.getServerGuid());
        if (service == null) {
            return null;
        }
        ServiceInstanceContent content = service.getServiceInstanceContent();
        if (!this.isApplicableRootFolder(rootFolderRef, content)) {
            return null;
        }
        String vcName = VcServiceUtil.getServiceName((String)rootFolderRef.getServerGuid());
        if (StringUtil.isNullOrEmpty((String)vcName)) {
            vcName = service.getServiceUrl();
        }
        return vcName;
    }

    private boolean isApplicableRootFolder(ManagedObjectReference object, ServiceInstanceContent content) {
        if (content == null) {
            return false;
        }
        ManagedObjectReference contentRF = content.rootFolder;
        return ManagedObjectUtil.areEqual((ManagedObjectReference)object, (ManagedObjectReference)contentRF);
    }

    private String getLocalizedString(String key) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (ClassLoader)this.getClass().getClassLoader());
    }
}

