/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder.impl;

import com.vmware.vim.binding.sca.configuration.Configuration;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.folder.AuthenticationProxyServiceSettingsData;
import java.net.URI;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VcAuthenticationProxyPropertyProvider
implements PropertyProviderBean {
    private static final String CM_SERVICE_TYPE = "cm:Service";
    private static final String CAM_SERVICE_ID = "vmcam";
    private static final String STATUS_PROP = "status";
    private static final String CONFIGURATIONS_PROP = "configurations";
    private static final Log _logger = LogFactory.getLog(VcAuthenticationProxyPropertyProvider.class);
    private final QueryExecutor _queryExecutor;

    public VcAuthenticationProxyPropertyProvider(QueryExecutor queryExecutor) {
        this._queryExecutor = queryExecutor;
    }

    @type(value="Folder")
    public AuthenticationProxyServiceSettingsData getCamServiceSettingsData(ManagedObjectReference vcRef) {
        String serverName = this.getServerName(vcRef);
        if (serverName != null) {
            String base64EncodedServerName = Base64.encodeBase64URLSafeString((byte[])serverName.getBytes());
            URI serviceUri = DefaultUriSchemeUtil.createUri((String)CM_SERVICE_TYPE, (String[])new String[]{CAM_SERVICE_ID, base64EncodedServerName});
            try {
                PropertyValue[] propertyValues = this._queryExecutor.getProperties(new Object[]{serviceUri}, new String[]{STATUS_PROP, CONFIGURATIONS_PROP});
                if (propertyValues != null) {
                    return this.extractServiceSettingsData(serviceUri, propertyValues);
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Unable to retrieve the settings for vmcam service. Error:", (Throwable)e);
            }
        }
        return null;
    }

    private String getServerName(ManagedObjectReference vcRef) {
        VcService vcService = VimSessionUtil.getService((String)vcRef.getServerGuid());
        ServiceEndpointEx[] endpointExes = vcService.getServiceEndPoints();
        if (endpointExes != null) {
            for (ServiceEndpointEx endpointEx : endpointExes) {
                if (!vcRef.getServerGuid().equals(endpointEx.instanceUuid)) continue;
                return endpointEx.getHost();
            }
        }
        return null;
    }

    private AuthenticationProxyServiceSettingsData extractServiceSettingsData(URI serviceUri, PropertyValue[] propertyValues) {
        AuthenticationProxyServiceSettingsData serviceSettingsData = new AuthenticationProxyServiceSettingsData();
        serviceSettingsData.serviceUri = serviceUri.toString();
        for (PropertyValue propertyValue : propertyValues) {
            if (STATUS_PROP.equals(propertyValue.propertyName) && propertyValue.value != null) {
                serviceSettingsData.status = propertyValue.value.toString();
            }
            if (!CONFIGURATIONS_PROP.equals(propertyValue.propertyName) || propertyValue.value == null) continue;
            serviceSettingsData.configurations = (Configuration[])propertyValue.value;
        }
        return serviceSettingsData;
    }
}

