/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder.impl;

import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.cm.util.CmAuthorizationService;

public class VcPropertyProvider
implements PropertyProviderBean {
    private static final String STANDALONE_MODE = "standalone";
    private static final String LINKED_MODE = "linked";
    private static final String OS_TYPE_LINUX = "linux";
    private CmAuthorizationService _cmAuthorizationService;

    public VcPropertyProvider(CmAuthorizationService cmAuthorizationService) {
        this._cmAuthorizationService = cmAuthorizationService;
    }

    @type(value="Folder")
    public String getVcMode(ManagedObjectReference rootFolderRef) throws Exception {
        LinkedVcGroup[] linkedVcGroups;
        String vcGuid = rootFolderRef.getServerGuid();
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        for (LinkedVcGroup linkedVcGroup : linkedVcGroups = linkedVcGroupRegistry.getLinkedVcGroups()) {
            VcService vcService = linkedVcGroup.getVcService(vcGuid);
            if (vcService == null) continue;
            if (linkedVcGroup.getVcServices().size() > 1) {
                return LINKED_MODE;
            }
            return STANDALONE_MODE;
        }
        return STANDALONE_MODE;
    }

    @type(value="Folder")
    public AboutInfo getAboutInfo(ManagedObjectReference rootFolderRef) throws Exception {
        VcService service = VimSessionUtil.getService((String)rootFolderRef.getServerGuid());
        ServiceInstanceContent sic = service.getServiceInstanceContent();
        return sic.about;
    }

    @type(value="Folder")
    public Boolean getIsVCSA(ManagedObjectReference rootFolderRef) {
        String serverGuid = rootFolderRef.getServerGuid();
        if (!VcServiceUtil.isVc61OrLater((String)serverGuid)) {
            return false;
        }
        VcService vcService = VimSessionUtil.getService((String)rootFolderRef.getServerGuid());
        ServiceInstanceContent instanceContent = vcService.getServiceInstanceContent();
        AboutInfo aboutInfo = instanceContent.getAbout();
        String osType = aboutInfo.getOsType();
        return osType.contains(OS_TYPE_LINUX);
    }

    @type(value="Folder")
    public Boolean getIsAuthProxySupported(ManagedObjectReference rootFolderRef) {
        String serverGuid = rootFolderRef.getServerGuid();
        return VcServiceUtil.is65VcOrLaterByServerGuid((String)serverGuid) && this._cmAuthorizationService.isCurrentUserAuthorized();
    }
}

