/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cluster.ha;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.cluster.DasConfigInfo;
import com.vmware.vim.binding.vim.cluster.DasVmcpPrecheckResult;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.commands.DataFetchCommand;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.cluster.ha.HostDataModel;
import com.vmware.vsphere.client.cluster.ha.HostNameInfo;
import com.vmware.vsphere.client.cluster.ha.VmcpPrecheckResult;
import java.util.Collection;

public class VmcpPreflighChecker {
    private final DataFetchCommand _dataFetchCommand;

    public VmcpPreflighChecker(DataFetchCommand dataFetchCommand) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{dataFetchCommand});
        this._dataFetchCommand = dataFetchCommand;
    }

    public VmcpPrecheckResult runVmcpPreflightCheck(ManagedObjectReference clusterRef, DasConfigInfo configInfo) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{clusterRef, configInfo});
        ClusterComputeResource cluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)clusterRef);
        DasVmcpPrecheckResult dasPrecheckResult = cluster.checkReconfigureDasVmcp(configInfo, true);
        VmcpPrecheckResult result = new VmcpPrecheckResult();
        result.hostsWithIncompatibleVersion = this.buildHostNameInfos(dasPrecheckResult.hostsWithIncompatibleVersion);
        result.hostsWithApdTimeoutDisabled = this.buildHostNameInfos(dasPrecheckResult.hostsWithApdTimeoutDisabled);
        return result;
    }

    private HostNameInfo[] buildHostNameInfos(ManagedObjectReference[] hostRefs) {
        Collection hostDataModels;
        HostNameInfo[] hostNameInfos = null;
        if (!ArrayUtil.isNullOrEmpty((Object[])hostRefs) && (hostDataModels = this._dataFetchCommand.execute(HostDataModel.class, (Object[])hostRefs)) != null && !hostDataModels.isEmpty()) {
            hostNameInfos = new HostNameInfo[hostDataModels.size()];
            int i = 0;
            for (HostDataModel hostDataModel : hostDataModels) {
                hostNameInfos[i++] = new HostNameInfo(hostDataModel);
            }
        }
        return hostNameInfos;
    }
}

