/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cluster.rp;

import com.vmware.vim.binding.vim.ResourceAllocationInfo;
import com.vmware.vim.binding.vim.ResourceConfigSpec;
import com.vmware.vim.binding.vim.SharesInfo;
import com.vmware.vise.util.ValidationUtil;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

class ResourceConfigSpecSerDes {
    ResourceConfigSpecSerDes() {
    }

    public void serialize(ResourceConfigSpec configSpec, ObjectOutput out) throws IOException {
        ValidationUtil.paramsNotNull((Object[])new Object[]{out});
        if (configSpec == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            this.writeAllocationInfo(configSpec.getCpuAllocation(), out);
            this.writeAllocationInfo(configSpec.getMemoryAllocation(), out);
        }
    }

    public ResourceConfigSpec deserialize(ObjectInput in) throws ClassNotFoundException, IOException {
        boolean isConfgiSpecSerialized;
        ValidationUtil.paramsNotNull((Object[])new Object[]{in});
        boolean bl = isConfgiSpecSerialized = in.readByte() == 1;
        if (isConfgiSpecSerialized) {
            ResourceConfigSpec configSpec = new ResourceConfigSpec();
            configSpec.setCpuAllocation(this.readAllocationInfo(in));
            configSpec.setMemoryAllocation(this.readAllocationInfo(in));
            return configSpec;
        }
        return null;
    }

    private void writeAllocationInfo(ResourceAllocationInfo info, ObjectOutput out) throws IOException {
        out.writeObject(info.getLimit());
        out.writeObject(info.getReservation());
        out.writeObject(info.isExpandableReservation());
        if (info.getShares() == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeObject(info.getShares().getLevel());
            out.writeInt(info.getShares().getShares());
        }
    }

    private ResourceAllocationInfo readAllocationInfo(ObjectInput in) throws ClassNotFoundException, IOException {
        boolean isSharesInfoSerialized;
        ResourceAllocationInfo info = new ResourceAllocationInfo();
        info.setLimit((Long)in.readObject());
        info.setReservation((Long)in.readObject());
        info.setExpandableReservation((Boolean)in.readObject());
        boolean bl = isSharesInfoSerialized = in.readByte() == 1;
        if (isSharesInfoSerialized) {
            SharesInfo sharesInfo = new SharesInfo();
            sharesInfo.setLevel((SharesInfo.Level)in.readObject());
            sharesInfo.setShares(in.readInt());
            info.shares = sharesInfo;
        }
        return info;
    }
}

