/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.impl;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.ClusterStorageVmData;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.HostStorageVmData;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.ResourcePoolStorageVmData;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.VirtualDiskListItemData;
import com.vmware.vsphere.client.clusterui.util.ResourceReservationUtil;

public final class ResourceReservationPropertyProvider {
    private final QueryBindingService _queryBindingService;

    public ResourceReservationPropertyProvider(QueryBindingServiceFactory queryBindingServiceFactory) {
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
    }

    @PropertyProvider(value="ClusterComputeResource/clusterVirtualDisks")
    public VirtualDiskListItemData[] getClusterVirtualDisks(ManagedObjectReference object) {
        if (object == null) {
            throw new IllegalArgumentException("getClusterVirtualDisks accepts only a single ClusterComputeResource parameter.");
        }
        ClusterStorageVmData clusterData = (ClusterStorageVmData)this._queryBindingService.prepare(ClusterStorageVmData.class).fetch((Object)object);
        return ResourceReservationUtil.getVirtualDiskListItemDatas(clusterData.datastoreArray, clusterData.vms);
    }

    @PropertyProvider(value="HostSystem/hostVirtualDisks")
    public VirtualDiskListItemData[] getHostVirtualDisks(ManagedObjectReference object) {
        if (object == null) {
            throw new IllegalArgumentException("getHostVirtualDisks accepts only a single HostSystem parameter.");
        }
        HostStorageVmData hostData = (HostStorageVmData)this._queryBindingService.prepare(HostStorageVmData.class).fetch((Object)object);
        return ResourceReservationUtil.getVirtualDiskListItemDatas(hostData.datastoreArray, hostData.vms);
    }

    @PropertyProvider(value="ResourcePool/rpVirtualDisks")
    public VirtualDiskListItemData[] getRpVirtualDisks(ManagedObjectReference object) {
        if (object == null) {
            throw new IllegalArgumentException("getRpVirtualDisks accepts only a single ResourcePool parameter.");
        }
        ResourcePoolStorageVmData rpData = (ResourcePoolStorageVmData)this._queryBindingService.prepare(ResourcePoolStorageVmData.class).fetch((Object)object);
        return ResourceReservationUtil.getVirtualDiskListItemDatas(rpData.datastoreArray, rpData.vms);
    }

    @PropertyProvider(value="VirtualApp/vAppVirtualDisks")
    public VirtualDiskListItemData[] getVAppVirtualDisks(ManagedObjectReference object) {
        if (object == null) {
            throw new IllegalArgumentException("getVAppVirtualDisks accepts only a single VirtualApp parameter.");
        }
        ResourcePoolStorageVmData vAppData = (ResourcePoolStorageVmData)this._queryBindingService.prepare(ResourcePoolStorageVmData.class).fetch((Object)object);
        return ResourceReservationUtil.getVirtualDiskListItemDatas(vAppData.datastoreArray, vAppData.vms);
    }
}

