/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.monitor.drs.utilization;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.clusterui.model.monitor.drs.utilization.ColorUtil;
import com.vmware.vsphere.client.clusterui.model.monitor.drs.utilization.DrsCpuHostUtilizationData;
import com.vmware.vsphere.client.clusterui.model.monitor.drs.utilization.DrsCpuVmUtilizationData;
import com.vmware.vsphere.client.clusterui.model.monitor.drs.utilization.DrsMemoryHostUtilizationData;
import com.vmware.vsphere.client.clusterui.model.monitor.drs.utilization.DrsMemoryVmUtilizationData;
import java.awt.Color;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DrsClusterUtilizationUtil {
    public static String getCpuEntitlementColor(double entitlement) {
        Color interpolatedColor;
        int[] green = new int[]{179, 245, 26};
        int[] yellow = new int[]{245, 229, 150};
        int[] red = new int[]{255, 5, 7};
        if (entitlement >= 0.6) {
            double colorWeight = 1.0 - (entitlement - 0.6) / 0.4;
            interpolatedColor = ColorUtil.linearInterpolateColor(green, yellow, colorWeight);
        } else {
            double colorWeight = 1.0 - entitlement / 0.6;
            interpolatedColor = ColorUtil.linearInterpolateColor(yellow, red, colorWeight);
        }
        String hexColorString = ColorUtil.getHexColor(interpolatedColor);
        return hexColorString;
    }

    public static int getDeliveredPercentage(int \u0435ntitlement, int overallUsage) {
        if (\u0435ntitlement == 0 || overallUsage == 0) {
            return 0;
        }
        double overallUsageDecimal = (double)overallUsage * 100.0;
        double doubleValue = overallUsageDecimal / (double)\u0435ntitlement;
        return (int)Math.ceil(doubleValue);
    }

    public static List<DrsCpuVmUtilizationData> filterPoweredOnVmsWithCpuUsage(DrsCpuVmUtilizationData[] vmData, DrsCpuHostUtilizationData host) {
        if (vmData == null) {
            return Collections.emptyList();
        }
        ArrayList<DrsCpuVmUtilizationData> vmsPoweredOn = new ArrayList<DrsCpuVmUtilizationData>();
        for (DrsCpuVmUtilizationData vmItem : vmData) {
            if (vmItem == null || vmItem.overallCpuUsage <= 0 || vmItem.powerState != VirtualMachine.PowerState.poweredOn) continue;
            vmItem.cpuBarWidth = DrsClusterUtilizationUtil.getVmBarWidth(vmItem, host);
            vmsPoweredOn.add(vmItem);
        }
        return vmsPoweredOn;
    }

    public static List<DrsMemoryVmUtilizationData> filterPoweredOnVmsWithMemoryUsage(DrsMemoryVmUtilizationData[] vmData, DrsMemoryHostUtilizationData host) {
        if (vmData == null) {
            return Collections.emptyList();
        }
        ArrayList<DrsMemoryVmUtilizationData> vmsPoweredOn = new ArrayList<DrsMemoryVmUtilizationData>();
        for (DrsMemoryVmUtilizationData vmItem : vmData) {
            if (vmItem == null || vmItem.overallMemoryUsage <= 0 || vmItem.powerState != VirtualMachine.PowerState.poweredOn) continue;
            vmItem.consumedMemoryBarWidth = DrsClusterUtilizationUtil.getConsumedMemoryVmBarWidth(vmItem, host);
            vmItem.activeMemoryBarWidth = DrsClusterUtilizationUtil.getActiveMemoryVmBarWidth(vmItem, host);
            vmsPoweredOn.add(vmItem);
        }
        return vmsPoweredOn;
    }

    private static double getVmBarWidth(DrsCpuVmUtilizationData vm, DrsCpuHostUtilizationData host) {
        double hostCpuMHz = host.hz / (double)FormatUtil.MHz;
        double delimiter = hostCpuMHz * (double)host.numCpuCores;
        double nominator = (double)vm.overallCpuUsage * 100.0;
        return Math.max(nominator / delimiter, 0.5);
    }

    private static double getConsumedMemoryVmBarWidth(DrsMemoryVmUtilizationData vm, DrsMemoryHostUtilizationData host) {
        double overallMemoryUsageB = (long)vm.overallMemoryUsage * 0x100000L;
        double r = 100.0 * overallMemoryUsageB / host.memorySize;
        return Math.max(r, 0.5);
    }

    private static double getActiveMemoryVmBarWidth(DrsMemoryVmUtilizationData vm, DrsMemoryHostUtilizationData host) {
        double activeMemoryUsage = (long)vm.activeMemoryUsage * 0x100000L;
        double r = 100.0 * activeMemoryUsage / host.memorySize;
        return Math.max(r, 0.5);
    }

    public static double getNetworkUtilizationPercentValue(long averageRateKbps, PhysicalNic[] physicalNics) {
        long hostNetworkCapacityKb;
        BigDecimal percentValue = new BigDecimal(0);
        if (averageRateKbps != 0L && (hostNetworkCapacityKb = DrsClusterUtilizationUtil.getHostNetworkCapacityKb(physicalNics)) != 0L) {
            percentValue = new BigDecimal(averageRateKbps).multiply(new BigDecimal(100)).divide(new BigDecimal(hostNetworkCapacityKb), 2, RoundingMode.HALF_UP);
        }
        return percentValue.doubleValue();
    }

    private static long getHostNetworkCapacityKb(PhysicalNic[] physicalNics) {
        long capacityMb = 0L;
        long bitsInByte = 8L;
        if (physicalNics != null && physicalNics.length > 0) {
            for (PhysicalNic pnic : physicalNics) {
                if (pnic == null || pnic.linkSpeed == null || pnic.linkSpeed.speedMb == 0) continue;
                capacityMb += (long)pnic.linkSpeed.speedMb;
            }
        }
        return capacityMb * FormatUtil.KBPS / bitsInByte;
    }
}

