/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.monitor.drs.utilization;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vsphere.client.clusterui.model.monitor.drs.utilization.DrsClusterUtilizationUtil;
import com.vmware.vsphere.client.clusterui.model.monitor.drs.utilization.HostUtilizationData;
import java.text.NumberFormat;

@QueryBinding(value="HostSystem")
public class DrsNetworkHostUtilizationData
extends HostUtilizationData {
    @Property(value="HostSystem/averageNetReceived")
    transient long averageRx;
    @Property(value="HostSystem/averageNetTransmitted")
    transient long averageTx;
    @Property(value="HostSystem/config/network/pnic")
    transient PhysicalNic[] physicalNics;

    public double getAverageRxPercent() {
        return DrsClusterUtilizationUtil.getNetworkUtilizationPercentValue(this.averageRx, this.physicalNics);
    }

    public double getAverageTxPercent() {
        return DrsClusterUtilizationUtil.getNetworkUtilizationPercentValue(this.averageTx, this.physicalNics);
    }

    public String getAverageRxPercentLocalized() {
        return NumberFormat.getInstance(ResourceUtil.getLocale()).format(DrsClusterUtilizationUtil.getNetworkUtilizationPercentValue(this.averageRx, this.physicalNics));
    }

    public String getAverageTxPercentLocalized() {
        return NumberFormat.getInstance(ResourceUtil.getLocale()).format(DrsClusterUtilizationUtil.getNetworkUtilizationPercentValue(this.averageTx, this.physicalNics));
    }

    public String getAverageRx() {
        return FormatUtil.getByteRateFormatted((Number)this.averageRx, (int)2, (long)FormatUtil.KBYTESPS, (long)-2L, (boolean)true);
    }

    public String getAverageTx() {
        return FormatUtil.getByteRateFormatted((Number)this.averageTx, (int)2, (long)FormatUtil.KBYTESPS, (long)-2L, (boolean)true);
    }
}

