/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.monitor.reservation;

import com.vmware.vsphere.client.clusterui.model.monitor.reservation.StorageCapacityData;
import com.vmware.vsphere.client.clusterui.util.Util;

public abstract class BaseStorageCapacityData {
    protected StorageCapacityData capacityData;

    public String getTotalCapacityFormatted() {
        return Util.getBytesMemoryFormatted(this.getTotalCapacityValue());
    }

    public String getFreeSpaceFormatted() {
        return Util.getBytesMemoryFormatted(this.getFreeSpaceValue());
    }

    public String getUsedSpaceFormatted() {
        return Util.getBytesMemoryFormatted(this.getUsedSpaceValue());
    }

    public double getStoragePercentage() {
        return Util.getPercentageValue(this.getUsedSpaceValue(), this.getTotalCapacityValue());
    }

    private Long getTotalCapacityValue() {
        return this.getCapacityData().getTotalCapacityValue();
    }

    private Long getFreeSpaceValue() {
        return this.getCapacityData().getFreeSpaceValue();
    }

    private long getUsedSpaceValue() {
        return this.getCapacityData().getUsedSpaceValue();
    }

    protected abstract StorageCapacityData getCapacityData();
}

