/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.monitor.reservation;

import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.DatastoreCapacityData;

public final class StorageCapacityData {
    protected DatastoreCapacityData[] datastoreArray;
    protected Long _totalCapacity;
    protected Long _freeSpace;

    public StorageCapacityData(DatastoreCapacityData[] datastoreArray) {
        this.datastoreArray = datastoreArray;
    }

    public Long getTotalCapacityValue() {
        if (this._totalCapacity == null) {
            this.calculateValues();
        }
        return this._totalCapacity;
    }

    public Long getFreeSpaceValue() {
        if (this._freeSpace == null) {
            this.calculateValues();
        }
        return this._freeSpace;
    }

    public long getUsedSpaceValue() {
        return this.getTotalCapacityValue() - this.getFreeSpaceValue();
    }

    private void calculateValues() {
        this._totalCapacity = 0L;
        this._freeSpace = 0L;
        if (!ArrayUtil.isNullOrEmpty((Object[])this.datastoreArray)) {
            for (DatastoreCapacityData dsInfo : this.datastoreArray) {
                if (!dsInfo.accessible) continue;
                this._totalCapacity = this._totalCapacity + dsInfo.capacity;
                this._freeSpace = this._freeSpace + dsInfo.freeSpace;
            }
        }
    }
}

