/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.monitor.utilization;

import com.vmware.vsphere.client.clusterui.model.monitor.utilization.BaseUtilizationData;
import com.vmware.vsphere.client.clusterui.util.Util;
import com.vmware.vsphere.client.clusterui.util.UtilizationUtil;

public abstract class CpuBaseUtilizationData
extends BaseUtilizationData {
    public String getReservation() {
        return Util.getCpuFrequencyFormatted(this.getReservationValue());
    }

    public String getConsummation() {
        return Util.getCpuFrequencyFormatted(this.getConsummationValue());
    }

    public String getOverallCpuDemand() {
        return Util.getCpuFrequencyFormatted(this.getOverallDemand());
    }

    public String getSharesInfo() {
        if (this.getNumCPU() == null) {
            return "";
        }
        return UtilizationUtil.getCpuShares(this.getSharesInfoValue(), this.getNumCPU());
    }

    public String getMaxValue() {
        return Util.getCpuFrequencyFormatted(this.getMaxValueNum());
    }

    public String getStaticEntitlement() {
        return Util.getCpuFrequencyFormatted(Util.getLongValue(this.getStaticEntitlementValue()));
    }

    public double getCpuConsumedPercentage() {
        return Util.getPercentageValue(this.getConsummationValue(), this.getMaxValueNum());
    }

    public double getCpuActivePercentage() {
        return Util.getPercentageValue(this.getOverallDemand(), this.getMaxValueNum());
    }

    public String getLimit() {
        return this.getLimitValue() == -1L ? Util.getLocalizedString("unlimited.reservation", new String[0]) : Util.getCpuFrequencyFormatted(this.getLimitValue());
    }

    protected abstract Integer getNumCPU();
}

