/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.monitor.utilization;

import com.vmware.vsphere.client.clusterui.model.monitor.utilization.BaseUtilizationData;
import com.vmware.vsphere.client.clusterui.util.Util;
import com.vmware.vsphere.client.clusterui.util.UtilizationUtil;

public abstract class MemoryBaseUtilizationData
extends BaseUtilizationData {
    public String getReservation() {
        return Util.getMbMemoryFormatted(this.getReservationValue());
    }

    public String getConsummation() {
        return Util.getMbMemoryFormatted(this.getConsummationValue());
    }

    public String getOverheadMemory() {
        return Util.getMbMemoryFormatted(this.getOverallDemand());
    }

    public String getSharesInfo() {
        if (this.getNumMemoryValue() == null) {
            return "";
        }
        return UtilizationUtil.getMemoryShares(this.getSharesInfoValue(), this.getNumMemoryValue());
    }

    public String getMaxValue() {
        return Util.getMbMemoryFormatted(this.getMaxValueNum());
    }

    public String getStaticEntitlement() {
        return Util.getMbMemoryFormatted(Util.getLongValue(this.getStaticEntitlementValue()));
    }

    public double getConsumedMemoryPercentage() {
        return Util.getPercentageValue(this.getConsummationValue(), this.getMaxValueNum());
    }

    public double getOverheadConsumedMemoryPercentage() {
        return Util.getPercentageValue(this.getOverallDemand(), this.getMaxValueNum());
    }

    public String getLimit() {
        return this.getLimitValue() == -1L ? Util.getLocalizedString("unlimited.reservation", new String[0]) : Util.getMbMemoryFormatted(this.getLimitValue());
    }

    protected abstract Integer getNumMemoryValue();
}

