/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.services;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.cluster.DpmConfigInfo;
import com.vmware.vim.binding.vim.cluster.DrsConfigInfo;
import com.vmware.vim.binding.vim.option.OptionValue;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.clusterui.util.DrsUtil;

@QueryBinding(value="ClusterComputeResource")
public class DrsConfigData
extends IdentifiableQueryBinding {
    public static final String VM_EVEN_DISTRIBUTION_OPTION = "TryBalanceVmsPerHost";
    public static final int VM_EVEN_DISTRIBUTION_OPTION_VALUE = 1;
    public static final String CONSUMED_MEMORY_OPTION = "PercentIdleMBInMemDemand";
    public static final String CPU_OVERCOMMITMENT_OPTION = "MaxVcpusPerCore";
    @Property(value="ClusterComputeResource/configurationEx/drsConfig/enabled")
    public boolean drsEnabled;
    @Property(value="ClusterComputeResource/configurationEx/drsConfig/defaultVmBehavior")
    public DrsConfigInfo.DrsBehavior defaultDrsBehavior;
    @Property(value="ClusterComputeResource/configurationEx/drsConfig/vmotionRate")
    public int migrationRate;
    @Property(value="ClusterComputeResource/configurationEx/drsConfig/enableVmBehaviorOverrides")
    public boolean vmAutomationEnabled;
    @Property(value="ClusterComputeResource/configurationEx/dpmConfigInfo/enabled")
    public Boolean dpmEnabled;
    @Property(value="ClusterComputeResource/configurationEx/dpmConfigInfo/defaultDpmBehavior")
    public DpmConfigInfo.DpmBehavior defaultDpmBehavior;
    @Property(value="ClusterComputeResource/configurationEx/dpmConfigInfo/hostPowerActionRate")
    public int dpmRate;
    @Property(value="ClusterComputeResource/configurationEx/drsConfig/option")
    public OptionValue[] advancedOptions;
    @Property(value="ClusterComputeResource/configurationEx/proactiveDrsConfig/enabled")
    public boolean proactiveDrsEnabled;
    @Property(value="ClusterComputeResource/scheduledTasksCount")
    public long scheduledTasksCount;

    public int getMigrationThreshold() {
        return DrsUtil.getDrsVMotionMigrationThreshold(this.migrationRate);
    }

    public int getCpuOverCommitmentPercent() {
        Object val = this.getOptionValue(CPU_OVERCOMMITMENT_OPTION);
        if (val != null) {
            return Integer.valueOf((String)val);
        }
        return 0;
    }

    public boolean getEvenDistributionEnabled() {
        Object val = this.getOptionValue(VM_EVEN_DISTRIBUTION_OPTION);
        return val != null && Integer.valueOf((String)val) == 1;
    }

    public boolean getAllConsumedMemoryMetricEnabled() {
        Object val = this.getOptionValue(CONSUMED_MEMORY_OPTION);
        return val != null && Integer.valueOf((String)val) > 0;
    }

    public boolean getCpuOverCommitment() {
        Object val = this.getOptionValue(CPU_OVERCOMMITMENT_OPTION);
        return val != null;
    }

    private Object getOptionValue(String key) {
        if (StringUtil.isNullOrEmpty((String)key) || ArrayUtil.isNullOrEmpty((Object[])this.advancedOptions)) {
            return null;
        }
        for (OptionValue pair : this.advancedOptions) {
            String optionKey = pair.key.trim();
            if (!optionKey.equals(key)) continue;
            return pair.value;
        }
        return null;
    }
}

