/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.services;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.cluster.DasAdmissionControlPolicy;
import com.vmware.vim.binding.vim.cluster.FailoverResourcesAdmissionControlPolicy;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.cluster.util.Util;

@QueryBinding(value="ClusterComputeResource")
public class HaFailoverResourceRuntimeInfoData
extends IdentifiableQueryBinding {
    @Property(value="ClusterComputeResource/summary/totalMemory")
    public transient Long totalMemory;
    @Property(value="ClusterComputeResource/summary/totalCpu")
    public transient Integer totalCpu;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/admissionControlEnabled")
    public transient Boolean admissionControlEnabled;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/admissionControlPolicy")
    public transient DasAdmissionControlPolicy admissionControlPolicy;

    public String getTotalMemoryText() {
        if (this.getPolicy() == null || this.totalMemory == null) {
            return "";
        }
        return this.formatBytes(this.totalMemory);
    }

    public String getTotalCpuText() {
        if (this.getPolicy() == null || this.totalCpu == null) {
            return "";
        }
        return this.formatMhz(this.totalCpu);
    }

    public String getReservedMemoryPercentText() {
        Integer reservedMemoryPercent = this.getReservedMemoryPercent();
        String reservedMemoryText = this.getReservedMemoryText();
        if (reservedMemoryPercent == null || reservedMemoryText == null) {
            return "";
        }
        return Util.getLocalizedString("ha.config.admission.control.failoverLevelPolicy.capacity", String.format("%d", reservedMemoryPercent), reservedMemoryText);
    }

    public String getReservedCpuPercentText() {
        Integer reservedCpuPercent = this.getReservedCpuPercent();
        String reservedCpuText = this.getReservedCpuText();
        if (reservedCpuPercent == null || reservedCpuText == null) {
            return "";
        }
        return Util.getLocalizedString("ha.config.admission.control.failoverLevelPolicy.capacity", String.format("%d", reservedCpuPercent), reservedCpuText);
    }

    public Boolean getAutoComputeStatus() {
        FailoverResourcesAdmissionControlPolicy policy = this.getPolicy();
        if (policy == null) {
            return null;
        }
        return policy.autoComputePercentages;
    }

    private String getReservedMemoryText() {
        FailoverResourcesAdmissionControlPolicy policy = this.getPolicy();
        if (policy == null || this.totalMemory == null || this.getReservedMemoryPercent() == null) {
            return null;
        }
        Long reservedMemory = this.totalMemory * (long)this.getReservedMemoryPercent().intValue() / 100L;
        return this.formatBytes(reservedMemory);
    }

    private String getReservedCpuText() {
        FailoverResourcesAdmissionControlPolicy policy = this.getPolicy();
        if (policy == null || this.totalCpu == null || this.getReservedCpuPercent() == null) {
            return null;
        }
        Integer reservedCpu = this.totalCpu * this.getReservedCpuPercent() / 100;
        return this.formatMhz(reservedCpu);
    }

    private String formatBytes(Number bytes) {
        return FormatUtil.getDataSizeFormatted((Number)bytes, (int)2, (long)1L, (long)-1L, (boolean)true);
    }

    private String formatMhz(Number mhz) {
        return FormatUtil.getFrequencyFormatted((Number)mhz, (int)2, (long)FormatUtil.MHz, (long)-1L, (boolean)true);
    }

    private Integer getReservedMemoryPercent() {
        FailoverResourcesAdmissionControlPolicy policy = this.getPolicy();
        if (policy == null) {
            return null;
        }
        return policy.getMemoryFailoverResourcesPercent();
    }

    private Integer getReservedCpuPercent() {
        FailoverResourcesAdmissionControlPolicy policy = this.getPolicy();
        if (policy == null) {
            return null;
        }
        return policy.getCpuFailoverResourcesPercent();
    }

    private FailoverResourcesAdmissionControlPolicy getPolicy() {
        if (Boolean.FALSE.equals(this.admissionControlEnabled)) {
            return null;
        }
        if (this.admissionControlPolicy instanceof FailoverResourcesAdmissionControlPolicy) {
            return (FailoverResourcesAdmissionControlPolicy)this.admissionControlPolicy;
        }
        return null;
    }
}

