/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.as.checkers;

import com.vmware.vide.vwcsdktools.as.checkers.MetadataTagChecker;
import com.vmware.vide.vwcsdktools.as.checkers.MetadataTagRemoteJavaClassParameterChecker;
import com.vmware.vide.vwcsdktools.as.checkers.MetadataTagWhiteListParameterChecker;
import com.vmware.vide.vwcsdktools.as.model.MetadataTag;
import com.vmware.vide.vwcsdktools.as.model.MetadataTagParameter;
import com.vmware.vide.vwcsdktools.managers.CheckTypeRule;
import com.vmware.vide.vwcsdktools.processors.CheckType;
import org.eclipse.core.resources.IFile;

public enum MetadataCheckerFactory {
    INSTANCE;


    public MetadataTagChecker createChecker(CheckTypeRule rule, IFile file, MetadataTag tag, MetadataTagParameter param) {
        CheckType type = rule.getType();
        if (type == CheckType.WHITE_LIST) {
            String whiteListName = rule.getOptions().get(0);
            return new MetadataTagWhiteListParameterChecker(rule, file, tag, param, whiteListName);
        }
        if (type == CheckType.REMOTE_JAVA_CLASSES) {
            return new MetadataTagRemoteJavaClassParameterChecker(rule, file, tag, param);
        }
        return null;
    }
}

