/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.as.checkers;

import com.vmware.vide.vwcsdktools.as.checkers.AddProblemValueToWhiteList;
import com.vmware.vide.vwcsdktools.as.checkers.FixProblemValueFromWhiteList;
import com.vmware.vide.vwcsdktools.as.checkers.MetadataTagProblemSolution;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.IMarkerResolution2;

public enum MetadataTagProblemSolutionsFactory {
    INSTANCE;


    public List<IMarkerResolution2> createSolutions(IMarker marker, MetadataTagProblemSolution type) {
        ArrayList<IMarkerResolution2> solutions = new ArrayList<IMarkerResolution2>();
        if (type != null && type == MetadataTagProblemSolution.PARAMETER_VALUE_WHITE_LIST) {
            String whiteListName = this.getWhiteListName(marker);
            String word = this.getValue(marker);
            if (whiteListName != null && !whiteListName.isEmpty() && word != null) {
                solutions.add(new AddProblemValueToWhiteList(whiteListName, word));
                solutions.add(new FixProblemValueFromWhiteList(whiteListName, word));
            }
        }
        return solutions;
    }

    private String getWhiteListName(IMarker marker) {
        String options = marker.getAttribute("com.vmware.vide.vwcsdktools.metadata_tag_problem_marker_attrcheckrule.options", null);
        if (options != null) {
            return options.split(" *, *")[0];
        }
        return null;
    }

    private String getValue(IMarker marker) {
        return marker.getAttribute("com.vmware.vide.vwcsdktools.metadata_tag_problem_marker_attr.parameter.value", null);
    }
}

