/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.as.checkers;

import com.vmware.vide.vwcsdktools.as.checkers.MetadataTagCheckResult;
import com.vmware.vide.vwcsdktools.as.checkers.MetadataTagChecker;
import com.vmware.vide.vwcsdktools.as.checkers.MetadataTagProblemType;
import com.vmware.vide.vwcsdktools.as.model.MetadataTag;
import com.vmware.vide.vwcsdktools.as.model.MetadataTagParameter;
import com.vmware.vide.vwcsdktools.as.parser.AsToken;
import com.vmware.vide.vwcsdktools.as.parser.IdentifierToken;
import com.vmware.vide.vwcsdktools.as.parser.StringLiteralToken;
import com.vmware.vide.vwcsdktools.managers.CheckTypeRule;
import com.vmware.vide.vwcsdktools.managers.MetadataTagProjectDataManager;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class MetadataTagWhiteListParameterChecker
extends MetadataTagChecker {
    MetadataTagParameter parameter;
    String whiteListName;

    MetadataTagWhiteListParameterChecker(CheckTypeRule rule, IFile file, MetadataTag tag, MetadataTagParameter param, String wlName) {
        super(rule, file, tag);
        this.parameter = param;
        this.whiteListName = wlName;
    }

    @Override
    public MetadataTagCheckResult run() {
        IProject project = this.file.getProject();
        MetadataTagCheckResult result = new MetadataTagCheckResult();
        Set<String> whiteList = MetadataTagProjectDataManager.INSTANCE.getWhiteList(project, this.whiteListName);
        if (whiteList != null) {
            AsToken t;
            AsToken token = this.parameter.getValue();
            String value = null;
            if (token.isStringLiteral()) {
                t = (StringLiteralToken)token;
                value = ((StringLiteralToken)t).getString();
            } else if (token.isIdentifier()) {
                t = (IdentifierToken)token;
                value = ((IdentifierToken)t).getName();
            }
            if (value != null && !whiteList.contains(value)) {
                String msg = null;
                msg = this.parameter.isNamed() ? String.format("%s is not a valid %s attribute for this tag.", value, this.parameter.getSimpleName()) : String.format("%s is not a valid value for this tag.", value);
                result.add(MetadataTagProblemType.NOT_IN_WHITE_LIST, this.rule, this.file, this.tag, this.parameter, msg);
            }
        }
        return result;
    }
}

