/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.handlers;

import com.vmware.vide.vwcsdktools.Activator;
import com.vmware.vide.vwcsdktools.as.checkers.MetadataTagCheckResult;
import com.vmware.vide.vwcsdktools.as.checkers.MetadataTagChecker;
import com.vmware.vide.vwcsdktools.as.managers.MetadataTagManager;
import com.vmware.vide.vwcsdktools.as.model.MetadataTag;
import com.vmware.vide.vwcsdktools.as.parser.ActionScriptMetadataTag;
import com.vmware.vide.vwcsdktools.as.parser.BufferError;
import com.vmware.vide.vwcsdktools.managers.ReportManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class MetadataCheckerHandler
extends AbstractHandler
implements IHandler {
    private static ILog logger = Activator.getDefault().getLog();
    private static final String ERR_MSG = "Internal error during checking metadata tags in [%s].";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Set<IFile> files = this.getSelectedActionScripts();
        for (IFile file : files) {
            ActionScriptMetadataTag metadatatag;
            try {
                file.deleteMarkers("com.vmware.vide.vwcsdktools.metadata_tag_problem_marker", false, 0);
            }
            catch (CoreException e) {
                logger.log((IStatus)new Status(4, "com.vmware.vide.vwcsdktools", null, (Throwable)e));
                continue;
            }
            try {
                metadatatag = new ActionScriptMetadataTag(file);
            }
            catch (IOException e) {
                logger.log((IStatus)new Status(4, "com.vmware.vide.vwcsdktools", String.format(ERR_MSG, file.getLocation().toOSString()), (Throwable)e));
                continue;
            }
            catch (BufferError e) {
                logger.log((IStatus)new Status(4, "com.vmware.vide.vwcsdktools", String.format(ERR_MSG, file.getLocation().toOSString()), (Throwable)e));
                continue;
            }
            List<MetadataTag> tags = metadatatag.getMetadataTags();
            if (!metadatatag.getErrors().isEmpty()) {
                ReportManager.INSTANCE.reportMetadataTagParseErrors(file, metadatatag.getErrors());
            }
            ArrayList<MetadataTagCheckResult> results = new ArrayList<MetadataTagCheckResult>();
            for (MetadataTag tag : tags) {
                String tagName = tag.getName();
                if (tagName.isEmpty()) continue;
                List<MetadataTagChecker> checkers = MetadataTagManager.INSTANCE.getCheckers(file, tag);
                for (MetadataTagChecker checker : checkers) {
                    results.add(checker.run());
                }
            }
            ReportManager.INSTANCE.reportMetadataTagCheckResults(results);
        }
        return null;
    }

    private Set<IFile> getSelectedActionScripts() {
        HashSet<IFile> files = new HashSet<IFile>();
        IWorkbench w = PlatformUI.getWorkbench();
        IWorkbenchWindow ww = w.getActiveWorkbenchWindow();
        IWorkbenchPage page = ww.getActivePage();
        ISelection selection = page.getSelection();
        boolean haveResource = false;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object o : ss) {
                if (!(o instanceof IResource)) continue;
                haveResource = true;
                if (o instanceof IFile) {
                    IFile f = (IFile)o;
                    if (!this.isActionScript(f)) continue;
                    files.add(f);
                    continue;
                }
                if (!(o instanceof IFolder)) continue;
                IFolder folder = (IFolder)o;
                files.addAll(this.getActionScripts(folder));
            }
        }
        if (!haveResource) {
            IViewPart part = page.findView("org.eclipse.jdt.ui.PackageExplorer");
            if (part != null) {
                selection = part.getSite().getSelectionProvider().getSelection();
                files.addAll(this.getActionScriptsFromSelection((IStructuredSelection)selection));
            } else {
                part = page.findView("org.eclipse.ui.navigator.ProjectExplorer");
                if (part != null) {
                    selection = part.getSite().getSelectionProvider().getSelection();
                    files.addAll(this.getActionScriptsFromSelection((IStructuredSelection)selection));
                }
            }
        }
        return files;
    }

    private Set<IFile> getActionScriptsFromSelection(IStructuredSelection ss) {
        HashSet<IFile> files = new HashSet<IFile>();
        for (Object o : ss) {
            if (!(o instanceof IResource)) continue;
            if (o instanceof IFile) {
                IFile f = (IFile)o;
                if (!this.isActionScript(f)) continue;
                files.add(f);
                continue;
            }
            if (!(o instanceof IFolder)) continue;
            IFolder folder = (IFolder)o;
            files.addAll(this.getActionScripts(folder));
        }
        return files;
    }

    private Set<IFile> getActionScripts(IFolder folder) {
        final HashSet<IFile> files = new HashSet<IFile>();
        try {
            folder.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    IFile f;
                    if (resource instanceof IFile && MetadataCheckerHandler.this.isActionScript(f = (IFile)resource)) {
                        files.add(f);
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            logger.log((IStatus)new Status(4, "com.vmware.vide.vwcsdktools", e.getMessage()));
        }
        return files;
    }

    private boolean isActionScript(IFile file) {
        return "as".equals(file.getFileExtension());
    }
}

