/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.managers;

import com.vmware.vide.vwcsdktools.Activator;
import com.vmware.vide.vwcsdktools.managers.CheckRule;
import com.vmware.vide.vwcsdktools.managers.CheckRuleManager;
import com.vmware.vide.vwcsdktools.managers.CheckTypeRule;
import com.vmware.vide.vwcsdktools.managers.DiagnosticLevel;
import com.vmware.vide.vwcsdktools.managers.ParameterRule;
import com.vmware.vide.vwcsdktools.model.IPropertyChangedEvent;
import com.vmware.vide.vwcsdktools.model.IPropertyChangedListener;
import com.vmware.vide.vwcsdktools.processors.CheckType;
import com.vmware.vide.vwcsdktools.utils.Names;
import com.vmware.vide.vwcsdktools.whitelist.WhiteListItem;
import com.vmware.vide.vwcsdktools.whitelist.WhiteListManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public enum ProjectDataManager {
    INSTANCE;

    public static final String PROP_PREFIX_SUPPORTED_TYPE = ".supportedType.";
    private static final String ANNOTATION_WHITELIST_DIR;
    private static final String OWNER_ID = "com.vmware.vide.vwcsdktools.annotation.parameter.check";
    static ILog logger;
    final Map<IProject, Map<String, Map<String, List<CheckTypeRule>>>> projectRules = new HashMap<IProject, Map<String, Map<String, List<CheckTypeRule>>>>();
    final Map<String, Map<String, List<CheckTypeRule>>> workspaceRules = new HashMap<String, Map<String, List<CheckTypeRule>>>();
    final Map<IProject, List<CheckRule>> projectRulesList = new HashMap<IProject, List<CheckRule>>();
    final Map<IProject, Map<String, Set<String>>> projectWhiteLists = new HashMap<IProject, Map<String, Set<String>>>();
    final IPropertyChangedListener propertyChangedListener;

    static {
        ANNOTATION_WHITELIST_DIR = ".vwcsdktools" + File.separator + "annotation_whitelist";
        logger = Activator.getDefault().getLog();
    }

    private ProjectDataManager() {
        this.updateWorkspaceCheckParameterRules();
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String[] names;
                if (event.getProperty().startsWith("diagnosticLevel") && (names = Names.parseDiagnosticLevelKey(event.getProperty())).length == 4) {
                    ProjectDataManager.this.updateDiagnosticLevel(ProjectDataManager.this.workspaceRules, names, (String)event.getNewValue());
                }
            }
        });
        this.propertyChangedListener = new IPropertyChangedListener(){

            @Override
            public void propertyChanged(IPropertyChangedEvent event) {
                IResource res = event.getResource();
                if (!(res instanceof IProject)) {
                    return;
                }
                QualifiedName name = event.getName();
                if (!ProjectDataManager.OWNER_ID.equals(name.getQualifier())) {
                    return;
                }
                if (!name.getLocalName().startsWith("diagnosticLevel")) {
                    return;
                }
                IProject project = (IProject)res;
                Map<String, Map<String, List<CheckTypeRule>>> table = ProjectDataManager.this.getCheckParameterRules(project);
                if (table == ProjectDataManager.this.workspaceRules) {
                    table = ProjectDataManager.this.cloneCheckParameterRulesTable(ProjectDataManager.this.workspaceRules);
                    ProjectDataManager.this.projectRules.put(project, table);
                }
                String[] names = Names.parseDiagnosticLevelKey(name.getLocalName());
                ProjectDataManager.this.updateDiagnosticLevel(table, names, event.getNewValue());
            }
        };
    }

    protected Map<String, Map<String, List<CheckTypeRule>>> cloneCheckParameterRulesTable(Map<String, Map<String, List<CheckTypeRule>>> original) {
        HashMap<String, Map<String, List<CheckTypeRule>>> table = new HashMap<String, Map<String, List<CheckTypeRule>>>();
        for (Map.Entry<String, Map<String, List<CheckTypeRule>>> annoEnt : original.entrySet()) {
            HashMap paramMap = new HashMap();
            for (Map.Entry<String, List<CheckTypeRule>> paramEnt : annoEnt.getValue().entrySet()) {
                ArrayList<CheckTypeRule> newTypes = new ArrayList<CheckTypeRule>();
                for (CheckTypeRule type : paramEnt.getValue()) {
                    newTypes.add(type.clone());
                }
                paramMap.put(paramEnt.getKey(), newTypes);
            }
            table.put(annoEnt.getKey(), paramMap);
        }
        return table;
    }

    private void updateDiagnosticLevel(Map<String, Map<String, List<CheckTypeRule>>> rules, String[] names, String level) {
        for (CheckTypeRule t : rules.get(names[1]).get(names[2])) {
            if (!t.type.name().equals(names[3])) continue;
            t.level = DiagnosticLevel.parse(level);
        }
    }

    public String getOwnerId() {
        return OWNER_ID;
    }

    public boolean isSupportedType(IProject project, String annotationName) {
        try {
            String supported = project.getPersistentProperty(new QualifiedName("com.vmware.vide.vwcsdktools", PROP_PREFIX_SUPPORTED_TYPE + annotationName));
            return supported == null || supported.equals(Boolean.toString(true));
        }
        catch (CoreException e) {
            logger.log((IStatus)new Status(4, "com.vmware.vide.vwcsdktools", "Failed to access the project property.", (Throwable)e));
            return true;
        }
    }

    public void setSupportedType(IProject project, String annotationName, boolean b) {
        try {
            project.setPersistentProperty(new QualifiedName("com.vmware.vide.vwcsdktools", PROP_PREFIX_SUPPORTED_TYPE + annotationName), Boolean.toString(b));
        }
        catch (CoreException e) {
            logger.log((IStatus)new Status(4, "com.vmware.vide.vwcsdktools", "Failed to set the project property.", (Throwable)e));
        }
    }

    public boolean isAnnotationForCheckingParameter(IProject project, String annotationName) {
        Map<String, Map<String, List<CheckTypeRule>>> rules = this.getCurrentCheckParameterRules(project);
        return rules.containsKey(annotationName);
    }

    private Map<String, Map<String, List<CheckTypeRule>>> getCheckParameterRules(IProject project) {
        if (!this.projectRules.containsKey(project)) {
            String ruleFile = String.valueOf(project.getLocation().toOSString()) + File.separator + ".vwcsdktools" + File.separator + "check.rule";
            File file = new File(ruleFile);
            if (file.exists()) {
                try {
                    List<CheckRule> rules = CheckRuleManager.ANNOTATION_INSTANCE.load(ruleFile);
                    this.projectRulesList.put(project, rules);
                    Map<String, Map<String, List<CheckTypeRule>>> rulesTable = this.createRulesTable(rules);
                    this.projectRules.put(project, rulesTable);
                    return rulesTable;
                }
                catch (FileNotFoundException e) {
                    logger.log((IStatus)new Status(4, "com.vmware.vide.vwcsdktools", "Failed to load the check rules in the project.", (Throwable)e));
                }
            }
            this.projectRules.put(project, this.getWorkspaceCheckParameterRules());
        }
        return this.projectRules.get(project);
    }

    private Map<String, Map<String, List<CheckTypeRule>>> getCurrentCheckParameterRules(IProject project) {
        try {
            String use = project.getPersistentProperty(new QualifiedName(this.getOwnerId(), "useproject"));
            if (Boolean.toString(true).equals(use)) {
                return this.getCheckParameterRules(project);
            }
        }
        catch (CoreException coreException) {}
        return this.getWorkspaceCheckParameterRules();
    }

    public List<CheckRule> getProjectRulesList(IProject project) {
        return this.projectRulesList.get(project);
    }

    private Map<String, Map<String, List<CheckTypeRule>>> getWorkspaceCheckParameterRules() {
        return this.workspaceRules;
    }

    private Map<String, Map<String, List<CheckTypeRule>>> createRulesTable(List<CheckRule> rules) {
        HashMap<String, Map<String, List<CheckTypeRule>>> rulesTable = new HashMap<String, Map<String, List<CheckTypeRule>>>();
        for (CheckRule rule : rules) {
            String annotationName = rule.name;
            HashMap parameterRuleMap = new HashMap();
            for (ParameterRule paramRule : rule.parameterRules) {
                String parameterName = paramRule.name;
                ArrayList<CheckTypeRule> checkRules = new ArrayList<CheckTypeRule>();
                for (CheckTypeRule checkType : paramRule.checkTypes) {
                    CheckTypeRule ct = new CheckTypeRule(checkType.type, checkType.level, new ArrayList<String>());
                    ct.options.addAll(checkType.options);
                    checkRules.add(ct);
                }
                parameterRuleMap.put(parameterName, checkRules);
            }
            rulesTable.put(annotationName, parameterRuleMap);
        }
        return rulesTable;
    }

    public List<CheckType> getCheckTypes(IProject project, String annotationName, String parameterName) {
        List<CheckTypeRule> types = this.getCurrentCheckParameterRules(project).get(annotationName).get(parameterName);
        ArrayList<CheckType> checkTypes = new ArrayList<CheckType>();
        for (CheckTypeRule t : types) {
            checkTypes.add(t.type);
        }
        return checkTypes;
    }

    public Set<String> getWhiteList(IProject project, String annotationName, String parameterName) {
        HashSet<String> whiteList = null;
        List<CheckTypeRule> types = this.getCurrentCheckParameterRules(project).get(annotationName).get(parameterName);
        for (CheckTypeRule t : types) {
            if (t.type != CheckType.WHITE_LIST) continue;
            if (t.options == null || t.options.isEmpty()) {
                logger.log((IStatus)new Status(4, "com.vmware.vide.vwcsdktools", String.format("No white list option in the rule for the parameter [%s] of the annotation [%s]", annotationName, parameterName)));
                continue;
            }
            String listName = t.options.get(0);
            Map<String, Set<String>> table = this.getWhiteListTable(project);
            Set<String> items = table.get(listName);
            if (items == null || items.isEmpty()) continue;
            if (whiteList == null) {
                whiteList = new HashSet<String>();
            }
            whiteList.addAll(items);
        }
        return whiteList;
    }

    private Map<String, Set<String>> getWhiteListTable(IProject project) {
        if (this.projectWhiteLists.containsKey(project)) {
            return this.projectWhiteLists.get(project);
        }
        Map<String, Set<String>> table = this.createWhiteListTable(project);
        this.projectWhiteLists.put(project, table);
        return table;
    }

    private Map<String, Set<String>> createWhiteListTable(IProject project) {
        List<WhiteListItem> listItems = WhiteListManager.ANNOTATION_INSTANCE.getWorkspaceWhiteList();
        HashMap<String, Set<String>> table = new HashMap<String, Set<String>>();
        for (WhiteListItem item : listItems) {
            table.put(item.getName(), new HashSet<String>(item.getList()));
        }
        List<WhiteListItem> adjustments = WhiteListManager.ANNOTATION_INSTANCE.loadWhiteListFiles(String.valueOf(project.getLocation().toOSString()) + File.separator + ANNOTATION_WHITELIST_DIR);
        for (WhiteListItem item : adjustments) {
            item.getOperator().operate(item, table);
        }
        return table;
    }

    public DiagnosticLevel getDiagnosticLevel(IProject project, String annotationName, String parameterName, CheckType checkType) {
        Map<String, Map<String, List<CheckTypeRule>>> rules = project == null ? this.getWorkspaceCheckParameterRules() : this.getCurrentCheckParameterRules(project);
        List<CheckTypeRule> types = rules.get(annotationName).get(parameterName);
        for (CheckTypeRule t : types) {
            if (t.type != checkType) continue;
            return t.level;
        }
        String msg = project == null ? "in the workspace" : String.format("in the project [%s]", project.getName());
        logger.log((IStatus)new Status(1, "com.vmware.vide.vwcsdktools", String.format("No diagnostic level %s for [annotation:%s, parameter:%s, check type: %s].", msg, annotationName, parameterName, checkType.name())));
        return DiagnosticLevel.ERROR;
    }

    void updateWorkspaceCheckParameterRules() {
        this.updateCheckParameterRulesTable(this.workspaceRules, CheckRuleManager.ANNOTATION_INSTANCE.getRules(), new WorkspaceStore());
    }

    void updateCheckParameterRulesTable(Map<String, Map<String, List<CheckTypeRule>>> table, List<CheckRule> rules, Store store) {
        table.clear();
        for (CheckRule rule : rules) {
            String annotationName = rule.name;
            HashMap parameterRuleMap = new HashMap();
            for (ParameterRule paramRule : rule.parameterRules) {
                String parameterName = paramRule.name;
                ArrayList<CheckTypeRule> checkRules = new ArrayList<CheckTypeRule>();
                for (CheckTypeRule checkType : paramRule.checkTypes) {
                    String key = Names.getPrefKeyForDiagnosticLevel(annotationName, parameterName, checkType.type.name());
                    String levelName = store.getValue(key);
                    DiagnosticLevel level = levelName.isEmpty() ? checkType.level : DiagnosticLevel.parse(levelName);
                    CheckTypeRule ct = new CheckTypeRule(checkType.type, level, new ArrayList<String>());
                    ct.options.addAll(checkType.options);
                    checkRules.add(ct);
                }
                parameterRuleMap.put(parameterName, checkRules);
            }
            table.put(annotationName, parameterRuleMap);
        }
    }

    public IPropertyChangedListener getPropertyChangedListener() {
        return this.propertyChangedListener;
    }

    class ProjectStore
    extends WorkspaceStore
    implements Store {
        IProject project;

        ProjectStore(IProject project) {
            this.project = project;
        }

        @Override
        public String getValue(String key) {
            String value = null;
            try {
                value = this.project.getPersistentProperty(new QualifiedName(ProjectDataManager.this.getOwnerId(), key));
            }
            catch (CoreException coreException) {}
            if (value == null) {
                value = this.store.getString(key);
            }
            return value;
        }
    }

    static interface Store {
        public String getValue(String var1);
    }

    class WorkspaceStore
    implements Store {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();

        WorkspaceStore() {
        }

        @Override
        public String getValue(String key) {
            return this.store.getString(key);
        }
    }
}

