/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.processors;

import com.vmware.vide.vwcsdktools.managers.ReportManager;
import com.vmware.vide.vwcsdktools.processors.AnnotationManager;
import com.vmware.vide.vwcsdktools.processors.IChecker;
import com.vmware.vide.vwcsdktools.processors.Results;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class VWCAnnotationProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                AnnotationMirror am = this.getAnnotationMirrorOnElement(typeElement, element);
                if (am == null) continue;
                IChecker checker = AnnotationManager.getChecker(am, this.processingEnv, roundEnv, element);
                Results results = checker.run(element);
                ReportManager.INSTANCE.report(results);
            }
        }
        return false;
    }

    private AnnotationMirror getAnnotationMirrorOnElement(TypeElement te, Element e) {
        for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
            if (!this.isSameType(te, annotationMirror)) continue;
            return annotationMirror;
        }
        return null;
    }

    private boolean isSameType(TypeElement te, AnnotationMirror am) {
        TypeMirror tm1 = te.asType();
        DeclaredType tm2 = am.getAnnotationType();
        return this.processingEnv.getTypeUtils().isSameType(tm1, tm2);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return AnnotationManager.getSupportedTypes();
    }
}

