/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.ui;

import com.vmware.vide.vwcsdktools.Activator;
import com.vmware.vide.vwcsdktools.managers.MetadataTagProjectDataManager;
import com.vmware.vide.vwcsdktools.ui.ISharedPage;
import com.vmware.vide.vwcsdktools.ui.WhiteListEditArea;
import com.vmware.vide.vwcsdktools.whitelist.WhiteListItem;
import com.vmware.vide.vwcsdktools.whitelist.WhiteListManager;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class VWCSDKToolsPreferencePage
extends PreferencePage
implements ISharedPage,
IWorkbenchPreferencePage {
    public static final String RUN_AT_SAVE_TEXT = "Enable metadata tag checker when saving .as files.";
    private Map<String, Set<String>> whiteLists;
    private WhiteListEditArea whiteListEditArea;

    public VWCSDKToolsPreferencePage() {
    }

    public VWCSDKToolsPreferencePage(String title) {
        super(title);
    }

    public VWCSDKToolsPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        final Button b = new Button(comp, 32);
        b.setText(RUN_AT_SAVE_TEXT);
        final IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        b.setSelection(store.getBoolean("com.vmware.vide.vwcsdktools.run-metadata-tag-checker-at-save"));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                store.setValue("com.vmware.vide.vwcsdktools.run-metadata-tag-checker-at-save", b.getSelection());
            }
        });
        this.whiteLists = MetadataTagProjectDataManager.INSTANCE.cloneWorkspaceWhiteLists();
        this.whiteListEditArea = new WhiteListEditArea(comp, this);
        return comp;
    }

    @Override
    public IProject getProject() {
        return null;
    }

    @Override
    public Map<String, Set<String>> getWhiteLists() {
        return this.whiteLists;
    }

    @Override
    public Shell getCurrentShell() {
        return this.getShell();
    }

    protected void performDefaults() {
        super.performDefaults();
        List<WhiteListItem> items = WhiteListManager.METADATA_TAG_INSTANCE.getDefaultWorkspaceWhiteList();
        this.whiteLists = new LinkedHashMap<String, Set<String>>();
        for (WhiteListItem item : items) {
            LinkedHashSet<String> list = new LinkedHashSet<String>(item.getList());
            this.whiteLists.put(item.getName(), list);
        }
        this.whiteListEditArea.inputToWhiteListNameViewer(this.whiteLists, true);
    }

    public boolean performOk() {
        MetadataTagProjectDataManager.INSTANCE.updateWorkspaceWhiteListTable(this.whiteLists);
        return true;
    }
}

