/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.ui;

import com.vmware.vide.vwcsdktools.Activator;
import com.vmware.vide.vwcsdktools.managers.MetadataTagProjectDataManager;
import com.vmware.vide.vwcsdktools.ui.ISharedPage;
import com.vmware.vide.vwcsdktools.ui.WhiteListEditArea;
import com.vmware.vide.vwcsdktools.utils.Property;
import com.vmware.vide.vwcsdktools.whitelist.WhiteListItem;
import com.vmware.vide.vwcsdktools.whitelist.WhiteListManager;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class VWCSDKToolsPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage,
ISharedPage {
    private Map<String, Set<String>> whiteLists;
    private WhiteListEditArea whiteListEditArea;

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        final Button b = new Button(comp, 32);
        b.setText("Use project settings for Metadata Tag Checker.");
        boolean use = this.getUseProjectSettings();
        b.setSelection(use);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VWCSDKToolsPropertyPage.this.setUseProjectSettings(b.getSelection());
                VWCSDKToolsPropertyPage.this.updateProjectGroup(b.getSelection());
            }
        });
        Composite group = new Composite(comp, 0);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = 5;
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalIndent = 20;
        group.setLayoutData((Object)gd);
        final Button b1 = new Button(group, 32);
        b1.setText("Enable metadata tag checker when saving .as files.");
        b1.setSelection(this.getRunAtSave());
        b1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VWCSDKToolsPropertyPage.this.setRunAtSave(b1.getSelection());
            }
        });
        this.whiteLists = MetadataTagProjectDataManager.INSTANCE.cloneProjectWhiteLists(this.getProject());
        this.whiteListEditArea = new WhiteListEditArea(group, this);
        this.whiteListEditArea.addProjectGroup((Control)b1);
        this.updateProjectGroup(this.getUseProjectSettings());
        return comp;
    }

    private void setUseProjectSettings(boolean use) {
        IProject project = this.getProject();
        if (project != null) {
            Property.setBoolean((IResource)project, "metadata-tag-checker-use-project-settings", use);
            StringBuilder sb = new StringBuilder();
            sb.append(project.getName()).append(":::").append(Boolean.toString(use));
            Activator.getDefault().getPreferenceStore().setValue("metadata-tag-checker-project-settings-switch", sb.toString());
        }
    }

    private boolean getUseProjectSettings() {
        IProject project = this.getProject();
        if (project != null) {
            return Property.getBoolean((IResource)project, "metadata-tag-checker-use-project-settings");
        }
        return false;
    }

    private void setRunAtSave(boolean b) {
        IProject project = this.getProject();
        if (project != null) {
            Property.setBoolean((IResource)project, "run-metadata-tag-checker-at-save", b);
        }
    }

    private boolean getRunAtSave() {
        IProject project = this.getProject();
        if (project != null) {
            return Property.getBoolean((IResource)project, "run-metadata-tag-checker-at-save", true);
        }
        return false;
    }

    @Override
    public IProject getProject() {
        IResource resource = (IResource)this.getElement().getAdapter(IResource.class);
        if (resource instanceof IProject) {
            return (IProject)resource;
        }
        return null;
    }

    @Override
    public Map<String, Set<String>> getWhiteLists() {
        return this.whiteLists;
    }

    @Override
    public Shell getCurrentShell() {
        return this.getShell();
    }

    private void updateProjectGroup(boolean b) {
        this.whiteListEditArea.updateProjectGroup(b);
    }

    public void performDefaults() {
        super.performDefaults();
        if (!this.getUseProjectSettings()) {
            return;
        }
        List<WhiteListItem> items = WhiteListManager.METADATA_TAG_INSTANCE.getDefaultWorkspaceWhiteList();
        this.whiteLists = new LinkedHashMap<String, Set<String>>();
        for (WhiteListItem item : items) {
            LinkedHashSet<String> list = new LinkedHashSet<String>(item.getList());
            this.whiteLists.put(item.getName(), list);
        }
        this.whiteListEditArea.inputToWhiteListNameViewer(this.whiteLists, true);
    }

    public boolean performOk() {
        if (this.getUseProjectSettings()) {
            MetadataTagProjectDataManager.INSTANCE.updateProjectWhiteListTable(this.getProject(), this.whiteLists);
        }
        return super.performOk();
    }
}

