/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network;

import com.vmware.vim.binding.vim.Network;
import com.vmware.vim.binding.vim.OpaqueNetwork;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DerivedPropertyData;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.DerivedPropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NetworkTypeDirevedPropertyProviderAdapter
implements DerivedPropertyProviderAdapter {
    private static final String OPAQUE_NETWORK_TYPE_PROP = "summary.opaqueNetworkType";
    private static final String NETWORK_TYPE_PROP = "networkType";
    private static final String NETWORK_TYPE_FORMATTED = "networkTypeFormatted";
    private static final String NSX_NETWORK_TYPE = "nsx.LogicalSwitch";
    private static final String HOST_NETWORK_TYPE = "HostNetwork";
    private static final String ANY_NETWORK_TYPE = "AnyNetwork";
    private static final int OPAQUE_NETWORK_TYPE_ORDER = 4;
    private static Map<Integer, String> networkTypesMap;

    public NetworkTypeDirevedPropertyProviderAdapter(DataServiceExtensionRegistry registry) {
        networkTypesMap = new HashMap<Integer, String>();
        networkTypesMap.put(1, NetworkStringUtil.getString("network.standard"));
        networkTypesMap.put(2, NetworkStringUtil.getString("network.distributed"));
        networkTypesMap.put(3, NetworkStringUtil.getString("network.uplink"));
        networkTypesMap.put(4, NetworkStringUtil.getString("network.ovs"));
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo opaqueNetworkTypeInfo = new TypeInfo();
        opaqueNetworkTypeInfo.type = OpaqueNetwork.class.getSimpleName();
        opaqueNetworkTypeInfo.properties = new String[]{NETWORK_TYPE_FORMATTED};
        TypeInfo distributedNetworkTypeInfo = new TypeInfo();
        distributedNetworkTypeInfo.type = DistributedVirtualPortgroup.class.getSimpleName();
        distributedNetworkTypeInfo.properties = new String[]{NETWORK_TYPE_FORMATTED};
        TypeInfo standardNetworkTypeInfo = new TypeInfo();
        standardNetworkTypeInfo.type = Network.class.getSimpleName();
        standardNetworkTypeInfo.properties = new String[]{NETWORK_TYPE_FORMATTED};
        TypeInfo uplinkNetworkTypeInfo = new TypeInfo();
        uplinkNetworkTypeInfo.type = DistributedVirtualPortgroup.class.getSimpleName();
        uplinkNetworkTypeInfo.properties = new String[]{NETWORK_TYPE_FORMATTED};
        TypeInfo anyNetworkTypeInfo = new TypeInfo();
        anyNetworkTypeInfo.type = ANY_NETWORK_TYPE;
        anyNetworkTypeInfo.properties = new String[]{NETWORK_TYPE_FORMATTED};
        TypeInfo hostNetworkTypeInfo = new TypeInfo();
        hostNetworkTypeInfo.type = HOST_NETWORK_TYPE;
        hostNetworkTypeInfo.properties = new String[]{NETWORK_TYPE_FORMATTED};
        DerivedPropertyInfo opaqueNetworkPropInfo = new DerivedPropertyInfo();
        opaqueNetworkPropInfo.propertyName = NETWORK_TYPE_FORMATTED;
        opaqueNetworkPropInfo.sourcePropertyNames = new String[]{NETWORK_TYPE_PROP, OPAQUE_NETWORK_TYPE_PROP};
        DerivedPropertyInfo standardNetworkPropInfo = new DerivedPropertyInfo();
        standardNetworkPropInfo.propertyName = NETWORK_TYPE_FORMATTED;
        standardNetworkPropInfo.sourcePropertyNames = new String[]{NETWORK_TYPE_PROP};
        DerivedPropertyInfo distributedNetworkPropInfo = new DerivedPropertyInfo();
        distributedNetworkPropInfo.propertyName = NETWORK_TYPE_FORMATTED;
        distributedNetworkPropInfo.sourcePropertyNames = new String[]{NETWORK_TYPE_PROP};
        DerivedPropertyInfo anyNetworkPropInfo = new DerivedPropertyInfo();
        anyNetworkPropInfo.propertyName = NETWORK_TYPE_FORMATTED;
        anyNetworkPropInfo.sourcePropertyNames = new String[]{NETWORK_TYPE_PROP};
        DerivedPropertyInfo hostNetworkPropInfo = new DerivedPropertyInfo();
        hostNetworkPropInfo.propertyName = NETWORK_TYPE_FORMATTED;
        hostNetworkPropInfo.sourcePropertyNames = new String[]{NETWORK_TYPE_PROP};
        opaqueNetworkTypeInfo.derivedProperties = new DerivedPropertyInfo[]{opaqueNetworkPropInfo};
        standardNetworkTypeInfo.derivedProperties = new DerivedPropertyInfo[]{standardNetworkPropInfo};
        distributedNetworkTypeInfo.derivedProperties = new DerivedPropertyInfo[]{distributedNetworkPropInfo};
        anyNetworkTypeInfo.derivedProperties = new DerivedPropertyInfo[]{anyNetworkPropInfo};
        hostNetworkTypeInfo.derivedProperties = new DerivedPropertyInfo[]{hostNetworkPropInfo};
        return new TypeInfo[]{opaqueNetworkTypeInfo, standardNetworkTypeInfo, distributedNetworkTypeInfo, anyNetworkTypeInfo, hostNetworkTypeInfo};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] objects = propertyRequest.objects;
        if (ArrayUtil.isNullOrEmpty((Object[])objects)) {
            return null;
        }
        Set<String> requestedProperties = this.getRequestedProperties(propertyRequest);
        ResultSet resultSet = new ResultSet();
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        DerivedPropertyData derivedPropertyData = propertyRequest.derivedPropertyData;
        Map sourcePropertyValues = derivedPropertyData.getSourcePropertyValuesByObject();
        if (sourcePropertyValues != null) {
            for (Object object : objects) {
                Map sourcePropertyValuesMap = (Map)sourcePropertyValues.get(object);
                if (sourcePropertyValuesMap == null) continue;
                ResultItem resultItem = new ResultItem();
                resultItem.resourceObject = object;
                ArrayList<PropertyValue> resultProperties = new ArrayList<PropertyValue>();
                if (requestedProperties.contains(NETWORK_TYPE_FORMATTED)) {
                    String formattedNetworkType = this.formatNetworkType(sourcePropertyValuesMap);
                    resultProperties.add(this.createPropertyValue(NETWORK_TYPE_FORMATTED, resultItem.resourceObject, formattedNetworkType));
                }
                resultItem.properties = resultProperties.toArray(new PropertyValue[resultProperties.size()]);
                resultItems.add(resultItem);
            }
        }
        resultSet.items = resultItems.toArray(new ResultItem[resultItems.size()]);
        return resultSet;
    }

    private PropertyValue createPropertyValue(String propertyName, Object resourceObject, String value) {
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.propertyName = propertyName;
        propertyValue.resourceObject = resourceObject;
        propertyValue.value = value;
        return propertyValue;
    }

    private Set<String> getRequestedProperties(PropertyRequestSpec propertyRequestSpec) {
        HashSet<String> requestedProperties = new HashSet<String>();
        if (ArrayUtil.isNullOrEmpty((Object[])propertyRequestSpec.properties)) {
            return requestedProperties;
        }
        for (PropertySpec propertySpec : propertyRequestSpec.properties) {
            if (propertySpec == null || ArrayUtil.isNullOrEmpty((Object[])propertySpec.propertyNames)) continue;
            for (String propertyName : propertySpec.propertyNames) {
                requestedProperties.add(propertyName);
            }
        }
        return requestedProperties;
    }

    private String formatNetworkType(Map<String, Object> sourcePropertyValuesMap) {
        int networkType = (Integer)NetworkTypeDirevedPropertyProviderAdapter.getPropertyValue(sourcePropertyValuesMap, NETWORK_TYPE_PROP);
        String formattedNetworkType = networkTypesMap.get(networkType);
        if (networkType == 4) {
            String opaqueNetworkType = (String)NetworkTypeDirevedPropertyProviderAdapter.getPropertyValue(sourcePropertyValuesMap, OPAQUE_NETWORK_TYPE_PROP);
            formattedNetworkType = NSX_NETWORK_TYPE.equals(opaqueNetworkType) ? NetworkStringUtil.getString("network.nsx") : formattedNetworkType;
        }
        return formattedNetworkType;
    }

    private static <T> T getPropertyValue(Map<String, Object> propertyValuesMap, String propName) {
        return (T)propertyValuesMap.get(propName);
    }
}

