/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvportgroup.create;

import com.vmware.vim.binding.vim.dvs.VmVnicNetworkResourcePool;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.h5.network.dvportgroup.create.model.CreateDvPortgroupProperties;
import com.vmware.vsphere.client.h5.network.dvportgroup.create.model.CreateDvPortgroupPropertiesData;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class CreateDvPortgroupParser {
    private CreateDvPortgroupParser() {
    }

    public static CreateDvPortgroupProperties getCreateDvPortgroupProperties(CreateDvPortgroupPropertiesData dvPortgroupData) {
        CreateDvPortgroupProperties properties = new CreateDvPortgroupProperties();
        CreateDvPortgroupParser.setNetworkResourcePool(dvPortgroupData, properties);
        CreateDvPortgroupParser.setVlanSettings(dvPortgroupData, properties);
        return properties;
    }

    private static void setNetworkResourcePool(CreateDvPortgroupPropertiesData dvPortgroupData, CreateDvPortgroupProperties properties) {
        if (dvPortgroupData == null) {
            return;
        }
        if (dvPortgroupData.niocVersion == null || dvPortgroupData.niocVersion != 2 && dvPortgroupData.niocVersion != 3) {
            properties.isNetworkResourcePoolSupported = false;
            return;
        }
        properties.isNetworkResourcePoolSupported = true;
        properties.isVmVnicResourcePoolSupported = dvPortgroupData.niocVersion == 3;
        ArrayList<CreateDvPortgroupProperties.NetworkResourcePool> networkResourcePools = new ArrayList<CreateDvPortgroupProperties.NetworkResourcePool>();
        properties.networkResourcePoolKey = "-1";
        if (properties.isVmVnicResourcePoolSupported) {
            if (!ArrayUtil.isNullOrEmpty((Object[])dvPortgroupData.vmVnicNetworkResourcePools)) {
                for (VmVnicNetworkResourcePool vmVnicNetworkResourcePool : dvPortgroupData.vmVnicNetworkResourcePools) {
                    networkResourcePools.add(CreateDvPortgroupParser.createResourcePool(vmVnicNetworkResourcePool.key, vmVnicNetworkResourcePool.name));
                }
            }
        } else if (!ArrayUtil.isNullOrEmpty((Object[])dvPortgroupData.networkResourcePools)) {
            for (VmVnicNetworkResourcePool vmVnicNetworkResourcePool : dvPortgroupData.networkResourcePools) {
                if (NetworkUtil.isSystemNetworkResourcePool(vmVnicNetworkResourcePool.key)) continue;
                networkResourcePools.add(CreateDvPortgroupParser.createResourcePool(vmVnicNetworkResourcePool.key, vmVnicNetworkResourcePool.name));
            }
        }
        if (networkResourcePools.size() > 1) {
            Collections.sort(networkResourcePools, new Comparator<CreateDvPortgroupProperties.NetworkResourcePool>(){

                @Override
                public int compare(CreateDvPortgroupProperties.NetworkResourcePool nrp1, CreateDvPortgroupProperties.NetworkResourcePool nrp2) {
                    return nrp1.name.compareToIgnoreCase(nrp2.name);
                }
            });
        }
        CreateDvPortgroupProperties.NetworkResourcePool defaultResourcePool = new CreateDvPortgroupProperties.NetworkResourcePool();
        defaultResourcePool.key = "-1";
        defaultResourcePool.name = NetworkStringUtil.getString("dvpg.policy.iorm.pool.none");
        networkResourcePools.add(0, defaultResourcePool);
        properties.networkResourcePools = networkResourcePools;
    }

    private static void setVlanSettings(CreateDvPortgroupPropertiesData dvPortgroupData, CreateDvPortgroupProperties properties) {
        if (dvPortgroupData == null) {
            return;
        }
        properties.pvlanConfig = dvPortgroupData.pvlanConfig;
    }

    private static CreateDvPortgroupProperties.NetworkResourcePool createResourcePool(String key, String name) {
        CreateDvPortgroupProperties.NetworkResourcePool resourcePool = new CreateDvPortgroupProperties.NetworkResourcePool();
        resourcePool.key = key;
        resourcePool.name = name;
        return resourcePool;
    }
}

