/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvportgroup.model.summary;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.dvs.VmVnicNetworkResourcePool;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.ManagedObjectNotFound;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vsphere.client.h5.network.dvportgroup.model.summary.DvPortgroupDetailsPortletData;
import com.vmware.vsphere.client.h5.network.dvportgroup.model.summary.DvPortgroupDetailsQueryBinding;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvPortgroupDetailsPortletPropertyProvider
implements PropertyProviderBean {
    private static final String PRIVILEGE_DVS_VIEW = "System.View";
    private final QueryBindingService _queryBindingService;
    private static final Log _logger = LogFactory.getLog(DvPortgroupDetailsPortletPropertyProvider.class);

    public DvPortgroupDetailsPortletPropertyProvider(QueryBindingService queryBindingService) {
        this._queryBindingService = queryBindingService;
    }

    @ModelMetadata(type={"DistributedVirtualPortgroup"}, propertyNamespace="dvpg", property="dvPortgroupDetails")
    public DvPortgroupDetailsPortletData getDvPortgroupDetails(ManagedObjectReference dvpgRef) throws Exception {
        DvPortgroupDetailsPortletData portletData = null;
        try {
            DvPortgroupDetailsQueryBinding detailsData = (DvPortgroupDetailsQueryBinding)((Object)this._queryBindingService.prepare(DvPortgroupDetailsQueryBinding.class).fetch((Object)dvpgRef));
            if (detailsData != null) {
                portletData = new DvPortgroupDetailsPortletData();
                portletData.ipPoolName = detailsData.ipPoolName;
                portletData.isUplink = detailsData.isUplink;
                portletData.numHosts = detailsData.numHosts;
                portletData.numVms = detailsData.numVms;
                if (detailsData.dvsDetails != null && detailsData.dvsDetails.provider != null) {
                    portletData.switchMor = (ManagedObjectReference)detailsData.dvsDetails.provider;
                    if (StringUtils.isNotEmpty((String)detailsData.dvsDetails.switchName)) {
                        portletData.switchName = detailsData.dvsDetails.switchName;
                        portletData.switchIconId = detailsData.dvsDetails.switchIconId;
                        portletData.showDvsData = true;
                        boolean bl = portletData.showNrp = detailsData.niocVersion >= 3;
                    }
                    if (detailsData.dvsDetails.dvsResourcePools != null && detailsData.resourcePoolKey != null) {
                        for (VmVnicNetworkResourcePool nrp : detailsData.dvsDetails.dvsResourcePools) {
                            if (nrp == null || !detailsData.resourcePoolKey.equals(nrp.key)) continue;
                            portletData.nrpName = nrp.name;
                            String switchIdentifier = String.format("%s_%s", portletData.switchMor.getServerGuid(), portletData.switchMor.getValue());
                            portletData.nrpMor = new ManagedObjectReference("NetworkResourcePool", switchIdentifier, detailsData.resourcePoolKey);
                        }
                    }
                }
            }
        }
        catch (ManagedObjectNotFound ex) {
            _logger.error((Object)"Error while trying to get details for dvPortGroup.Entity might have been deleted.", (Throwable)ex);
        }
        return portletData;
    }
}

