/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DerivedPropertyData;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.DerivedPropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.DvpgTrafficFilterParser;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.DvpgTrafficRuleModelBuilder;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.model.DvpgTrafficRuleModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvpgTrafficFilterPropertyProviderAdapter
implements DerivedPropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(DvpgTrafficFilterPropertyProviderAdapter.class);
    private static final String ANY_DISTRIBUTED_SWITCH = "AnyDistributedVirtualSwitch";
    private static final String IS_TRAFFIC_FILTER_SUPPORTED = "isTrafficFilterSupported";
    private static final String IS_TRAFFIC_CLONE_AVAILABLE = "isTrafficFilterCloneActionAvailable";
    private static final String TRAFFIC_RULE_MODEL = "trafficRuleModel";
    private static final String IS_FEATURE_SUPPORTED = "capability/featuresSupported/networkFilterSupported";
    private static final String TRAFFIC_FILTER_POLICY = "config/defaultPortConfig/filterPolicy";
    private static final String DVPG_DISTRIBUTED_SWITCH = "config/distributedVirtualSwitch";
    private QueryService _queryService;

    public DvpgTrafficFilterPropertyProviderAdapter(DataServiceExtensionRegistry registry, QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        DerivedPropertyInfo isFeatureSupportedPropInfo = new DerivedPropertyInfo();
        isFeatureSupportedPropInfo.propertyName = IS_TRAFFIC_FILTER_SUPPORTED;
        isFeatureSupportedPropInfo.sourcePropertyNames = new String[]{DVPG_DISTRIBUTED_SWITCH};
        DerivedPropertyInfo isCloneActionAvailPropInfo = new DerivedPropertyInfo();
        isCloneActionAvailPropInfo.propertyName = IS_TRAFFIC_CLONE_AVAILABLE;
        isCloneActionAvailPropInfo.sourcePropertyNames = new String[]{TRAFFIC_FILTER_POLICY};
        DerivedPropertyInfo trafficRuleModelPropInfo = new DerivedPropertyInfo();
        trafficRuleModelPropInfo.propertyName = TRAFFIC_RULE_MODEL;
        trafficRuleModelPropInfo.sourcePropertyNames = new String[]{TRAFFIC_FILTER_POLICY};
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = DistributedVirtualPortgroup.class.getSimpleName();
        typeInfo.properties = new String[]{IS_TRAFFIC_FILTER_SUPPORTED, IS_TRAFFIC_CLONE_AVAILABLE, TRAFFIC_RULE_MODEL};
        typeInfo.derivedProperties = new DerivedPropertyInfo[]{isFeatureSupportedPropInfo, isCloneActionAvailPropInfo, trafficRuleModelPropInfo};
        return new TypeInfo[]{typeInfo};
    }

    public com.vmware.vise.data.query.ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] objects = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        if (propertyRequest.objects.length > 1) {
            _logger.warn((Object)"The traffic filter properties in this property provider adapter are not optimized (and we do not expect to be used) for requests from multiple objects.");
        }
        HashSet<String> reqPropSet = new HashSet<String>();
        HashMap<String, Object> propParamsMap = new HashMap<String, Object>();
        for (PropertySpec propSpec : properties) {
            if (propSpec.parameters != null && propSpec.parameters.length > 0) {
                for (ParameterSpec propParam : propSpec.parameters) {
                    if (propParam.parameter == null) continue;
                    propParamsMap.put(propParam.propertyName, propParam.parameter);
                }
            }
            for (String propName : propSpec.propertyNames) {
                reqPropSet.add(propName);
            }
        }
        com.vmware.vise.data.query.ResultSet resultSet = new com.vmware.vise.data.query.ResultSet();
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        DerivedPropertyData derivedPropertyData = propertyRequest.derivedPropertyData;
        Map sourcePropertyValues = derivedPropertyData.getSourcePropertyValuesByObject();
        for (Object obj : objects) {
            Map sourcePropertyValuesMap = (Map)sourcePropertyValues.get(obj);
            if (sourcePropertyValuesMap == null) continue;
            ResultItem resItem = new ResultItem();
            resItem.resourceObject = obj;
            PropertyValue[] computedValues = this.computeResultSet(reqPropSet, sourcePropertyValuesMap, propParamsMap, resItem.resourceObject);
            resItem.properties = computedValues;
            resultItems.add(resItem);
        }
        resultSet.items = resultItems.toArray(new ResultItem[resultItems.size()]);
        return resultSet;
    }

    private PropertyValue[] computeResultSet(Set<String> reqProps, Map<String, Object> propertyValuesMap, Map<String, Object> propParamsMap, Object resourceObject) {
        ArrayList<PropertyValue> results = new ArrayList<PropertyValue>();
        if (reqProps.contains(IS_TRAFFIC_FILTER_SUPPORTED)) {
            this.computeIsTrafficFilterSupported(propertyValuesMap, results, resourceObject);
        }
        if (reqProps.contains(IS_TRAFFIC_CLONE_AVAILABLE)) {
            this.computeIsCloneActionAvailable(propertyValuesMap, results, resourceObject);
        }
        if (reqProps.contains(TRAFFIC_RULE_MODEL)) {
            this.computeTrafficFilterModel(propertyValuesMap, propParamsMap, results, resourceObject);
        }
        return results.toArray(new PropertyValue[0]);
    }

    private void computeIsTrafficFilterSupported(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> results, Object resourceObject) {
        ResultSet resultSet;
        ManagedObjectReference dvsRef = (ManagedObjectReference)propertyValuesMap.get(DVPG_DISTRIBUTED_SWITCH);
        boolean result = false;
        if (dvsRef != null && !(resultSet = this._queryService.select(new String[]{IS_FEATURE_SUPPORTED}).from(new String[]{ANY_DISTRIBUTED_SWITCH}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvsRef)}).fetch()).getItems().isEmpty()) {
            Boolean isTrafficFilterSupported = (Boolean)((ResourceItem)resultSet.getItems().get(0)).get(IS_FEATURE_SUPPORTED);
            result = isTrafficFilterSupported != null && isTrafficFilterSupported != false;
        }
        results.add(DvpgTrafficFilterPropertyProviderAdapter.createPropValue(IS_TRAFFIC_FILTER_SUPPORTED, result, resourceObject));
    }

    private void computeIsCloneActionAvailable(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> results, Object resourceObject) {
        DistributedVirtualPort.FilterPolicy filterPolicy = (DistributedVirtualPort.FilterPolicy)propertyValuesMap.get(TRAFFIC_FILTER_POLICY);
        boolean result = DvpgTrafficFilterParser.areTrafficRulesAvailable(filterPolicy);
        results.add(DvpgTrafficFilterPropertyProviderAdapter.createPropValue(IS_TRAFFIC_CLONE_AVAILABLE, result, resourceObject));
    }

    private void computeTrafficFilterModel(Map<String, Object> propertyValuesMap, Map<String, Object> propertyParamsMap, ArrayList<PropertyValue> results, Object resourceObject) {
        DistributedVirtualPort.FilterPolicy filterPolicy = (DistributedVirtualPort.FilterPolicy)propertyValuesMap.get(TRAFFIC_FILTER_POLICY);
        String ruleKey = (String)propertyParamsMap.get(TRAFFIC_RULE_MODEL);
        DvpgTrafficRuleModel model = DvpgTrafficRuleModelBuilder.getTrafficRuleModelByKey(filterPolicy, ruleKey);
        results.add(DvpgTrafficFilterPropertyProviderAdapter.createPropValue(TRAFFIC_RULE_MODEL, model, resourceObject));
    }

    private static PropertyValue createPropValue(String propName, Object propValue, Object resObject) {
        PropertyValue pv = new PropertyValue();
        pv.propertyName = propName;
        pv.value = propValue;
        pv.resourceObject = resObject;
        return pv;
    }
}

