/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.addhost;

import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.NetStackInstance;
import com.vmware.vim.binding.vim.host.OpaqueSwitch;
import com.vmware.vim.binding.vim.host.PortGroup;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.h5.network.dvs.addhost.DvsAddHostWizardUtil;
import com.vmware.vsphere.client.h5.network.dvs.addhost.hierarchicalList.DvsAddHostHierarchicalListGroupingItem;
import com.vmware.vsphere.client.h5.network.dvs.addhost.hierarchicalList.DvsAddHostHierarchicalListHostItem;
import com.vmware.vsphere.client.h5.network.dvs.addhost.hierarchicalList.DvsAddHostHierarchicalListItem;
import com.vmware.vsphere.client.h5.network.dvs.addhost.hierarchicalList.DvsAddHostHierarchicalListVnicItem;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.DvsHostVnicModel;
import com.vmware.vsphere.client.h5.network.dvs.addhost.util.DvsHostNicModelComparator;
import com.vmware.vsphere.client.h5.network.dvs.addhost.vnic.model.HostOpaqueNetworkData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.vnic.model.VirtualAdapterData;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DvsAddHostVnicParser {
    private static final String ON_THIS_SWITCH_ID = "-onThisSwitch-";
    private static final String ON_OTHER_SWITCHES_ID = "-onOtherSwitches-";

    public static Result parseHostVnics(Collection<DvsHostVnicModel> hostVnicDataObjects, boolean areMemberHosts, String dvsUuid) {
        if (hostVnicDataObjects == null || StringUtil.isNullOrEmpty((String)dvsUuid)) {
            return null;
        }
        DvsHostVnicModel[] dvsHostVnicModels = hostVnicDataObjects.toArray(new DvsHostVnicModel[hostVnicDataObjects.size()]);
        if (ArrayUtil.isNullOrEmpty((Object[])dvsHostVnicModels)) {
            return new Result();
        }
        DvsAddHostVnicParser.sortHostsAndVnics(dvsHostVnicModels);
        ArrayList<DvsAddHostHierarchicalListItem> treeListItems = new ArrayList<DvsAddHostHierarchicalListItem>();
        HashSet<String> distributedPortgroupKeys = new HashSet<String>();
        HashMap<String, List<DvsAddHostHierarchicalListVnicItem>> vnicsConnectedToDvPortgroups = new HashMap<String, List<DvsAddHostHierarchicalListVnicItem>>();
        for (DvsHostVnicModel hostVnicModel : dvsHostVnicModels) {
            DvsAddHostHierarchicalListHostItem hostItem = DvsAddHostVnicParser.createHostItem(hostVnicModel, areMemberHosts);
            if (hostItem == null) continue;
            treeListItems.add(hostItem);
            DvsAddHostHierarchicalListGroupingItem onThisSwitch = DvsAddHostVnicParser.createGroupingItem(hostItem.id, true);
            DvsAddHostHierarchicalListGroupingItem onOtherSwitches = DvsAddHostVnicParser.createGroupingItem(hostItem.id, false);
            treeListItems.add(onThisSwitch);
            treeListItems.add(onOtherSwitches);
            int orderOfVnicInHost = 0;
            if (ArrayUtil.isNullOrEmpty((Object[])hostVnicModel.vnics)) continue;
            Map<String, VirtualAdapterData> vnicMap = DvsAddHostVnicParser.createVnicMap(hostVnicModel);
            for (VirtualNic virtualNic : hostVnicModel.vnics) {
                VirtualAdapterData virtualAdapterData = vnicMap.get(virtualNic.device);
                DvsAddHostHierarchicalListVnicItem vnicItem = DvsAddHostVnicParser.createVnicItem(virtualAdapterData, onOtherSwitches.id, onThisSwitch.id, (ManagedObjectReference)hostVnicModel.provider, dvsUuid);
                if (virtualAdapterData != null && !StringUtil.isNullOrEmpty((String)virtualAdapterData.dvPortgroupKey)) {
                    distributedPortgroupKeys.add(virtualAdapterData.dvPortgroupKey);
                    String uniqueIdentifier = DvsAddHostVnicParser.getUniqueDvPortgroupIdentifier(virtualAdapterData.dvPortgroupKey, virtualAdapterData.dvsUuid);
                    ArrayList<DvsAddHostHierarchicalListVnicItem> nicItems = (ArrayList<DvsAddHostHierarchicalListVnicItem>)vnicsConnectedToDvPortgroups.get(uniqueIdentifier);
                    if (nicItems == null) {
                        nicItems = new ArrayList<DvsAddHostHierarchicalListVnicItem>();
                        vnicsConnectedToDvPortgroups.put(uniqueIdentifier, nicItems);
                    }
                    nicItems.add(vnicItem);
                }
                if (vnicItem == null) continue;
                vnicItem.orderInList = ++orderOfVnicInHost;
                treeListItems.add(vnicItem);
            }
        }
        Result result = new Result();
        result.treeListItems = treeListItems.toArray(new DvsAddHostHierarchicalListItem[treeListItems.size()]);
        result.distributedPortgroupKeys = new ArrayList<String>(distributedPortgroupKeys);
        result.vnicsConnectedToDvPortgroups = vnicsConnectedToDvPortgroups;
        return result;
    }

    public static String getUniqueDvPortgroupIdentifier(String portgroupKey, String dvsUuid) {
        if (portgroupKey == null) {
            throw new IllegalArgumentException("portgroupKey cannot be null");
        }
        if (dvsUuid == null) {
            throw new IllegalArgumentException("dvsUuid cannot be null");
        }
        return portgroupKey + ":" + dvsUuid;
    }

    private static DvsAddHostHierarchicalListVnicItem createVnicItem(VirtualAdapterData vnicData, String onOtherSwitchesId, String onThisSwitchId, ManagedObjectReference hostRef, String dvsUuid) {
        if (vnicData == null || StringUtil.isNullOrEmpty((String)vnicData.vnicName)) {
            return null;
        }
        String parentId = onOtherSwitchesId;
        if (vnicData.vswitch instanceof HostProxySwitch) {
            HostProxySwitch hostProxySwitch = (HostProxySwitch)vnicData.vswitch;
            if (dvsUuid.equals(hostProxySwitch.dvsUuid)) {
                parentId = onThisSwitchId;
            }
        }
        boolean isStandardSwitch = vnicData.vswitch instanceof VirtualSwitch;
        boolean isOpaqueSwitch = vnicData.vswitch instanceof OpaqueSwitch;
        boolean isOnManagementStack = vnicData.virtualNic.spec == null || vnicData.virtualNic.spec.netStackInstanceKey == null || vnicData.virtualNic.spec.netStackInstanceKey.equals(NetStackInstance.SystemStackKey.defaultTcpipStack.name());
        return new DvsAddHostHierarchicalListVnicItem(vnicData.vnicName, parentId + vnicData.vnicName, parentId, onThisSwitchId, vnicData.virtualNic.device, DvsAddHostVnicParser.getVswitchName(vnicData.vswitch), isStandardSwitch, isOpaqueSwitch, isOnManagementStack, hostRef, vnicData.portgroup, vnicData.vswitch instanceof VirtualSwitch, false);
    }

    private static String getVswitchName(Object vswitch) {
        String name = NetworkStringUtil.getString("na");
        if (vswitch instanceof VirtualSwitch) {
            VirtualSwitch virtualSwitch = (VirtualSwitch)vswitch;
            name = virtualSwitch.name;
        } else if (vswitch instanceof HostProxySwitch) {
            HostProxySwitch hostProxySwitch = (HostProxySwitch)vswitch;
            name = hostProxySwitch.dvsName;
        } else if (vswitch instanceof OpaqueSwitch) {
            OpaqueSwitch opaqueSwitch = (OpaqueSwitch)vswitch;
            name = opaqueSwitch.name;
        }
        return name;
    }

    private static void sortHostsAndVnics(DvsHostVnicModel[] hostVnicModels) {
        Arrays.sort(hostVnicModels, new DvsHostNicModelComparator());
        for (DvsHostVnicModel hostVnicModel : hostVnicModels) {
            if (hostVnicModel == null) continue;
            DvsAddHostVnicParser.sortVnics(hostVnicModel.vnics);
        }
    }

    private static void sortVnics(VirtualNic[] vnics) {
        if (ArrayUtil.isNullOrEmpty((Object[])vnics)) {
            return;
        }
        Arrays.sort(vnics, new Comparator<VirtualNic>(){

            @Override
            public int compare(VirtualNic vnic1, VirtualNic vnic2) {
                if (vnic1 == null || vnic1.device == null) {
                    return -1;
                }
                if (vnic2 == null || vnic2.device == null) {
                    return 1;
                }
                String vnic1Device = vnic1.device;
                String vnic2Device = vnic2.device;
                return NetworkUtil.compareNicDevices(vnic1Device, vnic2Device, "vmk");
            }
        });
    }

    private static Map<String, VirtualAdapterData> createVnicMap(DvsHostVnicModel hostVnicModel) {
        HashMap<String, VirtualAdapterData> resultMap = new HashMap<String, VirtualAdapterData>();
        Map<String, HostProxySwitch> proxySwitchMap = DvsAddHostVnicParser.createProxySwitchMap(hostVnicModel.proxySwitches);
        Map<String, HostOpaqueNetworkData> opaqueNetworkMap = DvsAddHostWizardUtil.createOpaqueNetworkMap(hostVnicModel.opaqueNetwork, hostVnicModel.opaqueSwitches);
        Map<String, PortGroup> keyToPortgroupMap = DvsAddHostVnicParser.createKeyToPortgroupMap(hostVnicModel.portGroups);
        if (!ArrayUtil.isNullOrEmpty((Object[])hostVnicModel.vnics)) {
            for (VirtualNic virtualNic : hostVnicModel.vnics) {
                VirtualAdapterData virtualAdapterData = DvsAddHostVnicParser.createVnicAdapterData(virtualNic, proxySwitchMap, opaqueNetworkMap);
                if (virtualAdapterData == null) continue;
                resultMap.put(virtualNic.device, virtualAdapterData);
            }
        }
        DvsAddHostVnicParser.populateStandardSwitchData(hostVnicModel.vswitches, keyToPortgroupMap, hostVnicModel.vnics, resultMap);
        return resultMap;
    }

    private static VirtualAdapterData createVnicAdapterData(VirtualNic vnic, Map<String, HostProxySwitch> proxySwitchMap, Map<String, HostOpaqueNetworkData> opaqueNetworkMap) {
        if (vnic == null || StringUtil.isNullOrEmpty((String)vnic.device)) {
            return null;
        }
        VirtualAdapterData vnicData = new VirtualAdapterData();
        vnicData.virtualNic = vnic;
        vnicData.vnicName = vnic.device;
        vnicData.portgroup = vnic.portgroup;
        if (vnic.spec != null) {
            String opaqueNetworkKey;
            HostOpaqueNetworkData opaqueNetworkData;
            if (vnic.spec.distributedVirtualPort != null) {
                HostProxySwitch proxyswitch = proxySwitchMap.get(vnic.spec.distributedVirtualPort.switchUuid);
                if (proxyswitch != null) {
                    vnicData.vswitch = proxyswitch;
                }
                String portgroupKey = vnic.spec.distributedVirtualPort.portgroupKey;
                String dvsUuid = vnic.spec.distributedVirtualPort.switchUuid;
                String portKey = vnic.spec.distributedVirtualPort.portKey;
                if (!StringUtil.isNullOrEmpty((String)portgroupKey)) {
                    vnicData.dvPortgroupKey = portgroupKey;
                    vnicData.dvsUuid = dvsUuid;
                    vnicData.portgroup = "";
                } else if (!StringUtil.isNullOrEmpty((String)portKey)) {
                    vnicData.portgroup = NetworkStringUtil.getString("SelectVirtualAdaptersPage.portId", portKey);
                }
            } else if (vnic.spec.opaqueNetwork != null && (opaqueNetworkData = opaqueNetworkMap.get(opaqueNetworkKey = DvsAddHostWizardUtil.constructOpaqueNetworkKey(vnic.spec.opaqueNetwork.opaqueNetworkId, vnic.spec.opaqueNetwork.opaqueNetworkType))) != null) {
                vnicData.vswitch = opaqueNetworkData.opaqueSwitch;
                vnicData.portgroup = opaqueNetworkData.getLongNetworkLabel();
            }
        }
        if (StringUtil.isNullOrEmpty((String)vnicData.portgroup)) {
            vnicData.portgroup = NetworkStringUtil.getString("na");
        }
        return vnicData;
    }

    private static void populateStandardSwitchData(VirtualSwitch[] virtualSwitches, Map<String, PortGroup> keyToPortgroupMap, VirtualNic[] vnics, Map<String, VirtualAdapterData> vnicMap) {
        if (!ArrayUtil.isNullOrEmpty((Object[])virtualSwitches)) {
            for (VirtualSwitch vSwitch : virtualSwitches) {
                if (vSwitch == null || ArrayUtil.isNullOrEmpty((Object[])vSwitch.portgroup)) continue;
                for (String portgroupKey : vSwitch.portgroup) {
                    VirtualAdapterData vnicData;
                    PortGroup portgroup = DvsAddHostVnicParser.getPortgroupForKey(keyToPortgroupMap, portgroupKey);
                    if (portgroup == null) continue;
                    VirtualNic vnic = null;
                    String pgName = null;
                    if (portgroup != null && portgroup.spec != null) {
                        pgName = portgroup.spec.name;
                    }
                    for (VirtualNic virtualNic : vnics) {
                        if (pgName == null || !pgName.equals(virtualNic.portgroup)) continue;
                        vnic = virtualNic;
                        break;
                    }
                    if (vnic == null || StringUtil.isNullOrEmpty((String)vnic.device) || (vnicData = vnicMap.get(vnic.device)) == null) continue;
                    vnicData.vswitch = vSwitch;
                }
            }
        }
    }

    private static PortGroup getPortgroupForKey(Map<String, PortGroup> keyToPortgroupMap, String pgKey) {
        for (Map.Entry<String, PortGroup> entry : keyToPortgroupMap.entrySet()) {
            if (!StringUtils.endsWith((String)pgKey, (String)entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    private static Map<String, HostProxySwitch> createProxySwitchMap(HostProxySwitch[] proxySwitches) {
        HashMap<String, HostProxySwitch> resultMap = new HashMap<String, HostProxySwitch>();
        if (!ArrayUtil.isNullOrEmpty((Object[])proxySwitches)) {
            for (HostProxySwitch proxySwitch : proxySwitches) {
                if (proxySwitch == null || StringUtil.isNullOrEmpty((String)proxySwitch.dvsUuid)) continue;
                resultMap.put(proxySwitch.dvsUuid, proxySwitch);
            }
        }
        return resultMap;
    }

    private static Map<String, PortGroup> createKeyToPortgroupMap(PortGroup[] portGroups) {
        HashMap<String, PortGroup> resultMap = new HashMap<String, PortGroup>();
        if (!ArrayUtil.isNullOrEmpty((Object[])portGroups)) {
            for (PortGroup portgroup : portGroups) {
                if (portgroup == null || StringUtil.isNullOrEmpty((String)portgroup.key)) continue;
                resultMap.put(portgroup.key, portgroup);
            }
        }
        return resultMap;
    }

    private static DvsAddHostHierarchicalListHostItem createHostItem(DvsHostVnicModel hostVnicModel, boolean isMemberHost) {
        if (hostVnicModel == null || hostVnicModel.provider == null || !(hostVnicModel.provider instanceof ManagedObjectReference) || StringUtil.isNullOrEmpty((String)hostVnicModel.name)) {
            return null;
        }
        DvsAddHostHierarchicalListHostItem hostItem = new DvsAddHostHierarchicalListHostItem(hostVnicModel.name, hostVnicModel.provider.toString(), null, (ManagedObjectReference)hostVnicModel.provider, isMemberHost);
        return hostItem;
    }

    private static DvsAddHostHierarchicalListGroupingItem createGroupingItem(String parentId, boolean onThisSwitch) {
        String id = parentId + (onThisSwitch ? ON_THIS_SWITCH_ID : ON_OTHER_SWITCHES_ID);
        DvsAddHostHierarchicalListGroupingItem groupingItem = new DvsAddHostHierarchicalListGroupingItem(onThisSwitch, id, parentId);
        return groupingItem;
    }

    public static class Result {
        public DvsAddHostHierarchicalListItem[] treeListItems;
        public List<String> distributedPortgroupKeys = new ArrayList<String>();
        public Map<String, List<DvsAddHostHierarchicalListVnicItem>> vnicsConnectedToDvPortgroups;
    }
}

