/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.addhost;

import com.vmware.vim.binding.vim.OpaqueNetwork;
import com.vmware.vim.binding.vim.host.OpaqueNetworkInfo;
import com.vmware.vim.binding.vim.host.OpaqueSwitch;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.h5.network.dvs.addhost.vnic.model.HostOpaqueNetworkData;
import java.util.HashMap;
import java.util.Map;

public class DvsAddHostWizardUtil {
    public static Map<String, HostOpaqueNetworkData> createOpaqueNetworkMap(OpaqueNetworkInfo[] opaqueNetworkInfos, OpaqueSwitch[] opaqueSwitches) {
        HashMap<String, HostOpaqueNetworkData> resultMap = new HashMap<String, HostOpaqueNetworkData>();
        if (!ArrayUtil.isNullOrEmpty((Object[])opaqueNetworkInfos)) {
            for (OpaqueNetworkInfo opaqueNetwork : opaqueNetworkInfos) {
                OpaqueSwitch opaqueSwitch;
                HostOpaqueNetworkData hostOpaqueNetworkData = new HostOpaqueNetworkData();
                hostOpaqueNetworkData.networkName = opaqueNetwork.opaqueNetworkName;
                hostOpaqueNetworkData.networkType = opaqueNetwork.opaqueNetworkType;
                String opaqueNetworkKey = DvsAddHostWizardUtil.constructOpaqueNetworkKey(opaqueNetwork.opaqueNetworkId, opaqueNetwork.opaqueNetworkType);
                resultMap.put(opaqueNetworkKey, hostOpaqueNetworkData);
                if (ArrayUtil.isNullOrEmpty((Object[])opaqueSwitches) || (opaqueSwitch = DvsAddHostWizardUtil.getOpaqueSwitchByOpaqueNetwork(opaqueNetwork, opaqueSwitches)) == null) continue;
                hostOpaqueNetworkData.switchKey = opaqueSwitch.key;
                hostOpaqueNetworkData.switchName = opaqueSwitch.name;
                hostOpaqueNetworkData.opaqueSwitch = opaqueSwitch;
            }
        }
        return resultMap;
    }

    public static String constructOpaqueNetworkKey(String opaqueNetworkId, String opaqueNetworkType) {
        if (opaqueNetworkId == null) {
            throw new IllegalArgumentException("opaqueNetworkId cannot be null");
        }
        if (opaqueNetworkType == null) {
            throw new IllegalArgumentException("opaqueNetworkType cannot be null");
        }
        return opaqueNetworkId + "-" + opaqueNetworkType;
    }

    public static OpaqueSwitch getOpaqueSwitchByOpaqueNetwork(OpaqueNetworkInfo opaqueNetwork, OpaqueSwitch[] opaqueSwitches) {
        if (opaqueNetwork == null || ArrayUtil.isNullOrEmpty((Object[])opaqueSwitches)) {
            return null;
        }
        for (OpaqueSwitch opaqueSwitch : opaqueSwitches) {
            if (!DvsAddHostWizardUtil.checkOpaqueSwitchOwnership(opaqueNetwork, opaqueSwitch)) continue;
            return opaqueSwitch;
        }
        return null;
    }

    public static OpaqueNetworkInfo getOpaqueNetworkByTypeAndId(OpaqueNetworkInfo[] opaqueNetworks, OpaqueNetwork.Summary opaqueNetworkSummary) {
        if (ArrayUtil.isNullOrEmpty((Object[])opaqueNetworks) || opaqueNetworkSummary == null) {
            return null;
        }
        String opaqueNetworkId = opaqueNetworkSummary.opaqueNetworkId;
        String opaqueNetworkType = opaqueNetworkSummary.opaqueNetworkType;
        for (OpaqueNetworkInfo opaqueNetworkInfo : opaqueNetworks) {
            if (!opaqueNetworkInfo.opaqueNetworkId.equals(opaqueNetworkId) || !opaqueNetworkInfo.opaqueNetworkType.equals(opaqueNetworkType)) continue;
            return opaqueNetworkInfo;
        }
        return null;
    }

    public static boolean checkOpaqueSwitchOwnership(OpaqueNetworkInfo opaqueNetwork, OpaqueSwitch opaqueSwitch) {
        if (opaqueNetwork == null || opaqueSwitch == null) {
            return false;
        }
        Object[] opaqueNetworkZoneIds = opaqueNetwork.pnicZone;
        Object[] opaqueSwitchZones = opaqueSwitch.pnicZone;
        if (ArrayUtil.isNullOrEmpty((Object[])opaqueNetworkZoneIds) || ArrayUtil.isNullOrEmpty((Object[])opaqueSwitchZones)) {
            return false;
        }
        for (Object opaqueNetworkZoneId : opaqueNetworkZoneIds) {
            boolean found = false;
            for (Object opaqueSwitchZone : opaqueSwitchZones) {
                if (opaqueNetworkZoneId == null || opaqueSwitchZone == null || !((String)opaqueNetworkZoneId).equals(((OpaqueSwitch.PhysicalNicZone)opaqueSwitchZone).key)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static boolean isSecondaryVm(int ftRole) {
        return ftRole > 1;
    }

    public static boolean isPrimaryVm(int ftRole) {
        return ftRole == 1;
    }
}

