/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.addhost.spec;

import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.dvs.HostMember;
import com.vmware.vim.binding.vim.dvs.PortConnection;
import com.vmware.vim.binding.vim.dvs.PortCriteria;
import com.vmware.vim.binding.vim.host.ConfigChange;
import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.NetworkConfig;
import com.vmware.vim.binding.vim.host.NetworkPolicy;
import com.vmware.vim.binding.vim.host.PortGroup;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vim.binding.vim.vm.ConfigSpec;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualDeviceSpec;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.common.compositecommand.api.spec.BaseCommandSpec;
import com.vmware.vsphere.client.common.compositecommand.api.spec.DummyCommandSpec;
import com.vmware.vsphere.client.dvs.api.spec.DvsReconfigureCommandSpec;
import com.vmware.vsphere.client.dvs.api.spec.FetchDvPortsCommandSpec;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.DvsAddAndManageHostsSpec;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.PnicAssignmentSpec;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.VmVnicAssignmentSpec;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.VnicAssignmentSpec;
import com.vmware.vsphere.client.h5.network.dvs.addhost.spec.HostData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.spec.HostNetworkModel;
import com.vmware.vsphere.client.h5.network.dvs.addhost.spec.HostUpdateData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.spec.PnicUpdateData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.spec.VSwitchUpdateData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.spec.VnicUpdateData;
import com.vmware.vsphere.client.network.host.api.spec.NetSysUpdateNetConfigCommandSpec;
import com.vmware.vsphere.client.network.vm.api.spec.VmReconfigureCommandSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class DvsAddHostSpecFactory {
    public static BaseCommandSpec createDvsAddHostSpec(ManagedObjectReference dvsRef, DvsAddAndManageHostsSpec dvsAddAndManageHostsSpec, String dvsUuid, Collection<HostNetworkModel> hostNetworkModelsCollection, PropertyValue[] dvPortgroupKeys, PropertyValue[] vmDevices, boolean areMemberHosts) {
        DummyCommandSpec rootCommandSpec;
        if (dvsRef == null) {
            throw new IllegalArgumentException("dvsRef cannot be null");
        }
        if (dvsAddAndManageHostsSpec == null) {
            throw new IllegalArgumentException("dvsAddAndManageHostsSpec cannot be null");
        }
        if (StringUtil.isNullOrEmpty((String)dvsUuid)) {
            throw new IllegalArgumentException("dvsUuid cannot be null");
        }
        HostNetworkModel[] hostNetworkModels = hostNetworkModelsCollection.toArray(new HostNetworkModel[hostNetworkModelsCollection.size()]);
        Map<String, HostData> hostDataMap = DvsAddHostSpecFactory.createHostDataMap(hostNetworkModels);
        Map<String, HostUpdateData> hostUpdateDataMap = DvsAddHostSpecFactory.createHostUpdateDataMap(hostNetworkModels);
        Map<ManagedObjectReference, String> portgroupRefToKeyMap = DvsAddHostSpecFactory.createPortgroupToKeyMap(dvPortgroupKeys);
        Map<ManagedObjectReference, Map<Integer, VirtualEthernetCard>> vmDeviceMap = DvsAddHostSpecFactory.createVmDeviceMap(vmDevices);
        DvsAddHostSpecFactory.applyPnicAssignments(dvsAddAndManageHostsSpec.pnicAssignmentSpecs, hostUpdateDataMap);
        DvsAddHostSpecFactory.applyVnicAssignments(dvsAddAndManageHostsSpec.vnicAssignmentSpecs, hostUpdateDataMap, portgroupRefToKeyMap);
        for (Map.Entry<String, HostUpdateData> entry : hostUpdateDataMap.entrySet()) {
            String hostString = entry.getKey();
            HostUpdateData hostUpdateData = entry.getValue();
            if (areMemberHosts) {
                hostUpdateData.buildManageHostNetworkConfigUpdateData(dvsUuid, hostDataMap.get(hostString));
                continue;
            }
            hostUpdateData.buildVSwitchAndPnicMaps(hostDataMap.get(hostString), dvsUuid);
        }
        if (!areMemberHosts) {
            rootCommandSpec = DvsAddHostSpecFactory.buildDvsReconfigCommand(dvsRef, dvsAddAndManageHostsSpec.dvsConfigVersion, dvsAddAndManageHostsSpec.hosts);
        } else {
            rootCommandSpec = new DummyCommandSpec();
            rootCommandSpec.mor = dvsRef;
        }
        FetchDvPortsCommandSpec fetchDvPortsCommandSpec = DvsAddHostSpecFactory.buildFetchPortsCommand(dvsRef, (BaseCommandSpec)rootCommandSpec);
        Map<ManagedObjectReference, NetSysUpdateNetConfigCommandSpec> hostRefToUpdateSpec = DvsAddHostSpecFactory.buildHostReconfigCommands(hostUpdateDataMap.values().toArray(new HostUpdateData[0]), hostDataMap, dvsUuid, fetchDvPortsCommandSpec, portgroupRefToKeyMap, areMemberHosts);
        DvsAddHostSpecFactory.buildVmReconfigCommands(dvsAddAndManageHostsSpec.vmVnicAssignmentSpecs, hostRefToUpdateSpec, portgroupRefToKeyMap, vmDeviceMap, dvsUuid, fetchDvPortsCommandSpec);
        return rootCommandSpec;
    }

    private static Map<ManagedObjectReference, Map<Integer, VirtualEthernetCard>> createVmDeviceMap(PropertyValue[] vmDevices) {
        HashMap<ManagedObjectReference, Map<Integer, VirtualEthernetCard>> result = new HashMap<ManagedObjectReference, Map<Integer, VirtualEthernetCard>>();
        if (vmDevices != null) {
            for (PropertyValue propertyValue : vmDevices) {
                if (propertyValue == null || propertyValue.value == null || propertyValue.resourceObject == null || !(propertyValue.resourceObject instanceof ManagedObjectReference)) continue;
                ManagedObjectReference vmRef = (ManagedObjectReference)propertyValue.resourceObject;
                HashMap<Integer, VirtualEthernetCard> devicesMap = new HashMap<Integer, VirtualEthernetCard>();
                result.put(vmRef, devicesMap);
                if (propertyValue.value == null || !(propertyValue.value instanceof VirtualDevice[])) continue;
                for (VirtualDevice virtualDevice : (VirtualDevice[])propertyValue.value) {
                    if (!(virtualDevice instanceof VirtualEthernetCard)) continue;
                    devicesMap.put(virtualDevice.key, (VirtualEthernetCard)virtualDevice);
                }
            }
        }
        return result;
    }

    private static Map<ManagedObjectReference, String> createPortgroupToKeyMap(PropertyValue[] dvPortgroupKeys) {
        HashMap<ManagedObjectReference, String> result = new HashMap<ManagedObjectReference, String>();
        if (dvPortgroupKeys != null) {
            for (PropertyValue propertyValue : dvPortgroupKeys) {
                if (propertyValue == null || propertyValue.value == null || !(propertyValue.value instanceof String) || propertyValue.resourceObject == null || !(propertyValue.resourceObject instanceof ManagedObjectReference)) continue;
                ManagedObjectReference portgroupRef = (ManagedObjectReference)propertyValue.resourceObject;
                String key = (String)propertyValue.value;
                result.put(portgroupRef, key);
            }
        }
        return result;
    }

    private static DvsReconfigureCommandSpec buildDvsReconfigCommand(ManagedObjectReference dvsRef, String dvsConfigVersion, ManagedObjectReference[] hosts) {
        DvsReconfigureCommandSpec dvsReconfigCommandSpec = new DvsReconfigureCommandSpec();
        dvsReconfigCommandSpec.configSpec = new DistributedVirtualSwitch.ConfigSpec();
        dvsReconfigCommandSpec.configSpec.configVersion = dvsConfigVersion;
        LinkedList<HostMember.ConfigSpec> configSpecs = new LinkedList<HostMember.ConfigSpec>();
        for (ManagedObjectReference hostRef : hosts) {
            if (hostRef == null) continue;
            HostMember.ConfigSpec configSpec = new HostMember.ConfigSpec();
            configSpec.host = hostRef;
            configSpec.operation = ConfigChange.Operation.add.toString();
            configSpecs.add(configSpec);
        }
        dvsReconfigCommandSpec.configSpec.host = configSpecs.toArray(new HostMember.ConfigSpec[configSpecs.size()]);
        dvsReconfigCommandSpec.mor = dvsRef;
        dvsReconfigCommandSpec.isResultTaskProvider = true;
        return dvsReconfigCommandSpec;
    }

    private static FetchDvPortsCommandSpec buildFetchPortsCommand(ManagedObjectReference dvsRef, BaseCommandSpec parentCommandSpec) {
        FetchDvPortsCommandSpec fetchPortsCommandSpec = new FetchDvPortsCommandSpec();
        fetchPortsCommandSpec.mor = dvsRef;
        PortCriteria portCriteria = new PortCriteria();
        portCriteria.uplinkPort = true;
        fetchPortsCommandSpec.portCriteria = portCriteria;
        parentCommandSpec.dependentSpecs = new FetchDvPortsCommandSpec[]{fetchPortsCommandSpec};
        return fetchPortsCommandSpec;
    }

    private static Map<ManagedObjectReference, NetSysUpdateNetConfigCommandSpec> buildHostReconfigCommands(HostUpdateData[] hostUpdateDataArray, Map<String, HostData> hostDataMap, String dvsUuid, FetchDvPortsCommandSpec fetchDvPortsCommandSpec, Map<ManagedObjectReference, String> portgroupRefToKeyMap, Boolean areMemberHosts) {
        HashMap<ManagedObjectReference, NetSysUpdateNetConfigCommandSpec> hostRefToUpdateSpec = new HashMap<ManagedObjectReference, NetSysUpdateNetConfigCommandSpec>();
        fetchDvPortsCommandSpec.dependentSpecs = new BaseCommandSpec[0];
        for (HostUpdateData hostUpdateData : hostUpdateDataArray) {
            NetworkConfig networkConfig = new NetworkConfig();
            DvsAddHostSpecFactory.updateVswitches(hostUpdateData, networkConfig, dvsUuid);
            HostData hostData = hostDataMap.get(hostUpdateData.getHostRef().toString());
            if (hostData == null) continue;
            if (!areMemberHosts.booleanValue()) {
                networkConfig.proxySwitch = (HostProxySwitch.Config[])ArrayUtils.add((Object[])networkConfig.proxySwitch, (Object)DvsAddHostSpecFactory.createHostProxySwitchConfig(hostUpdateData, dvsUuid));
            }
            DvsAddHostSpecFactory.buildVnicMigrationSpecs(networkConfig, hostUpdateData, dvsUuid);
            NetSysUpdateNetConfigCommandSpec netSysUpdateNetConfigCommandSpec = new NetSysUpdateNetConfigCommandSpec();
            netSysUpdateNetConfigCommandSpec.hostRef = hostUpdateData.getHostRef();
            netSysUpdateNetConfigCommandSpec.mor = hostData.getNetworkSystem();
            netSysUpdateNetConfigCommandSpec.networkConfig = networkConfig;
            ArrayList<String> modifiedPnics = new ArrayList<String>();
            modifiedPnics.addAll(hostUpdateData.getPnicsToAddMap().keySet());
            modifiedPnics.addAll(hostUpdateData.getPnicsToUpdate().keySet());
            netSysUpdateNetConfigCommandSpec.modifiedPnics = modifiedPnics.toArray(new String[modifiedPnics.size()]);
            fetchDvPortsCommandSpec.dependentSpecs = (BaseCommandSpec[])ArrayUtils.add((Object[])fetchDvPortsCommandSpec.dependentSpecs, (Object)netSysUpdateNetConfigCommandSpec);
            hostRefToUpdateSpec.put(netSysUpdateNetConfigCommandSpec.hostRef, netSysUpdateNetConfigCommandSpec);
        }
        return hostRefToUpdateSpec;
    }

    private static void buildVmReconfigCommands(VmVnicAssignmentSpec[] vmVnicAssignmentSpecs, Map<ManagedObjectReference, NetSysUpdateNetConfigCommandSpec> hostRefToUpdateSpec, Map<ManagedObjectReference, String> portgroupRefToKeyMap, Map<ManagedObjectReference, Map<Integer, VirtualEthernetCard>> vmDeviceMap, String switchUuid, FetchDvPortsCommandSpec fetchDvPortsCommandSpec) {
        if (ArrayUtil.isNullOrEmpty((Object[])vmVnicAssignmentSpecs) || hostRefToUpdateSpec == null || portgroupRefToKeyMap == null) {
            return;
        }
        HashMap<ManagedObjectReference, ArrayList<VmVnicAssignmentSpec>> vmRefToAssignmentSpecs = new HashMap<ManagedObjectReference, ArrayList<VmVnicAssignmentSpec>>();
        for (VmVnicAssignmentSpec vmVnicAssignmentSpec : vmVnicAssignmentSpecs) {
            if (vmVnicAssignmentSpec == null || vmVnicAssignmentSpec.distributedPortgroupRef == null || vmVnicAssignmentSpec.host == null || vmVnicAssignmentSpec.vm == null) continue;
            ArrayList<VmVnicAssignmentSpec> specs = (ArrayList<VmVnicAssignmentSpec>)vmRefToAssignmentSpecs.get(vmVnicAssignmentSpec.vm);
            if (specs == null) {
                specs = new ArrayList<VmVnicAssignmentSpec>();
                vmRefToAssignmentSpecs.put(vmVnicAssignmentSpec.vm, specs);
            }
            specs.add(vmVnicAssignmentSpec);
        }
        for (Map.Entry entry : vmRefToAssignmentSpecs.entrySet()) {
            ManagedObjectReference vmRef = (ManagedObjectReference)entry.getKey();
            List assignmentSpecs = (List)entry.getValue();
            if (assignmentSpecs == null || assignmentSpecs.isEmpty()) continue;
            ConfigSpec configSpec = new ConfigSpec();
            VmReconfigureCommandSpec vmReconfigureCommandSpec = new VmReconfigureCommandSpec();
            vmReconfigureCommandSpec.configSpec = configSpec;
            vmReconfigureCommandSpec.mor = vmRef;
            ManagedObjectReference hostRef = null;
            for (VmVnicAssignmentSpec vmVnicAssignmentSpec : assignmentSpecs) {
                VirtualEthernetCard virtualEthernetCard;
                if (vmVnicAssignmentSpec == null || (virtualEthernetCard = vmDeviceMap.get(vmRef).get(vmVnicAssignmentSpec.key)) == null) continue;
                hostRef = vmVnicAssignmentSpec.host;
                configSpec.changeVersion = vmVnicAssignmentSpec.changeVersion;
                VirtualDeviceSpec virtualDeviceSpec = new VirtualDeviceSpec();
                virtualDeviceSpec.operation = VirtualDeviceSpec.Operation.edit;
                virtualDeviceSpec.device = virtualEthernetCard;
                configSpec.deviceChange = (VirtualDeviceSpec[])ArrayUtils.add((Object[])configSpec.deviceChange, (Object)virtualDeviceSpec);
                VirtualEthernetCard.DistributedVirtualPortBackingInfo dvpbi = new VirtualEthernetCard.DistributedVirtualPortBackingInfo();
                dvpbi.port = new PortConnection();
                dvpbi.port.portgroupKey = portgroupRefToKeyMap.get(vmVnicAssignmentSpec.distributedPortgroupRef);
                dvpbi.port.switchUuid = switchUuid;
                virtualDeviceSpec.device.backing = dvpbi;
            }
            BaseCommandSpec parentSpec = (BaseCommandSpec)hostRefToUpdateSpec.get(hostRef);
            if (parentSpec == null) {
                parentSpec = fetchDvPortsCommandSpec;
            }
            if (parentSpec == null) continue;
            parentSpec.dependentSpecs = (BaseCommandSpec[])ArrayUtils.add((Object[])parentSpec.dependentSpecs, (Object)vmReconfigureCommandSpec);
        }
    }

    private static void buildVnicMigrationSpecs(NetworkConfig networkConfig, HostUpdateData hostUpdateData, String dvsUuid) {
        for (VnicUpdateData vnicUpdateData : hostUpdateData.getVnicsToMigrate()) {
            VirtualNic.Config vnicConfig = new VirtualNic.Config();
            vnicConfig.device = vnicUpdateData.device;
            vnicConfig.changeOperation = ConfigChange.Operation.edit.name();
            PortConnection portConnection = new PortConnection();
            portConnection.portgroupKey = vnicUpdateData.dvPortgroupKey;
            portConnection.switchUuid = dvsUuid;
            vnicConfig.spec = new VirtualNic.Specification();
            vnicConfig.spec.distributedVirtualPort = portConnection;
            vnicConfig.portgroup = "";
            networkConfig.vnic = (VirtualNic.Config[])ArrayUtils.add((Object[])networkConfig.vnic, (Object)vnicConfig);
            if (StringUtil.isNullOrEmpty((String)vnicUpdateData.standardPortgroup)) continue;
            PortGroup.Config pgConfig = new PortGroup.Config();
            pgConfig.changeOperation = ConfigChange.Operation.remove.name();
            pgConfig.spec = new PortGroup.Specification();
            pgConfig.spec.name = vnicUpdateData.standardPortgroup;
            pgConfig.spec.vswitchName = "";
            pgConfig.spec.policy = new NetworkPolicy();
            pgConfig.spec.vlanId = -1;
            networkConfig.portgroup = (PortGroup.Config[])ArrayUtils.add((Object[])networkConfig.portgroup, (Object)pgConfig);
        }
    }

    private static HostProxySwitch.Config createHostProxySwitchConfig(HostUpdateData updateData, String dvsUuid) {
        HostProxySwitch.Config proxySwitchConfig = new HostProxySwitch.Config();
        proxySwitchConfig.uuid = dvsUuid;
        proxySwitchConfig.changeOperation = ConfigChange.Operation.edit.name();
        proxySwitchConfig.spec = new HostProxySwitch.Specification();
        HostMember.PnicBacking pnicBacking = new HostMember.PnicBacking();
        DvsAddHostSpecFactory.populatePnicBacking(updateData.getPnicsToAddMap(), pnicBacking);
        proxySwitchConfig.spec.backing = pnicBacking;
        return proxySwitchConfig;
    }

    private static void populatePnicBacking(Map<String, PnicUpdateData> pnicUpdateDataMap, HostMember.PnicBacking pnicBacking) {
        for (Map.Entry<String, PnicUpdateData> entry : pnicUpdateDataMap.entrySet()) {
            String device;
            HostMember.PnicSpec pnicSpec = new HostMember.PnicSpec();
            pnicSpec.pnicDevice = device = entry.getKey();
            PnicUpdateData pnicUpdateData = entry.getValue();
            pnicSpec.uplinkPortgroupKey = pnicUpdateData.getPortgroupKey();
            if (pnicUpdateData.getUplink() != null) {
                pnicSpec.uplinkPortKey = pnicUpdateData.getUplink();
            }
            pnicBacking.pnicSpec = (HostMember.PnicSpec[])ArrayUtils.add((Object[])pnicBacking.pnicSpec, (Object)pnicSpec);
        }
    }

    /*
     * Could not resolve type clashes
     */
    private static void updateVswitches(HostUpdateData hostUpdateData, NetworkConfig networkConfig, String dvsUuid) {
        VSwitchUpdateData[] vswitchesToUpdate;
        if (hostUpdateData == null) {
            return;
        }
        HostProxySwitch.Config hpsOfContextDvs = null;
        for (VSwitchUpdateData vSwitchUpdateData : vswitchesToUpdate = hostUpdateData.getVswitchesToUpdate()) {
            PnicUpdateData pnicUpdateData;
            Object vswitch = vSwitchUpdateData.getVswitch();
            if (vswitch instanceof VirtualSwitch) {
                VirtualSwitch virtualSwitch = (VirtualSwitch)vswitch;
                VirtualSwitch.Config vSwitchConfig = new VirtualSwitch.Config();
                vSwitchConfig.changeOperation = ConfigChange.Operation.edit.name();
                vSwitchConfig.name = virtualSwitch.name;
                vSwitchConfig.spec = virtualSwitch.spec;
                for (String pnicDevice : vSwitchUpdateData.getPnicsToRemove()) {
                    DvsAddHostSpecFactory.removePnicFromVswitch(pnicDevice, virtualSwitch, vSwitchConfig.spec);
                }
                networkConfig.vswitch = (VirtualSwitch.Config[])ArrayUtils.add((Object[])networkConfig.vswitch, (Object)vSwitchConfig);
                continue;
            }
            if (!(vSwitchUpdateData.getVswitch() instanceof HostProxySwitch)) continue;
            HostProxySwitch proxySwitch = (HostProxySwitch)vSwitchUpdateData.getVswitch();
            HostProxySwitch.Config proxyConfig = new HostProxySwitch.Config();
            proxyConfig.changeOperation = ConfigChange.Operation.edit.name();
            proxyConfig.uuid = proxySwitch.dvsUuid;
            proxyConfig.spec = new HostProxySwitch.Specification();
            if (proxySwitch.spec != null) {
                proxyConfig.spec.backing = proxySwitch.spec.backing;
            }
            for (String pnicDevice : vSwitchUpdateData.getPnicsToRemove()) {
                DvsAddHostSpecFactory.removePnicFromProxySwitch(pnicDevice, proxyConfig.spec);
            }
            for (Map.Entry pnicEntry : vSwitchUpdateData.getPnicsToAdd().entrySet()) {
                String pnicDevice = (String)pnicEntry.getKey();
                pnicUpdateData = (PnicUpdateData)pnicEntry.getValue();
                if (pnicUpdateData == null) continue;
                DvsAddHostSpecFactory.addPnicToProxySwitch(pnicDevice, pnicUpdateData.getPortgroupKey(), pnicUpdateData.getUplink(), proxyConfig.spec);
            }
            for (Map.Entry pnicEntry : vSwitchUpdateData.getPnicsToUpdate().entrySet()) {
                String pnicDevice = (String)pnicEntry.getKey();
                pnicUpdateData = (PnicUpdateData)pnicEntry.getValue();
                if (pnicUpdateData == null) continue;
                DvsAddHostSpecFactory.updateProxySwitchPnic(pnicDevice, pnicUpdateData.getPortgroupKey(), pnicUpdateData.getUplink(), proxyConfig.spec);
            }
            if (proxyConfig.uuid != null && proxyConfig.uuid.equals(dvsUuid)) {
                hpsOfContextDvs = proxyConfig;
                continue;
            }
            networkConfig.proxySwitch = (HostProxySwitch.Config[])ArrayUtils.add((Object[])networkConfig.proxySwitch, (Object)proxyConfig);
        }
        if (hpsOfContextDvs != null) {
            networkConfig.proxySwitch = (HostProxySwitch.Config[])ArrayUtils.add((Object[])networkConfig.proxySwitch, hpsOfContextDvs);
        }
    }

    private static void addPnicToProxySwitch(String pnicDevice, String uplinkPortgroupKey, String dvUplink, HostProxySwitch.Specification spec) {
        if (spec != null && spec.backing instanceof HostMember.PnicBacking) {
            HostMember.PnicBacking pnicBacking = (HostMember.PnicBacking)spec.backing;
            HostMember.PnicSpec pnicSpec = new HostMember.PnicSpec();
            pnicSpec.pnicDevice = pnicDevice;
            pnicSpec.uplinkPortgroupKey = uplinkPortgroupKey;
            if (dvUplink != null) {
                pnicSpec.uplinkPortKey = dvUplink;
            }
            pnicBacking.pnicSpec = (HostMember.PnicSpec[])ArrayUtils.add((Object[])pnicBacking.pnicSpec, (Object)pnicSpec);
        }
    }

    private static void updateProxySwitchPnic(String pnicDevice, String uplinkPortgroupKey, String dvUplink, HostProxySwitch.Specification spec) {
        if (spec != null && spec.backing instanceof HostMember.PnicBacking) {
            HostMember.PnicBacking pnicBacking = (HostMember.PnicBacking)spec.backing;
            for (HostMember.PnicSpec pnicSpec : pnicBacking.pnicSpec) {
                if (!pnicSpec.pnicDevice.equals(pnicDevice)) continue;
                pnicSpec.uplinkPortgroupKey = uplinkPortgroupKey;
                pnicSpec.uplinkPortKey = dvUplink;
            }
        }
    }

    private static void removePnicFromProxySwitch(String pnicDevice, HostProxySwitch.Specification spec) {
        HostMember.PnicBacking pnicBacking = (HostMember.PnicBacking)spec.backing;
        if (pnicBacking != null && pnicBacking.pnicSpec != null) {
            for (HostMember.PnicSpec pnicSpec : pnicBacking.pnicSpec) {
                if (pnicSpec.pnicDevice == null || pnicDevice == null || !pnicSpec.pnicDevice.equals(pnicDevice)) continue;
                pnicBacking.pnicSpec = (HostMember.PnicSpec[])ArrayUtils.removeElement((Object[])pnicBacking.pnicSpec, (Object)pnicSpec);
                break;
            }
        }
    }

    private static void removePnicFromVswitch(String pnicDevice, VirtualSwitch virtualSwitch, VirtualSwitch.Specification spec) {
        if (virtualSwitch != null && virtualSwitch.pnic != null) {
            for (String nicKey : virtualSwitch.pnic) {
                String[] updatedStandbyNicArray;
                int originalStandbyNicArrayLength;
                NetworkPolicy.NicTeamingPolicy nicTeaming;
                if (!StringUtils.endsWith((String)nicKey, (String)pnicDevice)) continue;
                VirtualSwitch.BondBridge bridge = (VirtualSwitch.BondBridge)spec.bridge;
                bridge.nicDevice = (String[])ArrayUtils.removeElement((Object[])bridge.nicDevice, (Object)pnicDevice);
                if (bridge.nicDevice != null && bridge.nicDevice.length == 0) {
                    spec.bridge = null;
                }
                if ((nicTeaming = spec.policy.nicTeaming) == null || nicTeaming.nicOrder == null) {
                    return;
                }
                boolean activePnicRemoved = false;
                if (nicTeaming.nicOrder.activeNic != null) {
                    int originalActiveNicArrayLength = nicTeaming.nicOrder.activeNic.length;
                    String[] updatedActiveNicArray = (String[])ArrayUtils.removeElement((Object[])nicTeaming.nicOrder.activeNic, (Object)pnicDevice);
                    boolean bl = activePnicRemoved = originalActiveNicArrayLength != updatedActiveNicArray.length;
                    if (activePnicRemoved) {
                        nicTeaming.nicOrder.activeNic = updatedActiveNicArray;
                    }
                }
                if (!activePnicRemoved && nicTeaming.nicOrder.standbyNic != null && (originalStandbyNicArrayLength = nicTeaming.nicOrder.standbyNic.length) != (updatedStandbyNicArray = (String[])ArrayUtils.removeElement((Object[])nicTeaming.nicOrder.standbyNic, (Object)pnicDevice)).length) {
                    nicTeaming.nicOrder.standbyNic = updatedStandbyNicArray;
                }
                if (nicTeaming.nicOrder.activeNic != null && nicTeaming.nicOrder.activeNic.length == 0) {
                    nicTeaming.nicOrder.activeNic = null;
                }
                if (nicTeaming.nicOrder.standbyNic != null && nicTeaming.nicOrder.standbyNic.length == 0) {
                    nicTeaming.nicOrder.standbyNic = null;
                }
                if (nicTeaming.nicOrder.activeNic != null || nicTeaming.nicOrder.standbyNic != null) break;
                nicTeaming.nicOrder = null;
                break;
            }
        }
    }

    private static Map<String, HostData> createHostDataMap(HostNetworkModel[] hostNetworkModels) {
        HashMap<String, HostData> hostDataMap = new HashMap<String, HostData>();
        for (HostNetworkModel hostNetworkModel : hostNetworkModels) {
            if (hostNetworkModel == null || hostNetworkModel.provider == null) continue;
            HostData hostData = new HostData(hostNetworkModel);
            hostDataMap.put(hostNetworkModel.provider.toString(), hostData);
        }
        return hostDataMap;
    }

    private static Map<String, HostUpdateData> createHostUpdateDataMap(HostNetworkModel[] hostNetworkModels) {
        HashMap<String, HostUpdateData> hostUpdateDataMap = new HashMap<String, HostUpdateData>();
        for (HostNetworkModel hostNetworkModel : hostNetworkModels) {
            if (hostNetworkModel == null || hostNetworkModel.provider == null) continue;
            ManagedObjectReference hostRef = (ManagedObjectReference)hostNetworkModel.provider;
            HostUpdateData hostUpdateData = new HostUpdateData(hostRef);
            hostUpdateDataMap.put(hostRef.toString(), hostUpdateData);
        }
        return hostUpdateDataMap;
    }

    private static void applyPnicAssignments(PnicAssignmentSpec[] pnicAssignmentSpecs, Map<String, HostUpdateData> hostUpdateDataMap) {
        if (pnicAssignmentSpecs == null) {
            return;
        }
        for (PnicAssignmentSpec pnicAssignmentSpec : pnicAssignmentSpecs) {
            HostUpdateData hostUpdateData;
            if (pnicAssignmentSpec == null || (hostUpdateData = hostUpdateDataMap.get(pnicAssignmentSpec.host.toString())) == null) continue;
            if (pnicAssignmentSpec.isPnicReassigned) {
                hostUpdateData.updatePnic(pnicAssignmentSpec.pnicDevice, pnicAssignmentSpec.uplinkPortgroupKey, pnicAssignmentSpec.uplink);
                continue;
            }
            if (pnicAssignmentSpec.uplinkPortgroupKey == null) {
                hostUpdateData.removePnic(pnicAssignmentSpec.pnicDevice);
                continue;
            }
            hostUpdateData.addPnic(pnicAssignmentSpec.pnicDevice, pnicAssignmentSpec.uplinkPortgroupKey, pnicAssignmentSpec.uplink);
        }
    }

    private static void applyVnicAssignments(VnicAssignmentSpec[] vnicAssignmentSpecs, Map<String, HostUpdateData> hostUpdateDataMap, Map<ManagedObjectReference, String> portgroupRefToKeyMap) {
        if (vnicAssignmentSpecs == null) {
            return;
        }
        for (VnicAssignmentSpec vnicAssignmentSpec : vnicAssignmentSpecs) {
            if (vnicAssignmentSpec == null) continue;
            HostUpdateData hostUpdateData = hostUpdateDataMap.get(vnicAssignmentSpec.host.toString());
            hostUpdateData.migrateVnic(vnicAssignmentSpec.vnicDevice, portgroupRefToKeyMap.get(vnicAssignmentSpec.distributedPortgroupRef), vnicAssignmentSpec.standardPortgroupName);
        }
    }
}

