/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.editsettings;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.h5.network.dvs.editsettings.model.DvsSettingsData;
import com.vmware.vsphere.client.h5.network.dvs.editsettings.model.DvsSettingsQueryBinding;
import java.util.List;

public class DvsEditSettingsDialogPropertyProvider
implements PropertyProviderBean {
    private static final int DEFAULT_MAX_NUM_UPLINKS = 32;
    private static final int DEFAULT_MTU = 1500;
    private static final String OPERATION_SUPPORTED_PROPERTY = "capability.dvsOperationSupported";
    private static final String MODIFY_PRIVILEGE = "DVSwitch.Modify";
    private static final String RES_MGMT_PRIVILEGE = "DVSwitch.ResourceManagement";
    private final QueryBindingService _queryBindingService;
    private final QueryService _queryService;

    public DvsEditSettingsDialogPropertyProvider(QueryBindingService queryBindingService, QueryService queryService) {
        this._queryBindingService = queryBindingService;
        this._queryService = queryService;
    }

    @ModelMetadata(type={"DistributedVirtualSwitch", "VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsedit", property="settingsdata")
    public DvsSettingsData getSettingsData(ManagedObjectReference dvsMor) {
        DvsSettingsQueryBinding dvsSettingsData = (DvsSettingsQueryBinding)((Object)this._queryBindingService.prepare(DvsSettingsQueryBinding.class).fetch((Object)dvsMor));
        DvsSettingsData dataModel = new DvsSettingsData();
        if (dvsSettingsData != null) {
            dataModel.name = dvsSettingsData.name;
            dataModel.configVersion = dvsSettingsData.configVersion;
            dataModel.uplinkPortNames = dvsSettingsData.uplinkPortNames;
            if (dvsSettingsData.niocCapability != null && dvsSettingsData.niocCapability.networkResourceManagementSupported) {
                dataModel.isNiocSupported = true;
                dataModel.isNiocEnabled = dvsSettingsData.isNiocEnabled;
            }
            dataModel.mtu = dvsSettingsData.maxMtu != 0 ? dvsSettingsData.maxMtu : 1500;
            int n = dataModel.maxNumUplinks = dvsSettingsData.uplinkPortNames != null ? dvsSettingsData.availableUplinkCount + dvsSettingsData.uplinkPortNames.length : 32;
            if (dvsSettingsData.description != null) {
                dataModel.description = dvsSettingsData.description;
            }
            dataModel.multicastSnoopingSupported = dvsSettingsData.multicastSnoopingSupported;
            dataModel.multicastFilteringMode = dvsSettingsData.multicastFilteringMode;
            dataModel.lldpSupported = dvsSettingsData.lldpSupported;
            if (dvsSettingsData.linkDiscoveryProtocolConfig != null) {
                dataModel.ldpOperation = dvsSettingsData.linkDiscoveryProtocolConfig.operation;
                dataModel.ldpProtocol = dvsSettingsData.linkDiscoveryProtocolConfig.protocol;
            }
            if (dvsSettingsData.contact != null) {
                dataModel.contactName = dvsSettingsData.contact.name;
                dataModel.contactDetails = dvsSettingsData.contact.contact;
            }
        }
        return dataModel;
    }

    @ModelMetadata(type={"DistributedVirtualSwitch", "VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsedit", property="actionAvailable")
    public Boolean getDvsEditSettingsActionAvailable(ManagedObjectReference dvsMor) throws Exception {
        List propertyValues;
        ResultSet resultSet = this._queryService.select(new String[]{OPERATION_SUPPORTED_PROPERTY, "grantedPrivileges"}).from(new String[]{dvsMor.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvsMor)}).fetch();
        boolean operationSupported = false;
        boolean hasPrivileges = false;
        if (resultSet != null && resultSet.getItems() != null && !resultSet.getItems().isEmpty() && (propertyValues = ((ResourceItem)resultSet.getItems().get(0)).getPropertyValues()) != null && propertyValues.size() == 2) {
            operationSupported = (Boolean)propertyValues.get(0);
            String[] allPrivileges = (String[])propertyValues.get(1);
            hasPrivileges = allPrivileges != null && (AuthorizationUtil.isPrivilegeGranted((String[])new String[]{MODIFY_PRIVILEGE}, (String[])allPrivileges) || AuthorizationUtil.isPrivilegeGranted((String[])new String[]{RES_MGMT_PRIVILEGE}, (String[])allPrivileges));
        }
        return operationSupported && hasPrivileges;
    }
}

