/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.imports;

import com.vmware.vim.binding.vim.NumericRange;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vsphere.client.dvs.api.spec.DvsImportPortgroupSpec;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;

public class DvpgImportParser {
    private DvpgImportParser() {
    }

    public static String getDvpgError(DvsImportPortgroupSpec dvsImportPortgroupSpec) {
        if (dvsImportPortgroupSpec != null) {
            if (dvsImportPortgroupSpec.noPortgroups != null && dvsImportPortgroupSpec.noPortgroups.booleanValue()) {
                return NetworkStringUtil.getString("dvPortGroup.import.filePage.noPgError");
            }
            if (dvsImportPortgroupSpec.tooManyPortgroups != null && dvsImportPortgroupSpec.tooManyPortgroups.booleanValue()) {
                return NetworkStringUtil.getString("dvPortGroup.import.filePage.manyPgError");
            }
            if (dvsImportPortgroupSpec.isUplink != null && dvsImportPortgroupSpec.isUplink.booleanValue()) {
                return NetworkStringUtil.getString("dvPortGroup.import.filePage.uplinkImportNotSupported");
            }
        }
        return null;
    }

    public static String getFormattedVlanValue(DvsImportPortgroupSpec spec) {
        if (spec == null) {
            return null;
        }
        VmwareDistributedVirtualSwitch.PvlanMapEntry pvlanMapEntry = null;
        if (spec.vlanSpec instanceof VmwareDistributedVirtualSwitch.PvlanSpec) {
            VmwareDistributedVirtualSwitch.PvlanSpec vlanSpec = (VmwareDistributedVirtualSwitch.PvlanSpec)spec.vlanSpec;
            VmwareDistributedVirtualSwitch.PvlanMapEntry entry = new VmwareDistributedVirtualSwitch.PvlanMapEntry();
            entry.secondaryVlanId = vlanSpec.pvlanId;
            entry.primaryVlanId = spec.pvlanPrimaryId;
            entry.pvlanType = spec.pvlanPortType;
            pvlanMapEntry = entry;
        }
        return DvpgImportParser.getVlanIdBySpec(spec.vlanSpec, pvlanMapEntry);
    }

    private static String getVlanIdBySpec(VmwareDistributedVirtualSwitch.VlanSpec spec, VmwareDistributedVirtualSwitch.PvlanMapEntry pVlanConfig) {
        String vlanId = "";
        String vlanType = NetworkStringUtil.getString("dvPortGroup.import.noVLAN");
        if (spec instanceof VmwareDistributedVirtualSwitch.PvlanSpec) {
            VmwareDistributedVirtualSwitch.PvlanSpec pVlanSpec = (VmwareDistributedVirtualSwitch.PvlanSpec)spec;
            vlanId = DvpgImportParser.getPvlanId(pVlanSpec, pVlanConfig);
            vlanType = NetworkStringUtil.getString("dvPortGroup.import.privateVLAN");
        } else if (spec instanceof VmwareDistributedVirtualSwitch.TrunkVlanSpec) {
            vlanType = NetworkStringUtil.getString("dvPortGroup.import.vlanTrunk");
            VmwareDistributedVirtualSwitch.TrunkVlanSpec trunkVlanSpec = (VmwareDistributedVirtualSwitch.TrunkVlanSpec)spec;
            vlanId = DvpgImportParser.formatVlanTrunkRange(trunkVlanSpec.vlanId);
        } else if (spec instanceof VmwareDistributedVirtualSwitch.VlanIdSpec) {
            VmwareDistributedVirtualSwitch.VlanIdSpec vlanIdSpec = (VmwareDistributedVirtualSwitch.VlanIdSpec)spec;
            vlanType = NetworkStringUtil.getString("dvPortGroup.import.vlanAccess");
            vlanId = Integer.toString(vlanIdSpec.vlanId);
        }
        return "".equals(vlanId) ? vlanType : String.format(NetworkStringUtil.getString("dvPortGroup.import.vlanIdFormat"), vlanType, vlanId);
    }

    private static String getPvlanId(VmwareDistributedVirtualSwitch.PvlanSpec pVlanSpec, VmwareDistributedVirtualSwitch.PvlanMapEntry pVlanConfig) {
        if (pVlanConfig.secondaryVlanId == pVlanSpec.pvlanId) {
            return String.format(NetworkStringUtil.getString("dvPortGroup.import.privateVlanFormat"), DvpgImportParser.getPrivateVlanPortType(pVlanConfig.pvlanType), pVlanConfig.primaryVlanId, pVlanConfig.secondaryVlanId);
        }
        return "";
    }

    private static String getPrivateVlanPortType(String type) {
        switch (VmwareDistributedVirtualSwitch.PvlanPortType.valueOf((String)type)) {
            case community: {
                return NetworkStringUtil.getString("dvPortGroup.pvlan.community");
            }
            case isolated: {
                return NetworkStringUtil.getString("dvPortGroup.pvlan.isolated");
            }
            case promiscuous: {
                return NetworkStringUtil.getString("dvPortGroup.pvlan.promiscuous");
            }
        }
        return "Invalid private VLAN port type";
    }

    private static String formatVlanTrunkRange(NumericRange[] vlanTrunkRange) {
        String vlanId = "";
        for (int i = 0; i < vlanTrunkRange.length; ++i) {
            NumericRange range = vlanTrunkRange[i];
            if (range != null) {
                if (range.start == range.end) {
                    vlanId = vlanId + Integer.toString(range.start);
                } else {
                    vlanId = vlanId + Integer.toString(range.start);
                    vlanId = String.format(NetworkStringUtil.getString("dvPortGroup.import.rangeFormat"), vlanId, range.end);
                }
            }
            if (i >= vlanTrunkRange.length - 1) continue;
            vlanId = vlanId + ", ";
        }
        return vlanId;
    }
}

