/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.model;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.dvs.ProductSpec;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.common.model.BaseSummaryData;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import java.util.ArrayList;

@QueryBinding(value="AnyDistributedVirtualSwitch")
public final class DvsSummaryData
extends BaseSummaryData {
    private static final String LACP_VERSION_SINGLE_LAG = "singleLag";
    @Property(value="AnyDistributedVirtualSwitch/name")
    public String name;
    @Property(value="AnyDistributedVirtualSwitch/config/productInfo")
    public transient ProductSpec productInfo;
    @Property(value="AnyDistributedVirtualSwitch/dvsupgrade:actionAvailable")
    public transient boolean dvsUpgradeAvailable;
    @Property(value="AnyDistributedVirtualSwitch/config/networkResourceManagementEnabled")
    public transient boolean networkResourceManagementEnabled;
    @Property(value="AnyDistributedVirtualSwitch/capability/featuresSupported/networkResourceManagementCapability/networkResourceManagementSupported")
    public transient boolean networkResourceManagementSupported;
    @Property(value="AnyDistributedVirtualSwitch/capability/featuresSupported/networkResourceManagementCapability/networkResourceControlVersion3Supported")
    public transient boolean networkResourceControlVer3Supported;
    @Property(value="AnyDistributedVirtualSwitch/networkResourceManagementVersion")
    public transient int networkResourceManagementVersion;
    @Property(value="AnyDistributedVirtualSwitch/config/healthCheckConfig")
    public DistributedVirtualSwitch.HealthCheckConfig[] healtCheckConfig;
    @Property(value="AnyDistributedVirtualSwitch/capability/dvsOperationSupported")
    public transient boolean dvsOperationSupported;
    @Property(value="AnyDistributedVirtualSwitch/capability/featuresSupported/lacpCapability/multiLacpGroupSupported")
    public transient boolean multiLacpGroupSupported;
    @Property(value="AnyDistributedVirtualSwitch/config/lacpApiVersion")
    public transient String lacpApiVersion;

    public BaseSummaryData.LabelValue[] getSummaryItems() {
        ArrayList<BaseSummaryData.LabelValue> summaryItems = new ArrayList<BaseSummaryData.LabelValue>();
        summaryItems.add(new BaseSummaryData.LabelValue("DvsSummaryView.manufacturer", (Object)this.productInfo.getVendor()));
        summaryItems.add(new BaseSummaryData.LabelValue("DvsSummaryView.version", (Object)this.getVersionInfo()));
        return summaryItems.toArray(new BaseSummaryData.LabelValue[summaryItems.size()]);
    }

    public BaseSummaryData.Badge[] getBadges() {
        boolean isHealthCheckEnabled;
        ArrayList<BaseSummaryData.Badge> listBadges = new ArrayList<BaseSummaryData.Badge>();
        if (NetworkUtil.isVmwareVendor(this.productInfo.getVendor())) {
            listBadges.add(new BaseSummaryData.Badge("icon-vSphere-vmwareDvs24", "DvsSummaryView.vmwareDvsTooltip", false));
        }
        if (this.networkResourceManagementEnabled && this.networkResourceManagementSupported) {
            listBadges.add(new BaseSummaryData.Badge("icon-vSphere-iorm24", "DvsSummaryView.iormEnabled", false));
        }
        if (isHealthCheckEnabled = this.getIsHealthCheckEnabled()) {
            listBadges.add(new BaseSummaryData.Badge("icon-vSphere-healthCheck24", "DvsSummaryView.healthcheckTooltip", false));
        }
        return listBadges.toArray(new BaseSummaryData.Badge[listBadges.size()]);
    }

    public boolean getIsHealthCheckEnabled() {
        if (ArrayUtil.isNullOrEmpty((Object[])this.healtCheckConfig)) {
            return false;
        }
        for (DistributedVirtualSwitch.HealthCheckConfig config : this.healtCheckConfig) {
            if (!config.getEnable().booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean isLacpUpgradeAvailable() {
        return this.dvsOperationSupported && this.multiLacpGroupSupported && LACP_VERSION_SINGLE_LAG.equals(this.lacpApiVersion);
    }

    private boolean isNiocUpgradeAvailable() {
        return this.dvsOperationSupported && this.networkResourceControlVer3Supported && this.networkResourceManagementVersion < 3;
    }

    private String[] getVersionInfo() {
        ArrayList<String> versionInfo = new ArrayList<String>();
        versionInfo.add(this.productInfo.getVersion());
        String upgradeWarning = "";
        if (this.dvsUpgradeAvailable) {
            upgradeWarning = NetworkStringUtil.getString("dvsSummary.upgradeDvsWarning");
        }
        if (this.isLacpUpgradeAvailable()) {
            upgradeWarning = upgradeWarning + NetworkStringUtil.getString("dvsSummary.upgradeLacpWarning");
        }
        if (this.isNiocUpgradeAvailable()) {
            upgradeWarning = upgradeWarning + NetworkStringUtil.getString("dvsSummary.upgradeNiocWarning");
        }
        if (!StringUtil.isNullOrEmpty((String)upgradeWarning)) {
            versionInfo.add(NetworkStringUtil.getString("dvsSummary.upgradeWarning", upgradeWarning));
        }
        return versionInfo.toArray(new String[versionInfo.size()]);
    }
}

