/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.portmirroring;

import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.host.ConfigChange;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vsphere.client.dvs.api.spec.DvsConfigSpec;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.dialog.DvsEditSpanSessionDialogData;

public class DvsEditSpanSessionDialogMutationProvider
implements MutationProvider {
    private static final String PROPERTY_CONFIG_VERSION = "config.configVersion";
    private final MutationService _mutationService;
    private final QueryExecutor _queryExecutor;

    public DvsEditSpanSessionDialogMutationProvider(MutationService mutationService, QueryExecutor queryExecutor) {
        this._mutationService = mutationService;
        this._queryExecutor = queryExecutor;
    }

    public OperationResult apply(ManagedObjectReference dvsRef, DvsEditSpanSessionDialogData dialogData) throws Exception {
        VmwareDistributedVirtualSwitch.VspanSession vspanSession = new VmwareDistributedVirtualSwitch.VspanSession();
        String configVersion = (String)this._queryExecutor.getProperty((Object)dvsRef, PROPERTY_CONFIG_VERSION);
        vspanSession.key = dialogData.key;
        vspanSession.name = dialogData.sessionName;
        vspanSession.enabled = dialogData.enabled;
        vspanSession.description = dialogData.description;
        vspanSession.encapType = dialogData.encapsulationType;
        vspanSession.erspanId = dialogData.sessionId;
        vspanSession.mirroredPacketLength = dialogData.mirroredPacketLength;
        vspanSession.samplingRate = dialogData.samplingRate;
        switch (VmwareDistributedVirtualSwitch.VspanSessionType.valueOf((String)dialogData.sessionType)) {
            case encapsulatedRemoteMirrorSource: {
                vspanSession.encapType = dialogData.encapsulationType;
                vspanSession.erspanId = dialogData.sessionId;
                vspanSession.netstack = dialogData.tcpIpStack;
                this.setSourcePorts(vspanSession, dialogData);
                vspanSession.destinationPort = new VmwareDistributedVirtualSwitch.VspanPorts();
                vspanSession.destinationPort.ipAddress = dialogData.destinationAddresses;
                break;
            }
            case remoteMirrorSource: {
                vspanSession.stripOriginalVlan = !dialogData.preserveOriginalVlan;
                vspanSession.encapsulationVlanId = dialogData.encapsulationVlanId;
                vspanSession.normalTrafficAllowed = dialogData.normalTrafficAllowed;
                this.setSourcePorts(vspanSession, dialogData);
                vspanSession.destinationPort = new VmwareDistributedVirtualSwitch.VspanPorts();
                vspanSession.destinationPort.uplinkPortName = dialogData.uplinkPortsSelected;
                break;
            }
            case remoteMirrorDest: {
                vspanSession.normalTrafficAllowed = dialogData.normalTrafficAllowed;
                vspanSession.sourcePortReceived = new VmwareDistributedVirtualSwitch.VspanPorts();
                vspanSession.sourcePortReceived.vlans = dialogData.sourceVlans;
                vspanSession.destinationPort = new VmwareDistributedVirtualSwitch.VspanPorts();
                vspanSession.destinationPort.portKey = dialogData.destinationPorts;
                break;
            }
            case dvPortMirror: {
                vspanSession.normalTrafficAllowed = dialogData.normalTrafficAllowed;
                this.setSourcePorts(vspanSession, dialogData);
                vspanSession.destinationPort = new VmwareDistributedVirtualSwitch.VspanPorts();
                vspanSession.destinationPort.portKey = dialogData.destinationPorts;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported session type: %s", dialogData.sessionType));
            }
        }
        VmwareDistributedVirtualSwitch.VspanConfigSpec vspanConfigSpec = new VmwareDistributedVirtualSwitch.VspanConfigSpec();
        vspanConfigSpec.operation = ConfigChange.Operation.edit.toString();
        vspanConfigSpec.vspanSession = vspanSession;
        DvsConfigSpec dvsConfigSpec = new DvsConfigSpec();
        VmwareDistributedVirtualSwitch.ConfigSpec configSpec = new VmwareDistributedVirtualSwitch.ConfigSpec();
        if (configVersion != null) {
            configSpec.configVersion = configVersion;
        }
        configSpec.vspanConfigSpec = new VmwareDistributedVirtualSwitch.VspanConfigSpec[]{vspanConfigSpec};
        dvsConfigSpec.configSpec = configSpec;
        return this._mutationService.apply((Object)dvsRef, (Object)dvsConfigSpec);
    }

    private void setSourcePorts(VmwareDistributedVirtualSwitch.VspanSession vspanSession, DvsEditSpanSessionDialogData dialogData) {
        vspanSession.sourcePortReceived = new VmwareDistributedVirtualSwitch.VspanPorts();
        vspanSession.sourcePortReceived.portKey = dialogData.sourcePortsIngress;
        vspanSession.sourcePortTransmitted = new VmwareDistributedVirtualSwitch.VspanPorts();
        vspanSession.sourcePortTransmitted.portKey = dialogData.sourcePortsEgress;
    }
}

