/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.ports;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vim.binding.vim.ConfigSpecOperation;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.TrafficRule;
import com.vmware.vim.binding.vim.dvs.TrafficRuleset;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.DvpgTrafficFilterParser;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.DvpgTrafficRuleBuilder;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.DvpgTrafficRuleModelBuilder;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortAddTrafficRuleSpec;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortEditTrafficFilterSpec;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortEditTrafficRuleSpec;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortRemoveTrafficRuleSpec;
import com.vmware.vsphere.client.h5.network.util.DvsPortsUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;

public class DvsPortTrafficFilterMutationProvider
implements MutationProvider {
    private final MutationService _mutationService;
    private final QueryExecutor _queryExecutor;
    private final QueryService _queryService;
    private static final String DVPG_DVS = "config.distributedVirtualSwitch";

    public DvsPortTrafficFilterMutationProvider(MutationService mutationService, QueryExecutor queryExecutor, QueryService queryService) {
        this._mutationService = mutationService;
        this._queryExecutor = queryExecutor;
        this._queryService = queryService;
    }

    public OperationResult apply(ManagedObjectReference objRef, DvsPortEditTrafficFilterSpec spec) throws Exception {
        DistributedVirtualPort.ConfigSpec configSpec;
        ManagedObjectReference dvsRef = this.getDvsRef(objRef);
        OperationResult result = new OperationResult();
        result.entity = dvsRef;
        DistributedVirtualPort.FilterPolicy existingFilterPolicy = null;
        DistributedVirtualPort.ConfigInfo configInfo = this.getPortConfigInfo(dvsRef, spec.portKey);
        if (configInfo != null && configInfo.setting != null) {
            existingFilterPolicy = configInfo.setting.filterPolicy;
        }
        if ((configSpec = this.initConfigSpec(spec.portKey, configInfo != null ? configInfo.configVersion : null)) == null) {
            result.error = this.throwNoConfigException();
            return result;
        }
        if (existingFilterPolicy == null) {
            existingFilterPolicy = new DistributedVirtualPort.FilterPolicy();
        }
        DistributedVirtualPort.TrafficFilterConfig existingFilterConfig = DvpgTrafficRuleModelBuilder.getGenericFilterConfig(existingFilterPolicy);
        int existingConfigIndex = DvpgTrafficFilterParser.getGenericFilterConfigIndex(existingFilterPolicy.filterConfig);
        if (ArrayUtil.isNullOrEmpty((Object[])existingFilterPolicy.filterConfig)) {
            existingFilterPolicy.filterConfig = new DistributedVirtualPort.TrafficFilterConfig[0];
        }
        TrafficRuleset ruleSet = existingFilterConfig == null || existingFilterConfig.trafficRuleset == null ? new TrafficRuleset() : existingFilterConfig.trafficRuleset;
        ruleSet.enabled = spec.isTrafficRulesetEnabled;
        ruleSet.rules = DvpgTrafficFilterParser.updateRulesSequence(ruleSet.rules, spec.rules);
        String specKey = existingFilterConfig != null ? existingFilterConfig.key : null;
        String operation = existingConfigIndex == -1 ? ConfigSpecOperation.add.name() : ConfigSpecOperation.edit.name();
        DistributedVirtualPort.TrafficFilterConfigSpec filterConfigSpec = DvpgTrafficFilterParser.createGenericFilterConfigSpec(specKey, operation, ruleSet);
        boolean bl = filterConfigSpec.inherited = !spec.isTrafficRulesetOverwritten;
        if (existingConfigIndex == -1) {
            existingFilterPolicy.filterConfig = new DistributedVirtualPort.FilterConfig[]{filterConfigSpec};
        } else {
            existingFilterPolicy.filterConfig[existingConfigIndex] = filterConfigSpec;
        }
        existingFilterPolicy.inherited = !spec.isTrafficRulesetOverwritten;
        configSpec.setting.filterPolicy = existingFilterPolicy;
        return this._mutationService.apply((Object)dvsRef, (Object)configSpec);
    }

    public OperationResult apply(ManagedObjectReference objRef, DvsPortAddTrafficRuleSpec spec) throws Exception {
        TrafficRuleset ruleSet;
        DistributedVirtualPort.ConfigSpec configSpec;
        ManagedObjectReference dvsRef = this.getDvsRef(objRef);
        OperationResult result = new OperationResult();
        result.entity = dvsRef;
        DistributedVirtualPort.FilterPolicy existingFilterPolicy = null;
        DistributedVirtualPort.ConfigInfo configInfo = this.getPortConfigInfo(dvsRef, spec.portKey);
        if (configInfo != null && configInfo.setting != null) {
            existingFilterPolicy = configInfo.setting.filterPolicy;
        }
        if ((configSpec = this.initConfigSpec(spec.portKey, configInfo != null ? configInfo.configVersion : null)) == null) {
            result.error = this.throwNoConfigException();
            return result;
        }
        if (existingFilterPolicy == null) {
            existingFilterPolicy = new DistributedVirtualPort.FilterPolicy();
        }
        if (ArrayUtil.isNullOrEmpty((Object[])existingFilterPolicy.filterConfig)) {
            existingFilterPolicy.filterConfig = new DistributedVirtualPort.TrafficFilterConfig[0];
        }
        DistributedVirtualPort.TrafficFilterConfig existingFilterConfig = DvpgTrafficRuleModelBuilder.getGenericFilterConfig(existingFilterPolicy);
        int existingConfigIndex = DvpgTrafficFilterParser.getGenericFilterConfigIndex(existingFilterPolicy.filterConfig);
        if (existingFilterConfig == null || existingFilterConfig.trafficRuleset == null) {
            ruleSet = new TrafficRuleset();
            ruleSet.enabled = false;
        } else {
            ruleSet = existingFilterConfig.trafficRuleset;
        }
        if (spec.newRule != null) {
            spec.newRule.sequence = DvpgTrafficRuleBuilder.getNextAvailableSequenceNumber(ruleSet.rules);
        }
        TrafficRule newTrafficRule = DvpgTrafficRuleBuilder.createTrafficRule(spec.newRule);
        ruleSet.rules = DvpgTrafficFilterParser.addTrafficRuleToExistingRules(ruleSet.rules, newTrafficRule);
        String specKey = existingFilterConfig != null ? existingFilterConfig.key : null;
        String operation = existingConfigIndex == -1 ? ConfigSpecOperation.add.name() : ConfigSpecOperation.edit.name();
        DistributedVirtualPort.TrafficFilterConfigSpec filterConfigSpec = DvpgTrafficFilterParser.createGenericFilterConfigSpec(specKey, operation, ruleSet);
        if (existingConfigIndex == -1) {
            existingFilterPolicy.filterConfig = new DistributedVirtualPort.FilterConfig[]{filterConfigSpec};
        } else {
            existingFilterPolicy.filterConfig[existingConfigIndex] = filterConfigSpec;
        }
        existingFilterPolicy.inherited = false;
        configSpec.setting.filterPolicy = existingFilterPolicy;
        return this._mutationService.apply((Object)dvsRef, (Object)configSpec);
    }

    public OperationResult apply(ManagedObjectReference objRef, DvsPortEditTrafficRuleSpec spec) throws Exception {
        DistributedVirtualPort.ConfigSpec configSpec;
        ManagedObjectReference dvsRef = this.getDvsRef(objRef);
        OperationResult result = new OperationResult();
        result.entity = dvsRef;
        if (spec.editedRule == null) {
            result.error = this.throwNoConfigException();
            return result;
        }
        DistributedVirtualPort.FilterPolicy existingFilterPolicy = null;
        DistributedVirtualPort.ConfigInfo configInfo = this.getPortConfigInfo(dvsRef, spec.portKey);
        if (configInfo != null && configInfo.setting != null) {
            existingFilterPolicy = configInfo.setting.filterPolicy;
        }
        if ((configSpec = this.initConfigSpec(spec.portKey, configInfo != null ? configInfo.configVersion : null)) == null) {
            result.error = this.throwNoConfigException();
            return result;
        }
        DistributedVirtualPort.TrafficFilterConfig existingFilterConfig = DvpgTrafficRuleModelBuilder.getGenericFilterConfig(existingFilterPolicy);
        if (existingFilterConfig == null || existingFilterConfig.trafficRuleset == null) {
            result.error = this.throwNoConfigException();
            return result;
        }
        TrafficRuleset ruleSet = existingFilterConfig.trafficRuleset;
        TrafficRule editedTrafficRule = DvpgTrafficRuleBuilder.createTrafficRule(spec.editedRule);
        ruleSet.rules = DvpgTrafficFilterParser.editTrafficRuleInExistingRules(existingFilterConfig.trafficRuleset.rules, editedTrafficRule);
        DistributedVirtualPort.TrafficFilterConfigSpec filterConfigSpec = DvpgTrafficFilterParser.createGenericFilterConfigSpec(existingFilterConfig.key, ConfigSpecOperation.edit.name(), ruleSet);
        if (existingFilterPolicy != null) {
            int filterConfigIndex = DvpgTrafficFilterParser.getGenericFilterConfigIndex(existingFilterPolicy.filterConfig);
            existingFilterPolicy.filterConfig[filterConfigIndex] = filterConfigSpec;
            existingFilterPolicy.inherited = false;
        }
        configSpec.setting.filterPolicy = existingFilterPolicy;
        return this._mutationService.apply((Object)dvsRef, (Object)configSpec);
    }

    public OperationResult apply(ManagedObjectReference objRef, DvsPortRemoveTrafficRuleSpec spec) throws Exception {
        DistributedVirtualPort.ConfigSpec configSpec;
        ManagedObjectReference dvsRef = this.getDvsRef(objRef);
        OperationResult result = new OperationResult();
        result.entity = dvsRef;
        if (spec.ruleKey == null) {
            result.error = new Exception(NetworkStringUtil.getString("trafficFilter.rulesList.noSpec"));
            return result;
        }
        DistributedVirtualPort.FilterPolicy existingFilterPolicy = null;
        DistributedVirtualPort.ConfigInfo configInfo = this.getPortConfigInfo(dvsRef, spec.portKey);
        if (configInfo != null && configInfo.setting != null) {
            existingFilterPolicy = configInfo.setting.filterPolicy;
        }
        if ((configSpec = this.initConfigSpec(spec.portKey, configInfo != null ? configInfo.configVersion : null)) == null) {
            result.error = this.throwNoConfigException();
            return result;
        }
        DistributedVirtualPort.TrafficFilterConfig existingFilterConfig = DvpgTrafficRuleModelBuilder.getGenericFilterConfig(existingFilterPolicy);
        if (existingFilterConfig == null || existingFilterConfig.trafficRuleset == null) {
            result.error = this.throwNoConfigException();
            return result;
        }
        TrafficRuleset ruleSet = existingFilterConfig.trafficRuleset;
        ruleSet.rules = DvpgTrafficFilterParser.removeTrafficRuleFromExistingRules(existingFilterConfig.trafficRuleset.rules, spec.ruleKey);
        boolean isFilterConfigNeeded = existingFilterConfig.trafficRuleset.enabled != false || !ArrayUtil.isNullOrEmpty((Object[])ruleSet.rules);
        String operationType = isFilterConfigNeeded ? ConfigSpecOperation.edit.name() : ConfigSpecOperation.remove.name();
        DistributedVirtualPort.TrafficFilterConfigSpec filterConfigSpec = DvpgTrafficFilterParser.createGenericFilterConfigSpec(existingFilterConfig.key, operationType, ruleSet);
        if (existingFilterPolicy != null) {
            int filterConfigIndex = DvpgTrafficFilterParser.getGenericFilterConfigIndex(existingFilterPolicy.filterConfig);
            existingFilterPolicy.filterConfig[filterConfigIndex] = filterConfigSpec;
            existingFilterPolicy.inherited = false;
        }
        configSpec.setting.filterPolicy = existingFilterPolicy;
        return this._mutationService.apply((Object)dvsRef, (Object)configSpec);
    }

    private ManagedObjectReference getDvsRef(ManagedObjectReference objRef) {
        if (objRef == null) {
            return null;
        }
        if (objRef.getType().equals(DistributedVirtualPortgroup.class.getSimpleName())) {
            ResultSet dvsResultSet = this._queryService.select(new String[]{DVPG_DVS}).from(new String[]{DistributedVirtualPortgroup.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)objRef)}).fetch();
            if (dvsResultSet != null && dvsResultSet.getItems() != null) {
                ResourceItem dvsResultSetItems = (ResourceItem)dvsResultSet.getItems().get(0);
                return (ManagedObjectReference)dvsResultSetItems.getPropertyValues().get(0);
            }
            return null;
        }
        if (objRef.getType().equals(DistributedVirtualSwitch.class.getSimpleName()) || objRef.getType().equals(VmwareDistributedVirtualSwitch.class.getSimpleName())) {
            return objRef;
        }
        return null;
    }

    private DistributedVirtualPort.ConfigInfo getPortConfigInfo(ManagedObjectReference dvsMor, String portId) throws Exception {
        if (dvsMor == null || StringUtil.isNullOrEmpty((String)portId)) {
            return null;
        }
        com.vmware.vise.data.query.ResultSet portSettingResultSet = this._queryExecutor.getData(DvsPortsUtil.buildDvsPortsPoliciesQuerySpec(dvsMor, portId));
        if (portSettingResultSet != null && portSettingResultSet.items != null) {
            for (ResultItem item : portSettingResultSet.items) {
                if (item == null || ArrayUtil.isNullOrEmpty((Object[])item.properties)) continue;
                return (DistributedVirtualPort.ConfigInfo)item.properties[0].value;
            }
        }
        return null;
    }

    private DistributedVirtualPort.ConfigSpec initConfigSpec(String portKey, String configVersion) {
        if (StringUtil.isNullOrEmpty((String)configVersion)) {
            return null;
        }
        DistributedVirtualPort.ConfigSpec configSpec = new DistributedVirtualPort.ConfigSpec();
        configSpec.key = portKey;
        configSpec.operation = ConfigSpecOperation.edit.name();
        configSpec.configVersion = configVersion;
        configSpec.setting = new DistributedVirtualPort.Setting();
        return configSpec;
    }

    private Exception throwNoConfigException() {
        return new Exception(NetworkStringUtil.getString("trafficFilter.rulesList.noConfig"));
    }
}

