/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.upgrade;

import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.common.compositecommand.api.spec.BaseCommandSpec;
import com.vmware.vsphere.client.dvs.api.spec.DvsApplyProductSpecCommandSpec;
import com.vmware.vsphere.client.dvs.api.spec.LacpUpgradeVersionCommandSpec;
import com.vmware.vsphere.client.dvs.api.spec.ResControlUpgradeVersionCommandSpec;
import com.vmware.vsphere.client.h5.network.dvs.upgrade.model.DvsUpgradeWizardSpec;
import java.util.ArrayList;

public class DvsUpgradeSpecBuilder {
    public DvsApplyProductSpecCommandSpec buildDvsUpgradeCommandSpec(ManagedObjectReference dvsRef, DvsUpgradeWizardSpec spec) {
        DvsApplyProductSpecCommandSpec commandSpec = new DvsApplyProductSpecCommandSpec();
        commandSpec.mor = dvsRef;
        commandSpec.operationType = DistributedVirtualSwitch.ProductSpecOperationType.upgrade;
        commandSpec.productSpec = spec.productSpec;
        ArrayList<Object> dependentSpecs = new ArrayList<Object>();
        if (spec.implicitNiocUpgrade) {
            ResControlUpgradeVersionCommandSpec niocVersionUpgradeSpec = this.buildDvsResControlUpgradeCommandSpec(dvsRef);
            dependentSpecs.add(niocVersionUpgradeSpec);
        }
        if (spec.implicitLacpUpgrade) {
            LacpUpgradeVersionCommandSpec lacpVersionUpgradeSpec = this.buildDvsLacpUpgradeCommandSpec(dvsRef, spec.isMultiLagLacpSupported);
            if (dependentSpecs.size() == 1) {
                ((BaseCommandSpec)dependentSpecs.get((int)0)).dependentSpecs = new BaseCommandSpec[]{lacpVersionUpgradeSpec};
            } else {
                dependentSpecs.add(lacpVersionUpgradeSpec);
            }
        }
        commandSpec.dependentSpecs = dependentSpecs.toArray(new BaseCommandSpec[dependentSpecs.size()]);
        return commandSpec;
    }

    public LacpUpgradeVersionCommandSpec buildDvsLacpUpgradeCommandSpec(ManagedObjectReference dvsRef, boolean isMultiLagLacpSupported) {
        LacpUpgradeVersionCommandSpec lacpVersionUpgradeSpec = new LacpUpgradeVersionCommandSpec();
        lacpVersionUpgradeSpec.mor = dvsRef;
        if (isMultiLagLacpSupported) {
            lacpVersionUpgradeSpec.apiVersion = VmwareDistributedVirtualSwitch.LacpApiVersion.multipleLag.name();
        }
        lacpVersionUpgradeSpec.configVersion = "";
        return lacpVersionUpgradeSpec;
    }

    public ResControlUpgradeVersionCommandSpec buildDvsResControlUpgradeCommandSpec(ManagedObjectReference dvsRef) {
        ResControlUpgradeVersionCommandSpec niocVersionUpgradeSpec = new ResControlUpgradeVersionCommandSpec();
        niocVersionUpgradeSpec.mor = dvsRef;
        niocVersionUpgradeSpec.configVersion = "";
        return niocVersionUpgradeSpec;
    }
}

