/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.iscsi;

import com.vmware.vim.binding.vim.host.IscsiManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.h5.network.host.iscsi.model.BoundIscsiPortInfoData;
import com.vmware.vsphere.client.h5.network.host.iscsi.model.CandidateIscsiPortInfoData;
import com.vmware.vsphere.client.h5.network.host.iscsi.model.IscsiPortInfoItem;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostIscsiPortBindingPropertyProvider
implements PropertyProviderBean {
    private static final String HOST_CONFIG_STORAGE_PRIV = "Host.Config.Storage";
    private static final String BOUND_ISCSI_PORT_INFO = "boundIscsiPortInfo";
    private static final String CANDIDATE_ISCSI_PORT_INFO = "candidateIscsiInfo";
    private static final Log _logger = LogFactory.getLog(HostIscsiPortBindingPropertyProvider.class);
    private QueryExecutor _queryExecutor;
    private QuerySpecBuilder _querySpecBuilder;

    public HostIscsiPortBindingPropertyProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="iscsiPortBinding", property="boundIscsiPortInfoData")
    public BoundIscsiPortInfoData getBoundIscsiPortInfoData(ManagedObjectReference hostRef, String iscsiHbaName) throws Exception {
        String[] privileges = (String[])this._queryExecutor.getProperty((Object)hostRef, "grantedPrivileges");
        if (!AuthorizationUtil.isPrivilegeGranted((String[])new String[]{HOST_CONFIG_STORAGE_PRIV}, (String[])privileges)) {
            return BoundIscsiPortInfoData.newInstanceForNoPrivileges();
        }
        IscsiManager.IscsiPortInfo[] iscsiPortInfos = (IscsiManager.IscsiPortInfo[])NetworkUtil.requestPropertyWithParam(this._queryExecutor, this._querySpecBuilder, hostRef, BOUND_ISCSI_PORT_INFO, iscsiHbaName);
        return BoundIscsiPortInfoData.newInstance(HostIscsiPortBindingPropertyProvider.createIscsiPortInfoItem(iscsiPortInfos, false));
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="iscsiPortBinding", property="candidateIscsiPortInfoData")
    public CandidateIscsiPortInfoData getCandidateIscsiPortInfoData(ManagedObjectReference hostRef, String iscsiHbaName) throws Exception {
        IscsiManager.IscsiPortInfo[] iscsiPortInfos = (IscsiManager.IscsiPortInfo[])NetworkUtil.requestPropertyWithParam(this._queryExecutor, this._querySpecBuilder, hostRef, CANDIDATE_ISCSI_PORT_INFO, iscsiHbaName);
        return CandidateIscsiPortInfoData.newInstance(HostIscsiPortBindingPropertyProvider.createIscsiPortInfoItem(iscsiPortInfos, true));
    }

    private static IscsiPortInfoItem[] createIscsiPortInfoItem(IscsiManager.IscsiPortInfo[] iscsiPortInfos, boolean isCandidate) {
        if (iscsiPortInfos == null) {
            return new IscsiPortInfoItem[0];
        }
        IscsiPortInfoItem[] items = new IscsiPortInfoItem[iscsiPortInfos.length];
        for (int i = 0; i < items.length; ++i) {
            items[i] = isCandidate ? IscsiPortInfoItem.newInstanceForCandidateIsciItem(iscsiPortInfos[i]) : IscsiPortInfoItem.newInstance(iscsiPortInfos[i]);
        }
        return items;
    }
}

