/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.vnic;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vim.binding.vim.fault.IscsiFaultVnicInUse;
import com.vmware.vim.binding.vim.host.NetworkInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vsphere.client.h5.network.host.vnic.model.VnicRemoveValidationResult;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import com.vmware.vsphere.client.modules.api.network.VirtualNicEditSpec;
import com.vmware.vsphere.client.modules.api.network.VirtualNicRemoveSpec;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostVnicsMutationProvider
implements MutationProvider {
    private static final String HOST_CONFIG_NETWORK_PROPERTY = "config.network";
    private static final String HOST_ISCSI_DEPENDENCIES_PROPERTY = "iscsiDependencies";
    private static final Log _logger = LogFactory.getLog(HostVnicsMutationProvider.class);
    private final QueryService _queryService;

    public HostVnicsMutationProvider(QueryService queryService) {
        this._queryService = queryService;
    }

    public ValidationResult validate(ManagedObjectReference objRef, VirtualNicRemoveSpec spec) throws Exception {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = objRef;
        ResultSet result = this._queryService.select(new String[]{HOST_CONFIG_NETWORK_PROPERTY, HOST_ISCSI_DEPENDENCIES_PROPERTY}).from(new String[]{objRef.getType()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate("iscsiDependencies/@param", PropertyPredicate.ComparisonOperator.EQUAL, (Object)spec.virtualNicName), new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)objRef)}).fetch();
        NetworkInfo networkInfo = (NetworkInfo)((ResourceItem)result.getItems().get(0)).get(HOST_CONFIG_NETWORK_PROPERTY);
        if (networkInfo == null) {
            validationResult.result = VnicRemoveValidationResult.error("removeVirtualNic.genericError", new String[0]);
            _logger.warn((Object)("Unable to retrieve the network config info of the host: " + objRef));
            return validationResult;
        }
        MethodFault[] iscsiFaults = (MethodFault[])((ResourceItem)result.getItems().get(0)).get(HOST_ISCSI_DEPENDENCIES_PROPERTY);
        validationResult.result = NetworkUtil.isLastManagementVmnic(networkInfo, spec.virtualNicName) ? VnicRemoveValidationResult.error("removeVirtualNic.managementVmkernelError", new String[0]) : (this.containsIscsiFault(iscsiFaults) ? VnicRemoveValidationResult.warn("removeVirtualNic.iscsiPortBindingError", spec.virtualNicName) : VnicRemoveValidationResult.pass());
        return validationResult;
    }

    public ValidationResult validate(ManagedObjectReference objRef, VirtualNicEditSpec spec) throws Exception {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = objRef;
        ResultSet result = this._queryService.select(new String[]{HOST_ISCSI_DEPENDENCIES_PROPERTY}).from(new String[]{objRef.getType()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate("iscsiDependencies/@param", PropertyPredicate.ComparisonOperator.EQUAL, (Object)spec.virtualNicName), new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)objRef)}).fetch();
        MethodFault[] iscsiFaults = (MethodFault[])((ResourceItem)result.getItems().get(0)).get(HOST_ISCSI_DEPENDENCIES_PROPERTY);
        if (this.containsIscsiFault(iscsiFaults)) {
            validationResult.result = NetworkStringUtil.getString("editVnic.iscsiPortBindingWarning", spec.virtualNicName);
        }
        return validationResult;
    }

    private boolean containsIscsiFault(MethodFault[] faults) {
        if (!ArrayUtils.isEmpty((Object[])faults)) {
            for (MethodFault fault : faults) {
                if (!(fault instanceof IscsiFaultVnicInUse)) continue;
                return true;
            }
        }
        return false;
    }
}

