/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.vnic;

import com.vmware.vim.binding.vim.host.IpConfig;
import com.vmware.vim.binding.vim.host.NetStackInstance;
import com.vmware.vim.binding.vim.host.RuntimeInfo;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VirtualNicManager;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.h5.network.util.IpUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VnicUtils {
    public static VirtualNic getVnicByDevice(VirtualNic[] virtualNics, String device) {
        if (device != null && virtualNics != null) {
            for (VirtualNic vnic : virtualNics) {
                if (!device.equals(vnic.device)) continue;
                return vnic;
            }
        }
        return null;
    }

    public static boolean isTrafficEnabled(String virtualNicKey, VirtualNicManager.NicType nicType, VirtualNicManager.NetConfig[] netConfigs) {
        if (virtualNicKey == null || ArrayUtil.isNullOrEmpty((Object[])netConfigs)) {
            return false;
        }
        for (VirtualNicManager.NetConfig netConfig : netConfigs) {
            if (!netConfig.nicType.equals(nicType.name()) || netConfig.selectedVnic == null) continue;
            for (String selectedVnicId : netConfig.selectedVnic) {
                String selectedVnicKey = selectedVnicId.substring(selectedVnicId.indexOf(46) + 1);
                if (!virtualNicKey.equals(selectedVnicKey)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDefaultNetStackInstance(String netStackInstanceKey) {
        return netStackInstanceKey == null || NetStackInstance.SystemStackKey.defaultTcpipStack.name().equals(netStackInstanceKey);
    }

    public static boolean isNetStackInUse(String netStackInstanceKey, RuntimeInfo.NetStackInstanceRuntimeInfo[] netStackInstanceRuntimeInfos) {
        if (!ArrayUtil.isNullOrEmpty((Object[])netStackInstanceRuntimeInfos)) {
            for (RuntimeInfo.NetStackInstanceRuntimeInfo instanceRuntime : netStackInstanceRuntimeInfos) {
                if (instanceRuntime == null || !instanceRuntime.netStackInstanceKey.equals(netStackInstanceKey)) continue;
                return !ArrayUtil.isNullOrEmpty((Object[])instanceRuntime.vmknicKeys);
            }
        }
        return false;
    }

    public static Map<String, Set<String>> getHostIpAddresses(VirtualNic[] vnics) {
        HashMap<String, Set<String>> hostIpv6Addresses = new HashMap<String, Set<String>>();
        if (vnics != null) {
            for (VirtualNic vnic : vnics) {
                Set<String> vnicIpAddresses = VnicUtils.getVirtualNicIpAddresses(vnic);
                if (vnicIpAddresses.isEmpty()) continue;
                hostIpv6Addresses.put(vnic.device, vnicIpAddresses);
            }
        }
        return hostIpv6Addresses;
    }

    private static Set<String> getVirtualNicIpAddresses(VirtualNic virtualNic) {
        HashSet<String> ipAddresses = new HashSet<String>();
        if (virtualNic == null || virtualNic.spec == null) {
            return ipAddresses;
        }
        if (virtualNic.spec.ip != null && !StringUtil.isNullOrEmpty((String)virtualNic.spec.ip.ipAddress)) {
            ipAddresses.add(virtualNic.spec.ip.ipAddress);
        }
        if (IpUtil.hasAnyIpv6Addresses(virtualNic.spec.ip)) {
            for (IpConfig.IpV6Address ipv6Address : virtualNic.spec.ip.ipV6Config.ipV6Address) {
                ipAddresses.add(ipv6Address.ipAddress);
            }
        }
        return ipAddresses;
    }
}

