/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.switchdiagram;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.PortConnectee;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortGroupModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortStatus;
import com.vmware.vsphere.client.network.switchdiagram.api.OvsDiagramPortgroupVmsBuilder;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.SwitchDiagramVmSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OvsDiagramPortgroupVmsBuilderImpl
implements OvsDiagramPortgroupVmsBuilder {
    private final SwitchDiagramVmSpec[] vmSpecs;
    private Map<String, PortGroupModel> portgroupsByNetworkId = new HashMap<String, PortGroupModel>();
    private Set<String> networkKeysSet = new HashSet<String>();

    public OvsDiagramPortgroupVmsBuilderImpl(SwitchDiagramVmSpec[] ovsDiagramVmSpecs, String[] opaqueNetworkKeys) {
        if (ovsDiagramVmSpecs == null) {
            throw new IllegalArgumentException("ovsDiagramVmSpecs cannot be null");
        }
        if (opaqueNetworkKeys == null) {
            throw new IllegalArgumentException("opaqueNetworkKeys cannot be null");
        }
        this.vmSpecs = ovsDiagramVmSpecs;
        this.networkKeysSet.addAll(Arrays.asList(opaqueNetworkKeys));
    }

    public List<PortGroupModel> buildPortgroupVmsModels() {
        for (SwitchDiagramVmSpec vmSpec : this.vmSpecs) {
            if (ArrayUtil.isNullOrEmpty((Object[])vmSpec.devices)) continue;
            Map<String, List<VirtualDevice>> devicesPerNetwork = this.getDevicesPerNetwork(vmSpec.devices);
            for (String network : this.networkKeysSet) {
                List<VirtualDevice> devices = devicesPerNetwork.get(network);
                if (devices == null) continue;
                boolean includeMac = devices.size() > 1;
                for (VirtualDevice device : devices) {
                    PortGroupModel portGroup = this.getPortgroupByNetworkId(((VirtualEthernetCard.OpaqueNetworkBackingInfo)device.backing).opaqueNetworkId);
                    PortModel portModel = this.buildPortModel(device, vmSpec, includeMac);
                    portGroup.vmVnics.add(portModel);
                }
            }
        }
        Collection<PortGroupModel> portgroupModels = this.portgroupsByNetworkId.values();
        for (PortGroupModel portGroupModel : portgroupModels) {
            this.sortVms(portGroupModel.vmVnics);
        }
        return new ArrayList<PortGroupModel>(portgroupModels);
    }

    private PortModel buildPortModel(VirtualDevice networkAdapter, SwitchDiagramVmSpec vmSpec, boolean includeMac) {
        PortModel portModel = new PortModel();
        portModel.portConnecteeType = PortConnectee.ConnecteeType.vmVnic;
        portModel.id = vmSpec.provider.getValue() + Integer.toString(networkAdapter.key);
        portModel.virtualDeviceKey = networkAdapter.key;
        portModel.vmName = vmSpec.name;
        portModel.title = vmSpec.name;
        portModel.powerState = vmSpec.powerState;
        portModel.portStatus = VirtualMachine.PowerState.poweredOn.equals((Object)vmSpec.powerState) ? PortStatus.CONNECTED : PortStatus.DISCONNECTED;
        portModel.isOrphanedVm = VirtualMachine.ConnectionState.orphaned.equals((Object)vmSpec.connectionState);
        portModel.vmValue = vmSpec.provider.getValue();
        if (vmSpec.host != null) {
            portModel.hostValue = vmSpec.host.getValue();
        }
        if (includeMac) {
            portModel.macAddress = ((VirtualEthernetCard)networkAdapter).macAddress;
        }
        return portModel;
    }

    private Map<String, List<VirtualDevice>> getDevicesPerNetwork(VirtualDevice[] devices) {
        HashMap<String, List<VirtualDevice>> result = new HashMap<String, List<VirtualDevice>>();
        for (VirtualDevice device : devices) {
            if (device == null || !(device.backing instanceof VirtualEthernetCard.OpaqueNetworkBackingInfo)) continue;
            VirtualEthernetCard.OpaqueNetworkBackingInfo backing = (VirtualEthernetCard.OpaqueNetworkBackingInfo)device.backing;
            if (backing.opaqueNetworkId == null || !this.networkKeysSet.contains(backing.opaqueNetworkId)) continue;
            ArrayList<VirtualDevice> devicesOnNetwork = (ArrayList<VirtualDevice>)result.get(backing.opaqueNetworkId);
            if (devicesOnNetwork == null) {
                devicesOnNetwork = new ArrayList<VirtualDevice>();
                result.put(backing.opaqueNetworkId, devicesOnNetwork);
            }
            devicesOnNetwork.add(device);
        }
        return result;
    }

    private PortGroupModel getPortgroupByNetworkId(String networkId) {
        PortGroupModel portGroup = this.portgroupsByNetworkId.get(networkId);
        if (portGroup == null) {
            portGroup = new PortGroupModel();
            portGroup.id = networkId;
            this.portgroupsByNetworkId.put(networkId, portGroup);
        }
        return portGroup;
    }

    private void sortVms(List<PortModel> vmVnics) {
        Collections.sort(vmVnics, new Comparator<PortModel>(){

            @Override
            public int compare(PortModel vm1, PortModel vm2) {
                return vm1.vmName.compareToIgnoreCase(vm2.vmName);
            }
        });
    }
}

