/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.switchdiagram;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.NumericRange;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.HostMember;
import com.vmware.vim.binding.vim.dvs.PortConnectee;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.host.SriovInfo;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.dvs.api.switchdiagram.SwitchDiagramBuilder;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.AdapterModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.GraphRelation;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.LagModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortChannelModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortGroupModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortStatus;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.SriovAdapterModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.SwitchDiagramModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.UplinkPortGroupModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.UplinkPortModel;
import com.vmware.vsphere.client.h5.network.switchdiagram.SwitchDiagramBuilderBase;
import com.vmware.vsphere.client.h5.network.switchdiagram.model.internal.HostMemberModel;
import com.vmware.vsphere.client.h5.network.switchdiagram.model.internal.VlanType;
import com.vmware.vsphere.client.h5.network.switchdiagram.util.SwitchDiagramUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.SwitchDiagramHostSpec;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.SwitchDiagramPortgroupSpec;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.SwitchDiagramSpec;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.SwitchDiagramVmSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SwitchDiagramBuilderImpl
extends SwitchDiagramBuilderBase
implements SwitchDiagramBuilder {
    private static final String UPLINKPG_STANDALONE_ID = "UplinkGroup:Uplink Ports";
    private static final String UPLINK_PORT_PREFIX = "uplink_";
    private static final String EMPTY_UPLINK_GROUP_ID = "emptyUplinkGroupId";
    private static final String LAG_PREFIX = "lag_";
    private static final String PORT_CHANNEL_PREFIX = "portChannel_";
    private static final String EMPTY_STRING = "";
    private SwitchDiagramSpec _switchDiagramSpec;
    private Map<String, DistributedVirtualPort> _portsMap = new HashMap<String, DistributedVirtualPort>();
    private Map<String, List<DistributedVirtualPort>> _portgroupPortsMap = new HashMap<String, List<DistributedVirtualPort>>();
    private Map<ManagedObjectReference, HostMemberModel> _hostsMap = new HashMap<ManagedObjectReference, HostMemberModel>();
    private Map<Integer, VmwareDistributedVirtualSwitch.PvlanMapEntry> _pvlanMap = new HashMap<Integer, VmwareDistributedVirtualSwitch.PvlanMapEntry>();
    private List<ManagedObjectReference> _uplinkGroups = new ArrayList<ManagedObjectReference>();
    private String[] _uplinkPolicyNames;
    private Map<String, DistributedVirtualPort> _nicToUplinkPort = new HashMap<String, DistributedVirtualPort>();
    private Map<String, List<String>> _uplinkIds = new HashMap<String, List<String>>();
    private Map<String, VmwareDistributedVirtualSwitch.LacpGroupConfig> _lagsMap = new HashMap<String, VmwareDistributedVirtualSwitch.LacpGroupConfig>();
    private Map<String, String> _uplinkNameToLagNameMap = new HashMap<String, String>();
    private Set<String> _lagPortKeys = new HashSet<String>();
    private Map<String, Set<String>> _hostToSriovEnabledPciDeviceIds = new HashMap<String, Set<String>>();

    public SwitchDiagramBuilderImpl(SwitchDiagramSpec switchDiagramSpec) {
        if (switchDiagramSpec == null) {
            throw new IllegalArgumentException("switchDiagramSpec cannot be null");
        }
        if (switchDiagramSpec.dvsSpec == null) {
            throw new IllegalArgumentException("dvsSpec cannot be null");
        }
        if (switchDiagramSpec.dvsSpec.config == null) {
            throw new IllegalArgumentException("dvs config cannot be null");
        }
        this._switchDiagramSpec = switchDiagramSpec;
    }

    public SwitchDiagramModel buildSwitchDiagramModel(boolean filterPerVms) {
        SwitchDiagramModel switchDiagramModel = new SwitchDiagramModel();
        if (this._switchDiagramSpec.dvsSpec.provider != null) {
            switchDiagramModel.id = this._switchDiagramSpec.dvsSpec.provider.getValue();
        }
        switchDiagramModel.dvsUuid = this._switchDiagramSpec.dvsSpec.config.uuid;
        this.initializeSwitchDiagramFilter(switchDiagramModel);
        this.initializeUplinkPortGroupsSet();
        this.initializePortsMap();
        this.initializeHostsMap(this._switchDiagramSpec.dvsSpec.config.uuid);
        this.initializePvlanMap();
        this.initializeLagMaps();
        this.initializeSriovDevicesMap();
        this.initializeHostNetworkData();
        this.initializeUplinkPolicyNames();
        this.addStandaloneDvPorts(switchDiagramModel);
        this.addDvPortgroups(switchDiagramModel, filterPerVms);
        this.addUplinkPortGroups(switchDiagramModel);
        this.buildVmKernelRelations(switchDiagramModel);
        this.buildTeamingRelations(switchDiagramModel);
        return switchDiagramModel;
    }

    private void initializeSwitchDiagramFilter(SwitchDiagramModel switchDiagramModel) {
        if (!ArrayUtil.isNullOrEmpty((Object[])this._switchDiagramSpec.dvsSpec.hosts)) {
            for (SwitchDiagramHostSpec switchDiagramHostSpec : this._switchDiagramSpec.dvsSpec.hosts) {
                if (switchDiagramHostSpec == null || switchDiagramHostSpec.provider == null) continue;
                switchDiagramModel.loadedHosts.add(switchDiagramHostSpec.provider.getValue());
            }
        }
    }

    private void initializeLagMaps() {
        if (this._switchDiagramSpec.dvsSpec.config instanceof VmwareDistributedVirtualSwitch.ConfigInfo) {
            VmwareDistributedVirtualSwitch.ConfigInfo vmwDvsConfig = (VmwareDistributedVirtualSwitch.ConfigInfo)this._switchDiagramSpec.dvsSpec.config;
            if (!ArrayUtil.isNullOrEmpty((Object[])vmwDvsConfig.lacpGroupConfig)) {
                for (VmwareDistributedVirtualSwitch.LacpGroupConfig lacpGroupConfig : vmwDvsConfig.lacpGroupConfig) {
                    if (lacpGroupConfig == null || StringUtil.isNullOrEmpty((String)lacpGroupConfig.key)) continue;
                    this._lagsMap.put(lacpGroupConfig.key, lacpGroupConfig);
                    if (!ArrayUtil.isNullOrEmpty((Object[])lacpGroupConfig.uplinkName)) {
                        for (String uplinkPortName : lacpGroupConfig.uplinkName) {
                            if (StringUtil.isNullOrEmpty((String)lacpGroupConfig.name)) continue;
                            this._uplinkNameToLagNameMap.put(uplinkPortName, lacpGroupConfig.name);
                        }
                    }
                    if (ArrayUtil.isNullOrEmpty((Object[])lacpGroupConfig.uplinkPortKey)) continue;
                    this._lagPortKeys.addAll(Arrays.asList(lacpGroupConfig.uplinkPortKey));
                }
            }
        }
    }

    private void initializeSriovDevicesMap() {
        if (this._switchDiagramSpec.dvsSpec != null && !ArrayUtil.isNullOrEmpty((Object[])this._switchDiagramSpec.dvsSpec.hosts)) {
            for (SwitchDiagramHostSpec hostSpec : this._switchDiagramSpec.dvsSpec.hosts) {
                if (hostSpec == null || hostSpec.sriov == null || hostSpec.provider == null) continue;
                for (SriovInfo sriovInfo : hostSpec.sriov) {
                    if (sriovInfo == null || !sriovInfo.sriovActive || StringUtil.isNullOrEmpty((String)sriovInfo.id)) continue;
                    Set<String> deviceIds = this._hostToSriovEnabledPciDeviceIds.get(hostSpec.provider.toString());
                    if (deviceIds == null) {
                        deviceIds = new HashSet<String>();
                        this._hostToSriovEnabledPciDeviceIds.put(hostSpec.provider.toString(), deviceIds);
                    }
                    deviceIds.add(sriovInfo.id);
                }
            }
        }
    }

    private void initializePvlanMap() {
        if (this._switchDiagramSpec.dvsSpec.config instanceof VmwareDistributedVirtualSwitch.ConfigInfo) {
            VmwareDistributedVirtualSwitch.ConfigInfo vmwDvsConfig = (VmwareDistributedVirtualSwitch.ConfigInfo)this._switchDiagramSpec.dvsSpec.config;
            if (vmwDvsConfig.pvlanConfig != null) {
                for (VmwareDistributedVirtualSwitch.PvlanMapEntry pvlanMapEntry : vmwDvsConfig.pvlanConfig) {
                    this._pvlanMap.put(pvlanMapEntry.secondaryVlanId, pvlanMapEntry);
                }
            }
        }
    }

    private void initializeHostsMap(String dvsUuid) {
        if (!ArrayUtil.isNullOrEmpty((Object[])this._switchDiagramSpec.dvsSpec.hosts)) {
            for (SwitchDiagramHostSpec hostSpec : this._switchDiagramSpec.dvsSpec.hosts) {
                if (hostSpec.provider == null || hostSpec.network == null) continue;
                this._hostsMap.put(hostSpec.provider, new HostMemberModel(hostSpec, dvsUuid));
            }
        }
    }

    private void initializeHostNetworkData() {
        if (this._switchDiagramSpec.dvsSpec.config != null && !ArrayUtil.isNullOrEmpty((Object[])this._switchDiagramSpec.dvsSpec.config.host)) {
            for (HostMember hostMember : this._switchDiagramSpec.dvsSpec.config.host) {
                HostMemberModel hostMemberModel;
                if (hostMember.config.host == null || (hostMemberModel = this._hostsMap.get(hostMember.config.host)) == null) continue;
                for (String portKey : hostMember.uplinkPortKey) {
                    DistributedVirtualPort port = this._portsMap.get(portKey);
                    if (port == null) continue;
                    hostMemberModel.uplinkPorts.add(port);
                }
            }
        }
    }

    private void initializeUplinkPolicyNames() {
        this._uplinkPolicyNames = SwitchDiagramUtil.getUplinkPolicyNames(this._switchDiagramSpec.dvsSpec);
    }

    private void addUplinkPortGroups(SwitchDiagramModel switchDiagramModel) {
        this.addStandaloneUplinkPorts(switchDiagramModel);
        if (ArrayUtil.isNullOrEmpty((Object[])this._switchDiagramSpec.dvsSpec.uplinkPortgroups)) {
            this.addEmptyUplinksPortgroup(switchDiagramModel);
            return;
        }
        for (SwitchDiagramPortgroupSpec pgData : this._switchDiagramSpec.dvsSpec.uplinkPortgroups) {
            ManagedObjectReference portgroupMor = pgData.provider;
            int uplinkPortgroupIndex = this._uplinkGroups.indexOf(portgroupMor);
            boolean addAllUplinkNames = ManagedObjectUtil.isOfType((ManagedObjectReference)this._switchDiagramSpec.dvsSpec.provider, (String)VmwareDistributedVirtualSwitch.class.getSimpleName()) && uplinkPortgroupIndex == 0 && ArrayUtil.isNullOrEmpty((Object[])this._switchDiagramSpec.dvsSpec.config.host);
            boolean addDisconnectedPorts = ManagedObjectUtil.isOfType((ManagedObjectReference)this._switchDiagramSpec.dvsSpec.provider, (String)VmwareDistributedVirtualSwitch.class.getSimpleName());
            List<DistributedVirtualPort> uplinkPorts = this.getPortsByPortgroupKey(pgData.key);
            Map<String, List<DistributedVirtualPort>> portsMap = this.getDvUplinkNameToDvPortsMap(uplinkPorts, addAllUplinkNames, addDisconnectedPorts);
            UplinkPortGroupModel uplinkPortGroupModel = new UplinkPortGroupModel();
            switchDiagramModel.uplinkPortGroups.add(uplinkPortGroupModel);
            uplinkPortGroupModel.title = MixedUtil.unescapeVimEntityNameSpecialChars((String)pgData.name);
            uplinkPortGroupModel.id = portgroupMor.getValue();
            uplinkPortGroupModel.portgroupValue = portgroupMor.getValue();
            this.addUplinkPorts(uplinkPortGroupModel, portsMap);
            Set<String> portSet = this.getPortKeysSet(uplinkPorts);
            List<String> lagKeys = this.getLagKeysForPorts(uplinkPorts, portSet, this.getLags(), uplinkPortgroupIndex == 0);
            this.addLags(uplinkPortGroupModel, lagKeys, portSet);
        }
    }

    private int addLags(UplinkPortGroupModel uplinkPortGroupModel, List<String> lagKeys, Set<String> portGroupPortKeys) {
        int totalUplinkPortsCount = 0;
        for (String lagKey : lagKeys) {
            VmwareDistributedVirtualSwitch.LacpGroupConfig lag = this._lagsMap.get(lagKey);
            if (lag == null || lag.name == null) continue;
            LagModel lagModel = new LagModel();
            uplinkPortGroupModel.childItems.add(lagModel);
            lagModel.id = this.getLagId(lag.name, uplinkPortGroupModel);
            lagModel.key = lag.key;
            lagModel.title = lag.name;
            int lagPortsCount = 0;
            HashMap<String, PortChannelModel> portChannelsMap = new HashMap<String, PortChannelModel>();
            if (!ArrayUtil.isNullOrEmpty((Object[])lag.uplinkPortKey)) {
                for (String portKey : lag.uplinkPortKey) {
                    if (!portGroupPortKeys.contains(portKey)) continue;
                    DistributedVirtualPort port = this._portsMap.get(portKey);
                    String portName = null;
                    if (port != null && port.config != null && port.config.name != null) {
                        portName = port.config.name;
                    }
                    String adapterName = null;
                    HostMemberModel hostMemberModel = null;
                    String hostName = null;
                    String hostId = null;
                    if (port != null && port.connectee != null && port.connectee.connectedEntity != null && Objects.equals(port.connectee.connectedEntity.getType(), HostSystem.class.getSimpleName()) && Objects.equals(port.connectee.type, PortConnectee.ConnecteeType.pnic.name()) && !StringUtil.isNullOrEmpty((String)port.connectee.nicKey)) {
                        ManagedObjectReference hostRef = port.connectee.connectedEntity;
                        hostId = hostRef.getValue();
                        hostMemberModel = this._hostsMap.get(hostRef);
                        if (hostMemberModel != null && hostMemberModel.switchDiagramHostSpec != null) {
                            adapterName = port.connectee.nicKey;
                            hostName = hostMemberModel.switchDiagramHostSpec.name;
                            String nicId = this.getGeneratedNicId(port.connectee.nicKey, hostId);
                            DistributedVirtualPort uplinkPort = this._nicToUplinkPort.get(nicId);
                            if (uplinkPort != null) {
                                // empty if block
                            }
                            this._nicToUplinkPort.put(nicId, port);
                        }
                    }
                    if (adapterName == null || hostName == null || hostId == null) continue;
                    PortChannelModel portChannelModel = (PortChannelModel)portChannelsMap.get(hostId);
                    if (portChannelModel == null) {
                        portChannelModel = new PortChannelModel();
                        lagModel.portChannels.add(portChannelModel);
                        portChannelModel.title = hostName;
                        portChannelModel.id = this.getPortChannelId(hostName, lagModel);
                        portChannelsMap.put(hostId, portChannelModel);
                    }
                    if (StringUtil.isNullOrEmpty(adapterName)) continue;
                    PhysicalNic pNic = null;
                    Set<String> sriovDeviceIds = null;
                    if (hostMemberModel != null) {
                        pNic = hostMemberModel.getPhysicalNic(adapterName);
                        sriovDeviceIds = this._hostToSriovEnabledPciDeviceIds.get(hostMemberModel.switchDiagramHostSpec.provider.toString());
                    }
                    AdapterModel adapterModel = new AdapterModel();
                    if (sriovDeviceIds != null && pNic != null && sriovDeviceIds.contains(pNic.pci)) {
                        adapterModel = new SriovAdapterModel();
                        ((SriovAdapterModel)adapterModel).physicalFunctionId = pNic.pci;
                    }
                    portChannelModel.adapters.add(adapterModel);
                    adapterModel.title = adapterName;
                    adapterModel.hostName = portName;
                    adapterModel.id = port.key;
                    if (port.proxyHost != null) {
                        this.setUplinkPortConnectionStatus(port, adapterModel);
                        if (pNic == null || pNic.linkSpeed == null) {
                            adapterModel.pNicLinkUp = false;
                        }
                    } else {
                        adapterModel.showCdpInfoButton = false;
                        adapterModel.portStatus = PortStatus.ERROR;
                    }
                    this.setLagConnectionStatus(lagModel, adapterModel);
                    if (port.config != null) {
                        adapterModel.uplinkName = this._uplinkNameToLagNameMap.get(port.config.name);
                    }
                    if (hostMemberModel != null && hostMemberModel.switchDiagramHostSpec.provider != null) {
                        adapterModel.hostValue = hostMemberModel.switchDiagramHostSpec.provider.getValue();
                    }
                    ++lagPortsCount;
                }
            }
            totalUplinkPortsCount += lagPortsCount;
            if (lagModel.portChannels.isEmpty()) continue;
            for (PortChannelModel portChannelModel : lagModel.portChannels) {
                this.sortPhysicalAdapters(portChannelModel.adapters);
            }
        }
        return totalUplinkPortsCount;
    }

    private String getPortChannelId(String hostName, LagModel parent) {
        String portChannelId = PORT_CHANNEL_PREFIX + hostName + parent.id;
        return portChannelId;
    }

    private String getLagId(String lagName, UplinkPortGroupModel uplinkPortGroupModel) {
        String lagId = LAG_PREFIX + lagName + uplinkPortGroupModel.id;
        List<String> lagIds = this._uplinkIds.get(lagName);
        if (lagIds == null) {
            lagIds = new ArrayList<String>();
            this._uplinkIds.put(lagName, lagIds);
        }
        lagIds.add(lagId);
        return lagId;
    }

    private List<String> getLagKeysForPorts(List<DistributedVirtualPort> uplinkPorts, Set<String> uplinkPortKeysSet, VmwareDistributedVirtualSwitch.LacpGroupConfig[] lags, boolean includeEmptyLags) {
        ArrayList<String> lagKeys = new ArrayList<String>();
        if (!ArrayUtil.isNullOrEmpty((Object[])lags)) {
            block0: for (VmwareDistributedVirtualSwitch.LacpGroupConfig lag : lags) {
                if (lag == null) continue;
                if (!ArrayUtil.isNullOrEmpty((Object[])lag.uplinkPortKey)) {
                    for (String portKey : lag.uplinkPortKey) {
                        if (!uplinkPortKeysSet.contains(portKey) || StringUtil.isNullOrEmpty((String)lag.key)) continue;
                        lagKeys.add(lag.key);
                        continue block0;
                    }
                    continue;
                }
                if (!includeEmptyLags) continue;
                lagKeys.add(lag.key);
            }
        }
        return lagKeys;
    }

    public VmwareDistributedVirtualSwitch.LacpGroupConfig[] getLags() {
        VmwareDistributedVirtualSwitch.LacpGroupConfig[] lacpGroupConfig = null;
        if (this._switchDiagramSpec.dvsSpec.config instanceof VmwareDistributedVirtualSwitch.ConfigInfo) {
            VmwareDistributedVirtualSwitch.ConfigInfo vmwConfigInfo = (VmwareDistributedVirtualSwitch.ConfigInfo)this._switchDiagramSpec.dvsSpec.config;
            lacpGroupConfig = vmwConfigInfo.lacpGroupConfig;
        }
        return lacpGroupConfig;
    }

    private void addEmptyUplinksPortgroup(SwitchDiagramModel switchDiagramModel) {
        UplinkPortGroupModel uplinkPortGroupModel = new UplinkPortGroupModel();
        uplinkPortGroupModel.title = NetworkStringUtil.getString("SwitchDiagram.uplinksPortgroupTitle");
        switchDiagramModel.uplinkPortGroups.add(uplinkPortGroupModel);
        uplinkPortGroupModel.id = EMPTY_UPLINK_GROUP_ID;
        uplinkPortGroupModel.isFake = true;
        Map<String, List<DistributedVirtualPort>> portsMap = this.getDvUplinkNameToDvPortsMap(null, true, false);
        this.addUplinkPorts(uplinkPortGroupModel, portsMap);
    }

    private int addStandaloneUplinkPorts(SwitchDiagramModel switchDiagramModel) {
        int totalPortAdaptersCount = 0;
        ArrayList<DistributedVirtualPort> standaloneUplinkPorts = new ArrayList<DistributedVirtualPort>();
        for (Map.Entry<ManagedObjectReference, HostMemberModel> hostMapEntry : this._hostsMap.entrySet()) {
            HostMemberModel hostMemberModel = hostMapEntry.getValue();
            if (hostMemberModel.uplinkPorts.isEmpty()) continue;
            for (DistributedVirtualPort port : hostMemberModel.uplinkPorts) {
                if (!StringUtil.isNullOrEmpty((String)port.portgroupKey)) continue;
                standaloneUplinkPorts.add(port);
            }
        }
        if (!standaloneUplinkPorts.isEmpty()) {
            UplinkPortGroupModel uplinkPortGroupModel = new UplinkPortGroupModel();
            uplinkPortGroupModel.title = NetworkStringUtil.getString("SwitchDiagram.uplinkPortsGroup");
            switchDiagramModel.uplinkPortGroups.add(uplinkPortGroupModel);
            uplinkPortGroupModel.id = UPLINKPG_STANDALONE_ID;
            uplinkPortGroupModel.isFake = true;
            boolean addAllUplinkNames = ManagedObjectUtil.isOfType((ManagedObjectReference)this._switchDiagramSpec.dvsSpec.provider, (String)VmwareDistributedVirtualSwitch.class.getSimpleName()) && this._uplinkGroups.isEmpty();
            boolean addDisconnectedPorts = ManagedObjectUtil.isOfType((ManagedObjectReference)this._switchDiagramSpec.dvsSpec.provider, (String)VmwareDistributedVirtualSwitch.class.getSimpleName());
            Map<String, List<DistributedVirtualPort>> portsMap = this.getDvUplinkNameToDvPortsMap(standaloneUplinkPorts, addAllUplinkNames, addDisconnectedPorts);
            int portAdaptersCount = this.addUplinkPorts(uplinkPortGroupModel, portsMap);
            totalPortAdaptersCount += portAdaptersCount;
        }
        return totalPortAdaptersCount;
    }

    private int addUplinkPorts(UplinkPortGroupModel parent, Map<String, List<DistributedVirtualPort>> portsMap) {
        int totalPortAdaptersCount = 0;
        if (portsMap != null) {
            Object[] uplinkNames = portsMap.keySet().toArray(new String[0]);
            Arrays.sort(uplinkNames);
            for (Object uplinkName : uplinkNames) {
                UplinkPortModel uplinkPortModel = new UplinkPortModel();
                parent.childItems.add(uplinkPortModel);
                uplinkPortModel.id = this.getUplinkId((String)uplinkName, parent);
                uplinkPortModel.title = uplinkName;
                List<DistributedVirtualPort> uplinkAdapters = portsMap.get(uplinkName);
                int portAdaptersCount = 0;
                for (DistributedVirtualPort port : uplinkAdapters) {
                    if (this._lagPortKeys.contains(port.key)) continue;
                    String adapterName = EMPTY_STRING;
                    HostMemberModel hostSpecWrapper = null;
                    String hostName = EMPTY_STRING;
                    boolean forceErrorState = false;
                    if (port.connectee != null && port.connectee.connectedEntity != null && Objects.equals(port.connectee.connectedEntity.getType(), HostSystem.class.getSimpleName()) && Objects.equals(port.connectee.type, PortConnectee.ConnecteeType.pnic.name()) && !StringUtil.isNullOrEmpty((String)port.connectee.nicKey)) {
                        String hostId = port.connectee.connectedEntity.getValue();
                        hostSpecWrapper = this._hostsMap.get(port.connectee.connectedEntity);
                        if (hostSpecWrapper != null && hostSpecWrapper.switchDiagramHostSpec != null) {
                            adapterName = port.connectee.nicKey;
                            hostName = hostSpecWrapper.switchDiagramHostSpec.name;
                            String nicId = this.getGeneratedNicId(port.connectee.nicKey, hostId);
                            DistributedVirtualPort uplinkPort = this._nicToUplinkPort.get(nicId);
                            if (uplinkPort != null) {
                                // empty if block
                            }
                            this._nicToUplinkPort.put(nicId, port);
                        }
                    }
                    if (StringUtil.isNullOrEmpty((String)adapterName)) continue;
                    AdapterModel adapterModel = new AdapterModel();
                    PhysicalNic pNic = null;
                    if (hostSpecWrapper != null) {
                        pNic = hostSpecWrapper.getPhysicalNic(adapterName);
                        if (hostSpecWrapper.switchDiagramHostSpec.provider != null) {
                            Set<String> sriovDeviceIds;
                            if (pNic != null && pNic.pci != null && (sriovDeviceIds = this._hostToSriovEnabledPciDeviceIds.get(hostSpecWrapper.switchDiagramHostSpec.provider.toString())) != null && sriovDeviceIds.contains(pNic.pci)) {
                                adapterModel = new SriovAdapterModel();
                                ((SriovAdapterModel)adapterModel).physicalFunctionId = pNic.pci;
                            }
                            adapterModel.hostValue = hostSpecWrapper.switchDiagramHostSpec.provider.getValue();
                        }
                    }
                    uplinkPortModel.adapters.add(adapterModel);
                    adapterModel.hostName = hostName;
                    adapterModel.title = adapterName;
                    adapterModel.id = port.key;
                    if (port.proxyHost != null && !forceErrorState) {
                        this.setUplinkPortConnectionStatus(port, adapterModel);
                        if (pNic == null || pNic.linkSpeed == null) {
                            adapterModel.pNicLinkUp = false;
                        }
                    } else {
                        adapterModel.showCdpInfoButton = false;
                        adapterModel.portStatus = PortStatus.ERROR;
                    }
                    this.setUplinkConnectionStatus(uplinkPortModel, adapterModel);
                    if (port.config != null) {
                        adapterModel.uplinkName = port.config.name;
                    }
                    ++portAdaptersCount;
                }
                totalPortAdaptersCount += portAdaptersCount;
                this.sortPhysicalAdapters(uplinkPortModel.adapters);
            }
        }
        return totalPortAdaptersCount;
    }

    private String getGeneratedNicId(String nicKey, String hostId) {
        return nicKey + ":" + hostId;
    }

    private void setUplinkConnectionStatus(UplinkPortModel uplinkPortModel, AdapterModel adapterModel) {
        if (adapterModel.portStatus.ordinal() > uplinkPortModel.portStatus.ordinal() && uplinkPortModel.portStatus != PortStatus.NA) {
            uplinkPortModel.portStatus = adapterModel.portStatus;
        }
    }

    private Map<String, List<DistributedVirtualPort>> getDvUplinkNameToDvPortsMap(List<DistributedVirtualPort> uplinkPorts, boolean addAllUplinkNames, boolean addDisconnectedPorts) {
        HashMap<String, List<DistributedVirtualPort>> result = new HashMap<String, List<DistributedVirtualPort>>();
        if (addAllUplinkNames && this._uplinkPolicyNames != null) {
            for (String uplinkName : this._uplinkPolicyNames) {
                result.put(uplinkName, new ArrayList());
            }
        }
        if (!ArrayUtil.isNullOrEmpty(uplinkPorts)) {
            for (DistributedVirtualPort port : uplinkPorts) {
                if (port.config == null || StringUtil.isNullOrEmpty((String)port.config.name) || this._lagPortKeys.contains(port.key) || !addDisconnectedPorts && port.connectee == null) continue;
                ArrayList<DistributedVirtualPort> uplinkAdapters = (ArrayList<DistributedVirtualPort>)result.get(port.config.name);
                if (uplinkAdapters == null) {
                    uplinkAdapters = new ArrayList<DistributedVirtualPort>();
                    result.put(port.config.name, uplinkAdapters);
                }
                uplinkAdapters.add(port);
            }
        }
        return result;
    }

    private void addDvPortgroups(SwitchDiagramModel switchDiagramModel, boolean filterPerVms) {
        if (ArrayUtil.isNullOrEmpty((Object[])this._switchDiagramSpec.dvsSpec.portgroups)) {
            return;
        }
        for (SwitchDiagramPortgroupSpec pgData : this._switchDiagramSpec.dvsSpec.portgroups) {
            VlanType vlanType = SwitchDiagramUtil.getVlanType(pgData.vlan);
            String vlanSettings = this.getVlanSettings(pgData.vlan, vlanType);
            List<DistributedVirtualPort> ports = this.getPortsByPortgroupKey(pgData.key);
            PortGroupModel portGroupModel = new PortGroupModel();
            switchDiagramModel.portGroups.add(portGroupModel);
            portGroupModel.title = MixedUtil.unescapeVimEntityNameSpecialChars((String)pgData.name);
            portGroupModel.id = pgData.provider.getValue();
            portGroupModel.vlan = this.getVlanText(vlanType, vlanSettings);
            portGroupModel.portgroupKey = pgData.key;
            if (pgData.provider != null) {
                portGroupModel.portgroupValue = pgData.provider.getValue();
            }
            this.addHostDvPorts(portGroupModel, ports);
            portGroupModel.virtualMachinesCount = filterPerVms && pgData.vmsCount == 0 ? this.getVmsCount(pgData.key, this._switchDiagramSpec.dvsSpec.vms) : pgData.vmsCount;
        }
    }

    private void addStandaloneDvPorts(SwitchDiagramModel switchDiagramModel) {
        if (this._switchDiagramSpec.dvsSpec.config != null && this._switchDiagramSpec.dvsSpec.config.numStandalonePorts > 0) {
            List<DistributedVirtualPort> standalonePorts = this.getPortsByPortgroupKey(null);
            PortGroupModel portGroupModel = new PortGroupModel();
            switchDiagramModel.portGroups.add(portGroupModel);
            portGroupModel.title = NetworkStringUtil.getString("SwitchDiagram.standalonePorts");
            portGroupModel.id = "dvpg-standalone";
            portGroupModel.isFakeGroup = true;
            this.addHostDvPorts(portGroupModel, standalonePorts);
            int standaloneVmsCount = 0;
            if (this._switchDiagramSpec.dvsSpec.standaloneVmsCount > 0) {
                standaloneVmsCount = this._switchDiagramSpec.dvsSpec.standaloneVmsCount;
            }
            portGroupModel.virtualMachinesCount = standaloneVmsCount;
        }
    }

    private void addHostDvPorts(PortGroupModel portGroupModel, List<DistributedVirtualPort> ports) {
        if (!ArrayUtil.isNullOrEmpty(ports)) {
            for (DistributedVirtualPort port : ports) {
                VirtualNic vnic;
                ManagedObjectReference host;
                HostMemberModel hostMemberModel;
                if (port == null || port.connectee == null || !Objects.equals(port.connectee.type, PortConnectee.ConnecteeType.hostVmkVnic.name()) || !Objects.equals(port.connectee.connectedEntity.getType(), HostSystem.class.getSimpleName()) || (hostMemberModel = this._hostsMap.get(host = port.connectee.connectedEntity)) == null || StringUtil.isNullOrEmpty((String)port.connectee.nicKey) || (vnic = hostMemberModel.getVirtualNicForKey(port.connectee.nicKey)) == null) continue;
                String name = vnic.device;
                String ip = SwitchDiagramUtil.getIpInfo(vnic, false);
                if (!StringUtil.isNullOrEmpty((String)ip)) {
                    name = String.format("%s : %s", name, ip);
                }
                PortModel portModel = new PortModel();
                portModel.title = name;
                portModel.id = port.key;
                portModel.portStatus = this.getPortConnectionStatus(port);
                portModel.portConnecteeType = PortConnectee.ConnecteeType.hostVmkVnic;
                if (host != null) {
                    portModel.hostValue = host.getValue();
                }
                portModel.vmkDevice = vnic.device;
                portGroupModel.vmkernelAdapters.add(portModel);
            }
        }
        this.sortVmkernelAdapters(portGroupModel.vmkernelAdapters);
    }

    private int getVmsCount(String portGroupKey, SwitchDiagramVmSpec[] vmSpecs) {
        HashSet<ManagedObjectReference> vmsSet = new HashSet<ManagedObjectReference>();
        if (!ArrayUtil.isNullOrEmpty((Object[])vmSpecs)) {
            for (SwitchDiagramVmSpec vmSpec : vmSpecs) {
                for (VirtualDevice device : vmSpec.devices) {
                    if (!(device instanceof VirtualEthernetCard)) continue;
                    VirtualEthernetCard.DistributedVirtualPortBackingInfo dvPortGroupBacking = (VirtualEthernetCard.DistributedVirtualPortBackingInfo)device.backing;
                    if (!dvPortGroupBacking.port.portgroupKey.equals(portGroupKey)) continue;
                    vmsSet.add(vmSpec.provider);
                }
            }
        }
        return vmsSet.size();
    }

    private void sortVmkernelAdapters(List<PortModel> vmkNics) {
        Collections.sort(vmkNics, new Comparator<PortModel>(){

            @Override
            public int compare(PortModel vmk1, PortModel vmk2) {
                int vmkernelsComparison = NetworkUtil.compareNicDevices(vmk1.vmkDevice, vmk2.vmkDevice, "vmk");
                if (vmkernelsComparison != 0) {
                    return vmkernelsComparison;
                }
                return SwitchDiagramBuilderImpl.this.compareNullableStrings(vmk1.title, vmk2.title);
            }
        });
    }

    private void sortPhysicalAdapters(List<AdapterModel> physicalNics) {
        Collections.sort(physicalNics, new Comparator<AdapterModel>(){

            @Override
            public int compare(AdapterModel adapter1, AdapterModel adapter2) {
                int vmnicComparison = NetworkUtil.compareNicDevices(adapter1.title, adapter2.title, "vmnic");
                if (vmnicComparison != 0) {
                    return vmnicComparison;
                }
                return SwitchDiagramBuilderImpl.this.compareNullableStrings(adapter1.hostName, adapter2.hostName);
            }
        });
    }

    private int compareNullableStrings(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return 0;
        }
        if (str1 == null) {
            return -1;
        }
        if (str2 == null) {
            return 1;
        }
        return str1.compareTo(str2);
    }

    private void initializeUplinkPortGroupsSet() {
        if (!ArrayUtil.isNullOrEmpty((Object[])this._switchDiagramSpec.dvsSpec.config.uplinkPortgroup)) {
            for (ManagedObjectReference uplinkPortgroup : this._switchDiagramSpec.dvsSpec.config.uplinkPortgroup) {
                this._uplinkGroups.add(uplinkPortgroup);
            }
        }
    }

    private void initializePortsMap() {
        this.addPortsToPortsMap(this._switchDiagramSpec.nonUplinkPorts);
        this.addPortsToPortsMap(this._switchDiagramSpec.uplinkPorts);
    }

    private void addPortsToPortsMap(DistributedVirtualPort[] ports) {
        if (!ArrayUtil.isNullOrEmpty((Object[])ports)) {
            for (DistributedVirtualPort distributedVirtualPort : ports) {
                List<DistributedVirtualPort> portgroupPorts;
                if (distributedVirtualPort == null) continue;
                if (!StringUtil.isNullOrEmpty((String)distributedVirtualPort.key)) {
                    this._portsMap.put(distributedVirtualPort.key, distributedVirtualPort);
                }
                if ((portgroupPorts = this._portgroupPortsMap.get(distributedVirtualPort.portgroupKey)) == null) {
                    portgroupPorts = new ArrayList<DistributedVirtualPort>();
                    this._portgroupPortsMap.put(distributedVirtualPort.portgroupKey, portgroupPorts);
                }
                portgroupPorts.add(distributedVirtualPort);
            }
        }
    }

    private List<DistributedVirtualPort> getPortsByPortgroupKey(String portgroupKey) {
        if (portgroupKey == null) {
            return null;
        }
        return this._portgroupPortsMap.get(portgroupKey);
    }

    private String getVlanSettings(VmwareDistributedVirtualSwitch.VlanSpec vlan, VlanType vlanType) {
        String result = EMPTY_STRING;
        switch (vlanType) {
            case PVLAN: {
                VmwareDistributedVirtualSwitch.PvlanSpec pvlanSpec = (VmwareDistributedVirtualSwitch.PvlanSpec)vlan;
                VmwareDistributedVirtualSwitch.PvlanMapEntry pvlanEntry = this._pvlanMap.get(pvlanSpec.pvlanId);
                if (pvlanEntry == null) break;
                result = NetworkStringUtil.getString("SwitchDiagram.vlanSettingsFormat", SwitchDiagramUtil.getPvlanPortType(pvlanEntry.pvlanType), Integer.toString(pvlanEntry.primaryVlanId), Integer.toString(pvlanEntry.secondaryVlanId));
                break;
            }
            case VLAN: {
                VmwareDistributedVirtualSwitch.VlanIdSpec vspec = (VmwareDistributedVirtualSwitch.VlanIdSpec)vlan;
                result = Integer.toString(vspec.vlanId);
                break;
            }
            case VLAN_TRUNKING: {
                VmwareDistributedVirtualSwitch.TrunkVlanSpec tspec = (VmwareDistributedVirtualSwitch.TrunkVlanSpec)vlan;
                if (tspec == null || tspec.vlanId == null) break;
                String vlanRange = EMPTY_STRING;
                boolean isFirstRangeSet = false;
                for (NumericRange range : tspec.vlanId) {
                    if (isFirstRangeSet) {
                        vlanRange = vlanRange + ", ";
                    } else {
                        isFirstRangeSet = true;
                    }
                    vlanRange = range.start != range.end ? vlanRange + range.start + "-" + range.end : vlanRange + range.start;
                }
                result = vlanRange;
            }
        }
        return result;
    }

    private String getUplinkId(String uplinkName, UplinkPortGroupModel uplinkPortGroupModel) {
        String uplinkId = UPLINK_PORT_PREFIX + uplinkName + uplinkPortGroupModel.id;
        List<String> uplinkIds = this._uplinkIds.get(uplinkName);
        if (uplinkIds == null) {
            uplinkIds = new ArrayList<String>();
            this._uplinkIds.put(uplinkName, uplinkIds);
        }
        uplinkIds.add(uplinkId);
        return uplinkId;
    }

    private void setUplinkPortConnectionStatus(DistributedVirtualPort port, AdapterModel adapterModel) {
        PortStatus status = this.getPortConnectionStatus(port);
        if (status != null) {
            adapterModel.portStatus = status;
        }
    }

    private void setLagConnectionStatus(LagModel lagModel, AdapterModel adapterModel) {
        if (adapterModel.portStatus.ordinal() > lagModel.portStatus.ordinal() && lagModel.portStatus != PortStatus.NA) {
            lagModel.portStatus = adapterModel.portStatus;
        }
    }

    private Set<String> getPortKeysSet(List<DistributedVirtualPort> ports) {
        HashSet<String> portKeys = new HashSet<String>();
        if (!ArrayUtil.isNullOrEmpty(ports)) {
            for (DistributedVirtualPort port : ports) {
                if (port == null || StringUtil.isNullOrEmpty((String)port.key)) continue;
                portKeys.add(port.key);
            }
        }
        return portKeys;
    }

    private String getVlanText(VlanType vlanType, String vlanSettings) {
        String vlanText = EMPTY_STRING;
        if (vlanType != VlanType.NA && !StringUtil.isNullOrEmpty((String)(vlanText = SwitchDiagramUtil.getVlanString(vlanType)))) {
            vlanText = vlanText + " " + (StringUtil.isNullOrEmpty((String)vlanSettings) ? NetworkStringUtil.getString("na") : vlanSettings);
        }
        return vlanText;
    }

    private void buildTeamingRelations(SwitchDiagramModel switchDiagramModel) {
        if (ArrayUtil.isNullOrEmpty((Object[])this._switchDiagramSpec.dvsSpec.portgroups)) {
            return;
        }
        for (SwitchDiagramPortgroupSpec switchDiagramPortgroupSpec : this._switchDiagramSpec.dvsSpec.portgroups) {
            String[] activeUplinks;
            if (switchDiagramPortgroupSpec == null || switchDiagramPortgroupSpec.uplinkPortOrder == null || ArrayUtil.isNullOrEmpty((Object[])switchDiagramPortgroupSpec.uplinkPortOrder.activeUplinkPort)) continue;
            for (String portName : activeUplinks = switchDiagramPortgroupSpec.uplinkPortOrder.activeUplinkPort) {
                List<String> uplinkIds = this._uplinkIds.get(portName);
                if (uplinkIds == null || uplinkIds.isEmpty()) continue;
                for (String uplinkId : uplinkIds) {
                    switchDiagramModel.relations.add(new GraphRelation(switchDiagramPortgroupSpec.provider.getValue(), uplinkId));
                }
            }
        }
    }

    private void buildVmKernelRelations(SwitchDiagramModel switchDiagramModel) {
        for (Map.Entry<ManagedObjectReference, HostMemberModel> hostsMapEntry : this._hostsMap.entrySet()) {
            HostMemberModel hostMemberModel = hostsMapEntry.getValue();
            if (hostMemberModel.hostProxySwitch == null || ArrayUtil.isNullOrEmpty((Object[])hostMemberModel.hostProxySwitch.pnic)) continue;
            for (String pnicKey : hostMemberModel.hostProxySwitch.pnic) {
                String pNicGeneratedKey;
                DistributedVirtualPort uplinkPort;
                PhysicalNic pnic = hostMemberModel.getPhysicalNicForProxySwitchPnicKey(pnicKey);
                if (pnic == null || (uplinkPort = this._nicToUplinkPort.get(pNicGeneratedKey = this.getGeneratedNicId(pnic.device, hostMemberModel.switchDiagramHostSpec.provider.getValue()))) == null || StringUtil.isNullOrEmpty((String)uplinkPort.key)) continue;
                for (Map.Entry<String, VirtualNic> virtualNicEntry : hostMemberModel.getVirtualNicsMap().entrySet()) {
                    DistributedVirtualPort port;
                    VirtualNic virtualNic = virtualNicEntry.getValue();
                    if (virtualNic.spec == null || virtualNic.spec.distributedVirtualPort == null || StringUtil.isNullOrEmpty((String)virtualNic.spec.distributedVirtualPort.portKey) || !this.checkActiveUplinkToPortMapping(port = this._portsMap.get(virtualNic.spec.distributedVirtualPort.portKey), uplinkPort)) continue;
                    switchDiagramModel.relations.add(new GraphRelation(virtualNic.spec.distributedVirtualPort.portKey, uplinkPort.key));
                }
            }
        }
    }

    private boolean checkActiveUplinkToPortMapping(DistributedVirtualPort dvPort, DistributedVirtualPort uplinkPort) {
        if (dvPort == null || uplinkPort == null) {
            return false;
        }
        boolean portsRelationExists = false;
        if (dvPort.config != null && dvPort.config.setting instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy) {
            VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy policy = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvPort.config.setting;
            if (policy.uplinkTeamingPolicy != null && policy.uplinkTeamingPolicy.uplinkPortOrder != null && !ArrayUtil.isNullOrEmpty((Object[])policy.uplinkTeamingPolicy.uplinkPortOrder.activeUplinkPort)) {
                String[] activePorts = policy.uplinkTeamingPolicy.uplinkPortOrder.activeUplinkPort;
                if (uplinkPort.config != null && !StringUtil.isNullOrEmpty((String)uplinkPort.config.name)) {
                    for (String activePort : activePorts) {
                        if (!StringUtil.isNullOrEmpty((String)uplinkPort.key) && this._lagPortKeys.contains(uplinkPort.key)) {
                            if (!Objects.equals(activePort, this._uplinkNameToLagNameMap.get(uplinkPort.config.name))) continue;
                            portsRelationExists = true;
                            break;
                        }
                        if (!Objects.equals(activePort, uplinkPort.config.name)) continue;
                        portsRelationExists = true;
                        break;
                    }
                }
            }
        }
        return portsRelationExists;
    }
}

