/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.util;

import com.vmware.vim.binding.vim.NumericRange;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.PortConnectee;
import com.vmware.vim.binding.vim.dvs.PortCriteria;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vsphere.client.dvs.api.port.DvsPortData;
import com.vmware.vsphere.client.dvs.api.spec.DistributedVirtualPortFilterSpec;
import com.vmware.vsphere.client.dvs.api.spec.GenericVlanSpec;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.DvPortgroupPolicyParser;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortEditData;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortMiscPolicyModel;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortMonitoringPolicyModel;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortPropertiesModel;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortTrafficShapingPolicyModel;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortVlanPolicyModel;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import com.vmware.vsphere.client.h5.network.util.NumericRangeUtil;
import com.vmware.vsphere.client.h5.network.util.VlanUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DvsPortsUtil {
    private static final String EMPTY_MAC = "00:00:00:00:00:00";
    private static final String DVPORT_ENTITY_TYPE = "DVPort";
    private static final String DVPORT_KEY = "key";
    private static final String DVPORT_NAME = "name";
    private static final String DVPORT_CONFIG = "config";
    private static final String DVPORT_CONN_ENTITY = "connectedEntityName";
    private static final String DVPORT_CONNECTEE = "connectee";
    private static final String DVPORT_MAC = "macAddress";
    private static final String DVPORT_PGKEY = "portgroupKey";
    private static final String DVPORT_PGNAME = "portgroupName";
    private static final String DVPORT_PORTSTATE = "portState";
    private static final String DVPORT_VLAN = "vlanInfo";
    private static final String DVPORT_LAG_NAME = "lagName";
    private static final String DVPORT_PROXYHOST = "proxyHostName";
    private static final String DVPORT_STATE = "state";
    private static final Integer MAX_PORT_COUNT = 2000;

    public static DvsPortData parsePortsData(ResultItem ri) {
        DvsPortData portData = new DvsPortData();
        HashMap<String, Object> portProperties = new HashMap<String, Object>();
        if (ri != null && ri.properties != null) {
            for (PropertyValue prop : ri.properties) {
                portProperties.put(prop.propertyName, prop.value);
            }
        }
        PropertyValue[] propertyValueArray = portProperties.keySet().iterator();
        while (propertyValueArray.hasNext()) {
            String key;
            switch (key = (String)propertyValueArray.next()) {
                case "key": {
                    portData.portId = (String)DvsPortsUtil.getPropertyValue(key, portProperties);
                    break;
                }
                case "name": {
                    portData.name = (String)DvsPortsUtil.getPropertyValue(key, portProperties);
                    break;
                }
                case "config": {
                    DistributedVirtualPort.ConfigInfo configInfo = (DistributedVirtualPort.ConfigInfo)DvsPortsUtil.getPropertyValue(key, portProperties);
                    portData.description = configInfo.description;
                    break;
                }
                case "connectee": 
                case "connectedEntityName": {
                    PortConnectee connectee = (PortConnectee)DvsPortsUtil.getPropertyValue(DVPORT_CONNECTEE, portProperties);
                    String connecteeName = (String)DvsPortsUtil.getPropertyValue(DVPORT_CONN_ENTITY, portProperties);
                    if (connectee == null) break;
                    portData.connectedEntity = PortConnectee.ConnecteeType.vmVnic.equals((Object)PortConnectee.ConnecteeType.valueOf((String)connectee.type)) ? connecteeName : connectee.nicKey;
                    portData.connectedEntityType = connectee.type;
                    break;
                }
                case "lagName": {
                    portData.lagName = (String)DvsPortsUtil.getPropertyValue(key, portProperties);
                    break;
                }
                case "proxyHostName": {
                    portData.host = (String)DvsPortsUtil.getPropertyValue(key, portProperties);
                    break;
                }
                case "macAddress": {
                    String macAddress = (String)DvsPortsUtil.getPropertyValue(key, portProperties);
                    portData.mac = EMPTY_MAC.equals(macAddress) ? null : macAddress;
                    break;
                }
                case "portgroupKey": {
                    portData.portgroupKey = (String)DvsPortsUtil.getPropertyValue(key, portProperties);
                    break;
                }
                case "portgroupName": {
                    portData.portgroup = (String)DvsPortsUtil.getPropertyValue(key, portProperties);
                    break;
                }
                case "portState": {
                    portData.state = (String)DvsPortsUtil.getPropertyValue(key, portProperties);
                    break;
                }
                case "vlanInfo": {
                    GenericVlanSpec vlanSpec = (GenericVlanSpec)DvsPortsUtil.getPropertyValue(key, portProperties);
                    portData.vlan = NetworkUtil.getVlanIdBySpec(vlanSpec.vlanSpec, new VmwareDistributedVirtualSwitch.PvlanMapEntry[]{vlanSpec.matchingPvlanMapEntry});
                }
            }
        }
        return portData;
    }

    public static DvsPortEditData parsePortEditData(ResultItem ri) {
        DvsPortEditData dvsPortEditData = new DvsPortEditData();
        dvsPortEditData.properties = new DvsPortPropertiesModel();
        HashMap<String, Object> portProperties = new HashMap<String, Object>();
        if (ri != null && ri.properties != null) {
            for (PropertyValue prop : ri.properties) {
                portProperties.put(prop.propertyName, prop.value);
            }
        }
        PropertyValue[] propertyValueArray = portProperties.keySet().iterator();
        while (propertyValueArray.hasNext()) {
            String key;
            switch (key = (String)propertyValueArray.next()) {
                case "name": {
                    dvsPortEditData.properties.name = (String)DvsPortsUtil.getPropertyValue(key, portProperties);
                    break;
                }
                case "config": {
                    DistributedVirtualPort.ConfigInfo configInfo = (DistributedVirtualPort.ConfigInfo)DvsPortsUtil.getPropertyValue(key, portProperties);
                    dvsPortEditData.properties.description = configInfo.description;
                    dvsPortEditData.configVersion = configInfo.configVersion;
                    if (configInfo.setting == null || !(configInfo.setting instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)) break;
                    VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy vmwarePolicy = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)configInfo.setting;
                    dvsPortEditData.securityPolicy = vmwarePolicy.getSecurityPolicy();
                    dvsPortEditData.trafficShapingPolicy = DvsPortsUtil.getTrafficShapingPolicyModel(vmwarePolicy);
                    dvsPortEditData.uplinkPortTeamingPolicy = vmwarePolicy.getUplinkTeamingPolicy();
                    dvsPortEditData.monitoringPolicy = DvsPortsUtil.getMonitoringPolicy(vmwarePolicy);
                    dvsPortEditData.miscPolicy = DvsPortsUtil.getMiscPolicy(vmwarePolicy);
                    dvsPortEditData.properties.selectedResourcePool = DvsPortsUtil.getNetworkResourcePool(vmwarePolicy);
                    break;
                }
                case "vlanInfo": {
                    GenericVlanSpec genericVlanSpec = (GenericVlanSpec)DvsPortsUtil.getPropertyValue(key, portProperties);
                    if (genericVlanSpec == null) break;
                    (dvsPortEditData.vlanPolicy = DvsPortsUtil.getDvsPortVlanPolicy((GenericVlanSpec)genericVlanSpec)).isVlanPolicyOverrided = !genericVlanSpec.vlanSpec.inherited;
                    break;
                }
            }
        }
        return dvsPortEditData;
    }

    public static QuerySpec buildDvportgroupPortsQuerySpec(ManagedObjectReference dvpgMor, ManagedObjectReference dvsMor) {
        DistributedVirtualPortFilterSpec filterSpec = new DistributedVirtualPortFilterSpec();
        filterSpec.portCriteria = new PortCriteria();
        filterSpec.dvs = dvsMor;
        filterSpec.portgroups = new ManagedObjectReference[]{dvpgMor};
        return DvsPortsUtil.buildPortQuerySpec(filterSpec, DvsPortsUtil.getPortsListViewPropertyData());
    }

    public static QuerySpec buildSwitchDiagramPortQuerySpec(ManagedObjectReference dvsMor, String dvsPortKey) {
        DistributedVirtualPortFilterSpec filterSpec = new DistributedVirtualPortFilterSpec();
        filterSpec.portCriteria = new PortCriteria();
        filterSpec.dvs = dvsMor;
        filterSpec.portCriteria.portKey = new String[]{dvsPortKey};
        return DvsPortsUtil.buildPortQuerySpec(filterSpec, new String[]{DVPORT_NAME, DVPORT_KEY, DVPORT_CONFIG, DVPORT_PORTSTATE, DVPORT_MAC});
    }

    public static QuerySpec buildDvsPortsQuerySpec(ManagedObjectReference dvsMor) {
        DistributedVirtualPortFilterSpec filterSpec = new DistributedVirtualPortFilterSpec();
        filterSpec.portCriteria = new PortCriteria();
        filterSpec.dvs = dvsMor;
        filterSpec.maxPortCount = MAX_PORT_COUNT;
        return DvsPortsUtil.buildPortQuerySpec(filterSpec, DvsPortsUtil.getPortsListViewPropertyData());
    }

    public static QuerySpec buildDvsPortsPoliciesQuerySpec(ManagedObjectReference dvsMor, String dvsPortKey) {
        DistributedVirtualPortFilterSpec filterSpec = new DistributedVirtualPortFilterSpec();
        filterSpec.portCriteria = new PortCriteria();
        filterSpec.dvs = dvsMor;
        filterSpec.portCriteria.portKey = new String[]{dvsPortKey};
        return DvsPortsUtil.buildPortQuerySpec(filterSpec, new String[]{DVPORT_CONFIG});
    }

    public static QuerySpec buildDvsPortsStatisticsQuerySpec(ManagedObjectReference dvsMor, String dvsPortKey) {
        DistributedVirtualPortFilterSpec filterSpec = new DistributedVirtualPortFilterSpec();
        filterSpec.portCriteria = new PortCriteria();
        filterSpec.dvs = dvsMor;
        filterSpec.portCriteria.portKey = new String[]{dvsPortKey};
        return DvsPortsUtil.buildPortQuerySpec(filterSpec, new String[]{DVPORT_STATE});
    }

    public static QuerySpec buildDvsPortEditQuerySpec(ManagedObjectReference dvsMor, String dvsPortKey) {
        DistributedVirtualPortFilterSpec filterSpec = new DistributedVirtualPortFilterSpec();
        filterSpec.portCriteria = new PortCriteria();
        filterSpec.dvs = dvsMor;
        filterSpec.portCriteria.portKey = new String[]{dvsPortKey};
        return DvsPortsUtil.buildPortQuerySpec(filterSpec, DvsPortsUtil.getPortEditPropertyData());
    }

    public static DvsPortData[] sortDvsPortsData(List<DvsPortData> ports) {
        Collections.sort(ports, new Comparator<DvsPortData>(){

            @Override
            public int compare(DvsPortData firstPort, DvsPortData secondPort) {
                if (firstPort.portId == null) {
                    return 1;
                }
                if (secondPort.portId == null) {
                    return -1;
                }
                boolean firstPortIdIsNum = DvsPortsUtil.tryParseInt(firstPort.portId);
                boolean secondPortIdIsNum = DvsPortsUtil.tryParseInt(secondPort.portId);
                if (firstPortIdIsNum && secondPortIdIsNum) {
                    Integer firstPortId = Integer.parseInt(firstPort.portId);
                    Integer secondPortId = Integer.parseInt(secondPort.portId);
                    return firstPortId.compareTo(secondPortId);
                }
                if (firstPortIdIsNum) {
                    return -1;
                }
                if (secondPortIdIsNum) {
                    return 1;
                }
                return firstPort.portId.compareTo(secondPort.portId);
            }
        });
        return ports.toArray(new DvsPortData[ports.size()]);
    }

    private static DvsPortVlanPolicyModel getDvsPortVlanPolicy(GenericVlanSpec genericVlanSpec) {
        DvsPortVlanPolicyModel vlanPolicyModel = new DvsPortVlanPolicyModel();
        vlanPolicyModel.vlanType = VlanUtil.getVlanType(genericVlanSpec.vlanSpec);
        if (genericVlanSpec.vlanSpec instanceof VmwareDistributedVirtualSwitch.VlanIdSpec) {
            vlanPolicyModel.vlanId = ((VmwareDistributedVirtualSwitch.VlanIdSpec)genericVlanSpec.vlanSpec).vlanId;
        } else if (genericVlanSpec.vlanSpec instanceof VmwareDistributedVirtualSwitch.TrunkVlanSpec) {
            NumericRange[] trunkRanges = ((VmwareDistributedVirtualSwitch.TrunkVlanSpec)genericVlanSpec.vlanSpec).vlanId;
            vlanPolicyModel.vlanTrunkRanges = NumericRangeUtil.asString(trunkRanges);
            vlanPolicyModel.vlanTrunkNumericRanges = trunkRanges;
        } else if (genericVlanSpec.vlanSpec instanceof VmwareDistributedVirtualSwitch.PvlanSpec) {
            vlanPolicyModel.pvlanId = ((VmwareDistributedVirtualSwitch.PvlanSpec)genericVlanSpec.vlanSpec).pvlanId;
        }
        return vlanPolicyModel;
    }

    private static DvsPortTrafficShapingPolicyModel getTrafficShapingPolicyModel(VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy vmwarePolicy) {
        DvsPortTrafficShapingPolicyModel trafficShapingPolicy = new DvsPortTrafficShapingPolicyModel();
        trafficShapingPolicy.inShapingPolicy = DvPortgroupPolicyParser.getTrafficShapingPolicy(vmwarePolicy.inShapingPolicy);
        trafficShapingPolicy.outShapingPolicy = DvPortgroupPolicyParser.getTrafficShapingPolicy(vmwarePolicy.outShapingPolicy);
        trafficShapingPolicy.inShapingOverrided = vmwarePolicy.inShapingPolicy != null && !vmwarePolicy.inShapingPolicy.inherited;
        trafficShapingPolicy.outShapingOverrided = vmwarePolicy.outShapingPolicy != null && !vmwarePolicy.outShapingPolicy.inherited;
        return trafficShapingPolicy;
    }

    private static DvsPortMonitoringPolicyModel getMonitoringPolicy(VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy vmwarePolicy) {
        DvsPortMonitoringPolicyModel monitoringPolicy = new DvsPortMonitoringPolicyModel();
        if (vmwarePolicy.ipfixEnabled != null) {
            monitoringPolicy.ipfixEnabled = vmwarePolicy.ipfixEnabled.getValue();
            monitoringPolicy.ipfixOverrided = !vmwarePolicy.ipfixEnabled.inherited;
        }
        return monitoringPolicy;
    }

    private static DvsPortMiscPolicyModel getMiscPolicy(VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy vmwarePolicy) {
        DvsPortMiscPolicyModel miscPolicy = new DvsPortMiscPolicyModel();
        if (vmwarePolicy.blocked != null) {
            miscPolicy.arePortsBlocked = vmwarePolicy.blocked.getValue();
            miscPolicy.blockPortsOverrided = !vmwarePolicy.blocked.inherited;
        }
        return miscPolicy;
    }

    private static DvsPortPropertiesModel.NetworkResourcePoolData getNetworkResourcePool(VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy vmwarePolicy) {
        DvsPortPropertiesModel.NetworkResourcePoolData networkResourcePoolData = new DvsPortPropertiesModel.NetworkResourcePoolData();
        if (vmwarePolicy.networkResourcePoolKey != null) {
            networkResourcePoolData.key = vmwarePolicy.networkResourcePoolKey.getValue();
            networkResourcePoolData.overrided = !vmwarePolicy.networkResourcePoolKey.inherited;
        }
        return networkResourcePoolData;
    }

    private static boolean tryParseInt(String input) {
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static QuerySpec buildPortQuerySpec(DistributedVirtualPortFilterSpec filterSpec, String[] propertyNames) {
        Constraint constraint = new Constraint();
        constraint.targetType = DVPORT_ENTITY_TYPE;
        ParameterSpec parameterSpec = new ParameterSpec();
        parameterSpec.propertyName = DVPORT_KEY;
        parameterSpec.parameter = filterSpec;
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.propertyNames = propertyNames;
        propertySpec.parameters = new ParameterSpec[]{parameterSpec};
        propertySpec.type = DVPORT_ENTITY_TYPE;
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = constraint;
        resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
        QuerySpec querySpec = new QuerySpec();
        querySpec.resourceSpec = resourceSpec;
        querySpec.resultSpec = new ResultSpec();
        querySpec.name = "H5CustomPortBrowserQuery";
        return querySpec;
    }

    private static String[] getPortsListViewPropertyData() {
        return new String[]{DVPORT_KEY, DVPORT_NAME, DVPORT_CONFIG, DVPORT_CONN_ENTITY, DVPORT_MAC, DVPORT_PGKEY, DVPORT_PGNAME, DVPORT_PORTSTATE, DVPORT_VLAN, DVPORT_CONNECTEE, DVPORT_LAG_NAME, DVPORT_PROXYHOST};
    }

    private static String[] getPortEditPropertyData() {
        return new String[]{DVPORT_NAME, DVPORT_CONFIG, DVPORT_VLAN};
    }

    private static <T> T getPropertyValue(String key, Map<String, Object> properties) {
        Object value = properties.get(key);
        try {
            Object castedValue = value;
            return (T)castedValue;
        }
        catch (ClassCastException e) {
            return null;
        }
    }
}

