/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.util;

import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.host.PortGroup;
import java.util.Arrays;
import java.util.HashSet;

public class VlanUtil {
    public static final String VLAN_NONE = "none";
    public static final String VLAN_VLAN = "vlan";
    public static final String VLAN_TRUNK = "trunk";
    public static final String VLAN_PRIVATE = "private";
    public static final int VLAN_NUM_NONE = 0;
    public static final int VLAN_NUM_ALL = 4095;
    public static final int VLAN_MIN = 1;
    public static final int VLAN_MAX = 4094;

    public static int[] getAvailableVlanIds(PortGroup[] portGroups) {
        HashSet<Integer> vlanIds = new HashSet<Integer>();
        vlanIds.add(0);
        vlanIds.add(4095);
        if (portGroups != null) {
            for (PortGroup portGroup : portGroups) {
                if (portGroup == null || portGroup.spec == null) continue;
                vlanIds.add(portGroup.spec.vlanId);
            }
        }
        int[] vlanIdArr = new int[vlanIds.size()];
        int index = 0;
        for (Integer vlandId : vlanIds) {
            vlanIdArr[index] = vlandId;
            ++index;
        }
        Arrays.sort(vlanIdArr);
        return vlanIdArr;
    }

    public static String getVlanType(VmwareDistributedVirtualSwitch.VlanSpec vlanSpec) {
        if (vlanSpec == null) {
            return VLAN_NONE;
        }
        if (vlanSpec instanceof VmwareDistributedVirtualSwitch.VlanIdSpec) {
            if (((VmwareDistributedVirtualSwitch.VlanIdSpec)vlanSpec).vlanId == 0) {
                return VLAN_NONE;
            }
            return VLAN_VLAN;
        }
        if (vlanSpec instanceof VmwareDistributedVirtualSwitch.TrunkVlanSpec) {
            return VLAN_TRUNK;
        }
        if (vlanSpec instanceof VmwareDistributedVirtualSwitch.PvlanSpec) {
            return VLAN_PRIVATE;
        }
        return null;
    }
}

