/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.vm.migrate;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.Network;
import com.vmware.vim.binding.vim.OpaqueNetwork;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.common.compositecommand.api.spec.DummyCommandSpec;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.vm.migrate.MigrateVmNetworkingParser;
import com.vmware.vsphere.client.h5.network.vm.migrate.model.MigrateVmData;
import com.vmware.vsphere.client.h5.network.vm.migrate.model.MigrateVmNetworkDragAndDropData;
import com.vmware.vsphere.client.h5.network.vm.migrate.model.MigrateVmNetworkDragAndDropResponse;
import com.vmware.vsphere.client.h5.network.vm.migrate.specs.MigrateVmNetworkingDragAndDropSpec;
import com.vmware.vsphere.client.h5.network.vm.migrate.specs.MigrateVmNetworkingSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class MigrateVmNetworkingMutationProvider
implements MutationProvider {
    private static final String HOST_NETWORK_PROPERTY = "network";
    private static final String IS_UPLINK_PORTGROUP_PROPERTY = "isUplinkPortgroup";
    private final MutationService _mutationService;
    private final ObjectReferenceService _objectReferenceService;
    private final QueryBindingService _queryBindingService;
    private final QueryService _queryService;

    public MigrateVmNetworkingMutationProvider(MutationService mutationService, ObjectReferenceService objectReferenceService, QueryBindingService queryBindingService, QueryService queryService) {
        this._mutationService = mutationService;
        this._objectReferenceService = objectReferenceService;
        this._queryBindingService = queryBindingService;
        this._queryService = queryService;
    }

    public OperationResult apply(ManagedObjectReference dcRef, MigrateVmNetworkingSpec migrateVmSpec) {
        return this.applyMigrateVmNetworkingSpec(dcRef, migrateVmSpec);
    }

    public OperationResult apply(ManagedObjectReference networkRef, MigrateVmNetworkingDragAndDropSpec migrateVmSpec) {
        ManagedObjectReference sourceNetworkRef = (ManagedObjectReference)this._objectReferenceService.getReference(migrateVmSpec.sourceNetworkId);
        ManagedObjectReference destinationNetworkRef = (ManagedObjectReference)this._objectReferenceService.getReference(migrateVmSpec.destinationNetworkId);
        if (!this.isNetworkValid(sourceNetworkRef, false)) {
            return this.getDragAndDropErrorResult(DragAndDropErrorType.SOURCE_INVALID);
        }
        if (!this.isNetworkValid(destinationNetworkRef, true)) {
            return this.getDragAndDropErrorResult(DragAndDropErrorType.DESTINATION_INVALID);
        }
        Collection<MigrateVmData> vmDataModels = this.getVmDataModels(migrateVmSpec);
        Set<String> hostUids = this.getHostUuids(destinationNetworkRef);
        Collection<MigrateVmNetworkDragAndDropData> networkDataModels = this.getNetworkDataModels(sourceNetworkRef, destinationNetworkRef);
        ManagedObjectReference dcRef = null;
        MigrateVmNetworkingSpec operationSpec = new MigrateVmNetworkingSpec();
        for (MigrateVmNetworkDragAndDropData data2 : networkDataModels) {
            if (destinationNetworkRef.equals(data2.provider)) {
                operationSpec.destinationNetwork = MigrateVmNetworkingParser.createVmNetworkData(data2);
                continue;
            }
            if (!sourceNetworkRef.equals(data2.provider)) continue;
            operationSpec.vmVnicsSpecs = MigrateVmNetworkingParser.createMigrateVmVnicsSpecs(vmDataModels.toArray(new MigrateVmData[vmDataModels.size()]), data2, hostUids);
            dcRef = data2.dc;
        }
        if (operationSpec.vmVnicsSpecs.length == 0) {
            return this.getDragAndDropErrorResult(DragAndDropErrorType.NO_VMS_AVAILABLE);
        }
        if (!migrateVmSpec.forceOperation && operationSpec.vmVnicsSpecs.length != vmDataModels.size()) {
            return this.getDragAndDropWarningResult();
        }
        return this.applyMigrateVmNetworkingSpec(dcRef, operationSpec);
    }

    private Collection<MigrateVmData> getVmDataModels(MigrateVmNetworkingDragAndDropSpec migrateVmSpec) {
        ArrayList<Object> vmRefs = new ArrayList<Object>();
        for (String vmId : migrateVmSpec.vmIds) {
            vmRefs.add(this._objectReferenceService.getReference(vmId));
        }
        return this._queryBindingService.prepare(MigrateVmData.class).fetch(vmRefs);
    }

    private Set<String> getHostUuids(ManagedObjectReference destinationNetworkRef) {
        ResultSet hostResult = this._queryService.select(new String[]{"@modelKey"}).from(new String[]{HostSystem.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate(HOST_NETWORK_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)destinationNetworkRef)}).fetch();
        HashSet<String> hostUids = new HashSet<String>();
        for (ResourceItem item : hostResult.getItems()) {
            ManagedObjectReference hostRef = (ManagedObjectReference)item.getKey();
            hostUids.add(ManagedObjectUtil.morefToString((ManagedObjectReference)hostRef));
        }
        return hostUids;
    }

    private Collection<MigrateVmNetworkDragAndDropData> getNetworkDataModels(ManagedObjectReference sourceNetworkRef, ManagedObjectReference destinationNetworkRef) {
        ArrayList<ManagedObjectReference> networkRefs = new ArrayList<ManagedObjectReference>();
        networkRefs.add(sourceNetworkRef);
        networkRefs.add(destinationNetworkRef);
        return this._queryBindingService.prepare(MigrateVmNetworkDragAndDropData.class).fetch(networkRefs);
    }

    private boolean isNetworkValid(ManagedObjectReference network, boolean isDestination) {
        if (!this.isNetworkTypeValid(network)) {
            return false;
        }
        if (isDestination && ManagedObjectUtil.isOfType((ManagedObjectReference)network, DistributedVirtualPortgroup.class)) {
            ResultSet portgroupResult = this._queryService.select(new String[]{IS_UPLINK_PORTGROUP_PROPERTY}).from(new String[]{DistributedVirtualPortgroup.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)network)}).fetch();
            for (ResourceItem item : portgroupResult.getItems()) {
                if (!((Boolean)item.get(IS_UPLINK_PORTGROUP_PROPERTY)).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isNetworkTypeValid(ManagedObjectReference network) {
        return ManagedObjectUtil.isOfType((ManagedObjectReference)network, Network.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)network, OpaqueNetwork.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)network, DistributedVirtualPortgroup.class);
    }

    private OperationResult applyMigrateVmNetworkingSpec(ManagedObjectReference dcRef, MigrateVmNetworkingSpec spec) {
        DummyCommandSpec commandSpec = MigrateVmNetworkingParser.createMigrateVmNetworkingCommandSpec(dcRef, spec);
        return this._mutationService.apply((Object)dcRef, (Object)commandSpec);
    }

    private OperationResult getDragAndDropErrorResult(DragAndDropErrorType errorType) {
        OperationResult opResult = new OperationResult();
        MigrateVmNetworkDragAndDropResponse response = new MigrateVmNetworkDragAndDropResponse();
        response.warnUser = false;
        switch (errorType) {
            case SOURCE_INVALID: {
                response.errorMessage = NetworkStringUtil.getString("migrateVmNetworking.operationNotAvailable.sourceObject");
                break;
            }
            case DESTINATION_INVALID: {
                response.errorMessage = NetworkStringUtil.getString("migrateVmNetworking.operationNotAvailable.destinationObject");
                break;
            }
            case NO_VMS_AVAILABLE: {
                response.errorMessage = NetworkStringUtil.getString("migrateVmNetworking.operationNotAvailable.noVmsAvailable");
            }
        }
        opResult.result = response;
        return opResult;
    }

    private OperationResult getDragAndDropWarningResult() {
        OperationResult opResult = new OperationResult();
        MigrateVmNetworkDragAndDropResponse response = new MigrateVmNetworkDragAndDropResponse();
        response.warnUser = true;
        opResult.result = response;
        return opResult;
    }

    private static enum DragAndDropErrorType {
        SOURCE_INVALID,
        DESTINATION_INVALID,
        NO_VMS_AVAILABLE;

    }
}

