/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.connection.http.impl;

import com.google.common.base.Preconditions;
import com.vmware.vim.binding.vim.UserSession;
import com.vmware.vim.vmomi.client.ext.RequestContextProvider;
import com.vmware.vim.vmomi.client.ext.ResultInterceptor;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.security.NotAuthenticatedError;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vmomi.request.DelegatingRequestContextProvider;
import com.vmware.vise.vim.commons.vmomi.request.ManagedObjectContextHandler;
import com.vmware.vise.vim.commons.vmomi.request.OpIdContextHandler;
import com.vmware.vsphere.client.h5.autodeploy.connection.http.HttpClientConfigFactory;
import com.vmware.vsphere.client.h5.autodeploy.connection.http.HttpConfigFactory;
import com.vmware.vsphere.client.h5.autodeploy.connection.http.impl.AuthCookieContextHandler;
import com.vmware.vsphere.client.h5.autodeploy.connection.http.impl.AutoDeployResultInterceptorImpl;
import com.vmware.vsphere.client.h5.autodeploy.connection.http.impl.ServerGuidContextHandler;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpClientConfigFactoryImpl
implements HttpClientConfigFactory {
    private static final String VC_SERVER_GUID = "vcServerGuid";
    private static final Log _logger = LogFactory.getLog(HttpClientConfigFactoryImpl.class);
    private final HttpConfigFactory _httpConfigFactory;
    private Boolean _isOpIdContextEnabled = false;
    private String _authCookieKey;

    public HttpClientConfigFactoryImpl(HttpConfigFactory httpConfigFactory) {
        this._httpConfigFactory = (HttpConfigFactory)Preconditions.checkNotNull((Object)httpConfigFactory);
    }

    public void setOpIdContextEnabled(Boolean isOpIdContextEnabled) {
        this._isOpIdContextEnabled = isOpIdContextEnabled;
    }

    public void setAuthCookieKey(String authCookieKey) {
        this._authCookieKey = authCookieKey;
    }

    @Override
    public HttpClientConfiguration getHttpClientConfig(VcService vcService) {
        HttpConfiguration httpConfig = this._httpConfigFactory.getHttpConfig();
        HttpClientConfiguration httpClientConfiguration = HttpClientConfiguration.Factory.newInstance();
        httpClientConfiguration.setHttpConfiguration(httpConfig);
        RequestContextProvider requestContextProvider = this.getRequestContextProvider(vcService);
        httpClientConfiguration.setRequestContextProvider(requestContextProvider);
        if (this._isOpIdContextEnabled.booleanValue()) {
            httpClientConfiguration.setResultInterceptor((ResultInterceptor)new AutoDeployResultInterceptorImpl(VC_SERVER_GUID));
        }
        return httpClientConfiguration;
    }

    private RequestContextProvider getRequestContextProvider(VcService vcService) {
        ArrayList<Object> contextHandlers = new ArrayList<Object>();
        if (!StringUtil.isNullOrEmpty((String)this._authCookieKey)) {
            ManagedObjectContextHandler cookieProvider = this.createAuthCookieContextHandler(vcService);
            contextHandlers.add(cookieProvider);
        }
        if (this._isOpIdContextEnabled.booleanValue()) {
            OpIdContextHandler opIdProvider = new OpIdContextHandler();
            contextHandlers.add(opIdProvider);
        }
        contextHandlers.add(new ServerGuidContextHandler(VC_SERVER_GUID, vcService.getServiceGuid()));
        DelegatingRequestContextProvider contextProvider = new DelegatingRequestContextProvider(contextHandlers.toArray(new ManagedObjectContextHandler[contextHandlers.size()]));
        return contextProvider;
    }

    private ManagedObjectContextHandler createAuthCookieContextHandler(VcService vcService) {
        String vcSessionId = this.getVcSessionId(vcService);
        if (vcSessionId == null) {
            _logger.error((Object)String.format("VC session Id is null for VC service with serverGuid=%s", vcService.getServiceGuid()));
            throw new NotAuthenticatedError();
        }
        return new AuthCookieContextHandler(this._authCookieKey, vcSessionId);
    }

    private String getVcSessionId(VcService vcService) {
        Preconditions.checkNotNull((Object)vcService);
        UserSession currentUserSession = vcService.getConnectionInfo().getUserSession();
        String sessionId = currentUserSession != null ? currentUserSession.getKey() : null;
        return sessionId;
    }
}

