/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.connection.impl;

import com.google.common.base.Preconditions;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.lookup.fault.EntryNotFoundFault;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.lookup.LookupUtil;
import com.vmware.vsphere.client.h5.autodeploy.connection.EndpointLocator;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LsEndpointLocator
implements EndpointLocator {
    private static final Log _logger = LogFactory.getLog(LsEndpointLocator.class);
    private final LookupService _lsService;
    private final String _endPointProtocol;
    private final String _typeId;

    public LsEndpointLocator(LookupService lsService, String endPointProtocol, String typeId) {
        this._lsService = (LookupService)Preconditions.checkNotNull((Object)lsService);
        this._endPointProtocol = (String)Preconditions.checkNotNull((Object)endPointProtocol);
        this._typeId = (String)Preconditions.checkNotNull((Object)typeId);
    }

    @Override
    public URI getEndpoint(VcService vcService) {
        Preconditions.checkNotNull((Object)vcService, (Object)String.format("VcService is null when retrieving endpoint for endPointProtocol=%s and typeId=%s.", this._endPointProtocol, this._typeId));
        ServiceRegistration.Endpoint endpoint = null;
        try {
            String vcServiceGuid = vcService.getServiceGuid();
            ServiceRegistration.Info vcServiceInfo = this._lsService.find(vcServiceGuid);
            ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
            filter.setNodeId(vcServiceInfo.getNodeId());
            filter.setEndpointType(new ServiceRegistration.EndpointType(this._endPointProtocol, this._typeId));
            filter.setSearchAllSsoDomains(Boolean.valueOf(true));
            ServiceRegistration.Info[] searchResult = this._lsService.getServiceRegistrationInfos(filter);
            if (searchResult.length > 0) {
                ServiceRegistration.Info autoDeployServiceVersion = searchResult[0];
                endpoint = LookupUtil.getEndpoint((ServiceRegistration.Info)autoDeployServiceVersion, (String)this._typeId);
            }
        }
        catch (EntryNotFoundFault ex) {
            String errorMessage = String.format("Error when retrieving endpoint for endPointProtocol=%s and typeId=%s :", this._endPointProtocol, this._typeId);
            _logger.error((Object)errorMessage, (Throwable)ex);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Url retrieved from lookup service " + (endpoint == null ? " not found." : endpoint.getUrl())));
        }
        if (endpoint != null) {
            return endpoint.getUrl();
        }
        return null;
    }
}

