/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.connection.impl;

import com.google.common.base.Preconditions;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.h5.autodeploy.connection.EndpointLocator;
import com.vmware.vsphere.client.h5.autodeploy.connection.http.HttpClientConfigFactory;
import java.net.URI;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmomiClientFactory {
    private static final Log _logger = LogFactory.getLog(VmomiClientFactory.class);
    private EndpointLocator _endpointLocator;
    private Map<Class<?>, Class<?>> _versionClassMap;
    private Class<?> _defaultVersionClass;
    private HttpClientConfigFactory _httpClientConfig;

    public VmomiClientFactory(EndpointLocator endpointLocator, Map<Class<?>, Class<?>> versionClass, Class<?> defaultVersionClass, HttpClientConfigFactory httpClientConfig) {
        this._endpointLocator = (EndpointLocator)Preconditions.checkNotNull((Object)endpointLocator);
        this._versionClassMap = (Map)Preconditions.checkNotNull(versionClass);
        this._defaultVersionClass = (Class)Preconditions.checkNotNull(defaultVersionClass);
        this._httpClientConfig = (HttpClientConfigFactory)Preconditions.checkNotNull((Object)httpClientConfig);
    }

    public Client createClient(VcService vcService) {
        URI endpoint = this._endpointLocator.getEndpoint(vcService);
        HttpClientConfiguration httpConfig = this._httpClientConfig.getHttpClientConfig(vcService);
        Class<?> vmodlVersion = this._versionClassMap.get(vcService.getVmodlVersion());
        if (vmodlVersion == null) {
            vmodlVersion = this._defaultVersionClass;
            _logger.warn((Object)("Cannot find mapping for VC VMODL version: " + vcService.getVmodlVersion() + ". Falling back to A/D VMODL version: " + this._defaultVersionClass + "."));
        }
        return Client.Factory.createClient((URI)endpoint, vmodlVersion, (ClientConfiguration)httpConfig);
    }
}

