/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.impl;

import com.google.common.base.Preconditions;
import com.vmware.vim.binding.rbd.HostOps;
import com.vmware.vim.binding.rbd.ProxyServerList;
import com.vmware.vim.binding.rbd.PxeProfileManager;
import com.vmware.vim.binding.rbd.RuleManager;
import com.vmware.vim.binding.rbd.ScriptManager;
import com.vmware.vim.binding.rbd.ServiceContent;
import com.vmware.vim.binding.rbd.ServiceInstance;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vsphere.client.h5.autodeploy.AutoDeployService;
import com.vmware.vsphere.client.h5.autodeploy.util.VlsiUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AutoDeployServiceImpl
implements AutoDeployService {
    private static final Log _logger = LogFactory.getLog(AutoDeployServiceImpl.class);
    private final Client _client;
    private final String SERVICE_INSTANCE_TYPE = "RbdServiceInstance";
    private final String SERVICE_INSTANCE_VALUE = "ServiceInstance";
    private String _vcServiceGuid;
    private ServiceInstance _serviceInstance;
    private ServiceContent _serviceContent;
    private ProxyServerList _proxyServerList;
    private RuleManager _ruleManager;
    private HostOps _hostOps;
    private PxeProfileManager _pxeProfileManager;
    private ScriptManager _scriptManager;

    public AutoDeployServiceImpl(Client client, String vcServiceGuid) {
        this._client = (Client)Preconditions.checkNotNull((Object)client);
        this._vcServiceGuid = vcServiceGuid;
    }

    public Client getClient() {
        return this._client;
    }

    @Override
    public <T extends ManagedObject> T getManagedObject(ManagedObjectReference moRef) {
        Class<T> typeClass = this.getBindingClass(moRef.getType());
        T stub = VlsiUtil.createStub(typeClass, moRef, this._client, this.getClass().getClassLoader());
        return stub;
    }

    @Override
    public ServiceInstance getServiceInstance() {
        if (this._serviceInstance != null) {
            return this._serviceInstance;
        }
        Class typeClass = this.getBindingClass("RbdServiceInstance");
        ManagedObjectReference serviceInstanceRef = new ManagedObjectReference("RbdServiceInstance", "ServiceInstance");
        this._serviceInstance = (ServiceInstance)VlsiUtil.createStub(typeClass, serviceInstanceRef, this._client, this.getClass().getClassLoader());
        return this._serviceInstance;
    }

    @Override
    public ServiceContent getServiceContent() {
        if (this._serviceContent != null) {
            return this._serviceContent;
        }
        this._serviceContent = this.getServiceInstance().getContent();
        return this._serviceContent;
    }

    @Override
    public ProxyServerList getProxyServerList() {
        if (this._proxyServerList != null) {
            return this._proxyServerList;
        }
        ServiceContent serviceContent = this.getServiceContent();
        if (serviceContent == null) {
            return null;
        }
        this._proxyServerList = (ProxyServerList)this.getManagedObject(serviceContent.getProxyServerList());
        return this._proxyServerList;
    }

    @Override
    public RuleManager getRuleManager() {
        if (this._ruleManager != null) {
            return this._ruleManager;
        }
        ServiceContent serviceContent = this.getServiceContent();
        if (serviceContent == null) {
            return null;
        }
        ManagedObjectReference ruleManagerRef = serviceContent.getRuleManager();
        this._ruleManager = (RuleManager)this.getManagedObject(ruleManagerRef);
        return this._ruleManager;
    }

    @Override
    public HostOps getHostOps() {
        if (this._hostOps != null) {
            return this._hostOps;
        }
        ServiceContent serviceContent = this.getServiceContent();
        if (serviceContent == null) {
            return null;
        }
        ManagedObjectReference hostOpsRef = serviceContent.getHostOps();
        this._hostOps = (HostOps)this.getManagedObject(hostOpsRef);
        return this._hostOps;
    }

    @Override
    public PxeProfileManager getPxeProfileManager() {
        if (this._pxeProfileManager != null) {
            return this._pxeProfileManager;
        }
        ServiceContent serviceContent = this.getServiceContent();
        if (serviceContent == null) {
            return null;
        }
        ManagedObjectReference pxeProfileManagerRef = serviceContent.getPxeManager();
        this._pxeProfileManager = (PxeProfileManager)this.getManagedObject(pxeProfileManagerRef);
        return this._pxeProfileManager;
    }

    @Override
    public ScriptManager getScriptManager() {
        if (this._scriptManager != null) {
            return this._scriptManager;
        }
        ServiceContent serviceContent = this.getServiceContent();
        if (serviceContent == null) {
            return null;
        }
        ManagedObjectReference managerRef = serviceContent.getScriptManager();
        this._scriptManager = (ScriptManager)this.getManagedObject(managerRef);
        return this._scriptManager;
    }

    private <T> Class<T> getBindingClass(String managedObjectType) {
        VmodlTypeMap typeMap = VmodlTypeMap.Factory.getTypeMap();
        VmodlType vmodlType = typeMap.getVmodlType(managedObjectType);
        Class bindingClass = vmodlType.getTypeClass();
        return bindingClass;
    }

    @Override
    public void close() {
        this._client.shutdown();
    }
}

