/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.impl;

import com.google.common.base.Preconditions;
import com.vmware.vim.binding.imagebuilder.DepotManager;
import com.vmware.vim.binding.imagebuilder.DepotSpec;
import com.vmware.vim.binding.imagebuilder.fault.DatabaseError;
import com.vmware.vim.binding.imagebuilder.fault.DuplicateDepot;
import com.vmware.vim.binding.imagebuilder.fault.NotFound;
import com.vmware.vim.binding.vim.TaskFilterSpec;
import com.vmware.vim.binding.vim.TaskHistoryCollector;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.TaskManager;
import com.vmware.vim.binding.vim.fault.InvalidState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.h5.autodeploy.ImageBuilderService;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.ImageBuilderServiceFactory;
import com.vmware.vsphere.client.h5.autodeploy.depot.AddOnlineDepotSpec;
import com.vmware.vsphere.client.h5.autodeploy.depot.AddUserDepotSpec;
import com.vmware.vsphere.client.h5.autodeploy.depot.AddZipDepotSpec;
import com.vmware.vsphere.client.h5.autodeploy.depot.DepotCheckUpdateSpec;
import com.vmware.vsphere.client.h5.autodeploy.depot.RemoveDepotSpec;
import com.vmware.vsphere.client.h5.autodeploy.depot.ValidateDepotNameSpec;
import com.vmware.vsphere.client.h5.autodeploy.impl.ImageProfilePropertyProvider;
import com.vmware.vsphere.client.h5.autodeploy.util.DepotReferenceUtil;
import java.net.URI;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DepotMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(DepotMutationProvider.class);
    private final ImageBuilderServiceFactory _imageBuilderServiceFactory;
    private final TaskMonitor _taskMonitor;

    public DepotMutationProvider(ImageBuilderServiceFactory ibServiceFactory, TaskMonitor taskMonitor) {
        this._imageBuilderServiceFactory = ibServiceFactory;
        this._taskMonitor = taskMonitor;
    }

    public OperationResult add(AddOnlineDepotSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = ManagedObjectUtil.getRootFolder((String)spec.vcGuid);
        ImageBuilderService imageBuilder = this._imageBuilderServiceFactory.getService(spec.vcGuid);
        DepotManager dm = imageBuilder.getDepotManager();
        try {
            if (!this.isDepotNameUnique(spec.name, dm)) {
                String errMsg = ResourceUtil.getString((String)"autodeployservice", (String)"duplicateDepotError.message", (String[])new String[]{spec.name}, (ClassLoader)ImageProfilePropertyProvider.class.getClassLoader());
                result.error = new Exception(errMsg);
                return result;
            }
            DepotSpec depotSpec = new DepotSpec();
            depotSpec.depotIndexUrl = spec.depotIndexUrl;
            depotSpec.name = spec.name;
            depotSpec.type = DepotSpec.Type.Online;
            ManagedObjectReference taskRef = dm.connect(depotSpec, Integer.valueOf(0));
            TaskInfo taskInfo = this._taskMonitor.monitorTask(taskRef);
            if (taskInfo.error != null) {
                result.error = taskInfo.error;
            }
            result.result = taskInfo.result;
        }
        catch (Exception e) {
            result.error = e;
        }
        return result;
    }

    public OperationResult add(AddUserDepotSpec spec) {
        OperationResult result = new OperationResult();
        ImageBuilderService imageBuilder = this._imageBuilderServiceFactory.getService(spec.vcGuid);
        DepotManager dm = imageBuilder.getDepotManager();
        try {
            DepotSpec depot = dm.createDepot(spec.name);
            result.result = DepotReferenceUtil.createRef(spec.vcGuid, depot.depotIndexUrl);
            result.entity = ManagedObjectUtil.getRootFolder((String)spec.vcGuid);
        }
        catch (DatabaseError | DuplicateDepot e) {
            result.error = e;
        }
        return result;
    }

    public OperationResult add(AddZipDepotSpec spec) {
        OperationResult result = new OperationResult();
        try {
            ManagedObjectReference task = this.getTaskByActivationId(spec.vcGuid, spec.activationId);
            TaskInfo taskInfo = this._taskMonitor.monitorTask(task);
            if (taskInfo.error != null) {
                result.error = taskInfo.error;
            }
            result.result = taskInfo.result;
        }
        catch (Exception e) {
            result.error = e;
        }
        return result;
    }

    @type(value="imagebuilder:Depot")
    public OperationResult apply(URI depot, DepotCheckUpdateSpec spec) throws Exception {
        OperationResult result = new OperationResult();
        ImageBuilderService imageBuilder = this._imageBuilderServiceFactory.getService(DepotReferenceUtil.getVcGuid(depot));
        DepotManager dm = imageBuilder.getDepotManager();
        DepotManager.DepotFilterSpec filter = new DepotManager.DepotFilterSpec(DepotReferenceUtil.getDepotUrl(depot));
        try {
            DepotSpec[] depotSpecs = dm.GetDepots(filter);
            ManagedObjectReference taskRef = dm.updateDepot(depotSpecs[0]);
            TaskInfo taskInfo = this._taskMonitor.monitorTask(taskRef);
            if (taskInfo.error != null) {
                result.error = taskInfo.error;
            }
            result.entity = depot;
        }
        catch (DatabaseError | NotFound e) {
            result.error = e;
        }
        return result;
    }

    @type(value="imagebuilder:Depot")
    public OperationResult remove(URI depot, RemoveDepotSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = depot;
        ImageBuilderService imageBuilder = this._imageBuilderServiceFactory.getService(DepotReferenceUtil.getVcGuid(depot));
        DepotManager depotManager = imageBuilder.getDepotManager();
        String depotUrl = DepotReferenceUtil.getDepotUrl(depot);
        DepotSpec[] allDepots = depotManager.getConfiguredDepot();
        DepotSpec specForUrl = null;
        for (DepotSpec ds : allDepots) {
            if (!depotUrl.equals(ds.depotIndexUrl)) continue;
            specForUrl = ds;
            break;
        }
        try {
            Preconditions.checkNotNull((Object)specForUrl, (Object)("Depot cannot be found. Depot URI=" + depot));
            depotManager.disconnect(specForUrl);
        }
        catch (Exception e) {
            result.error = e;
            _logger.error((Object)e);
        }
        return result;
    }

    public ValidationResult validate(ValidateDepotNameSpec spec) {
        ValidationResult result = new ValidationResult();
        result.result = true;
        try {
            ImageBuilderService imageBuilder = this._imageBuilderServiceFactory.getService(spec.vcServerGuid);
            DepotManager depotManager = imageBuilder.getDepotManager();
            result.result = this.isDepotNameUnique(spec.depotName, depotManager);
        }
        catch (Exception e) {
            result.error = e;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedObjectReference getTaskByActivationId(String vcGuid, String activationId) throws InvalidState {
        VcService vc = VimSessionUtil.getService((String)vcGuid);
        TaskManager vcTaskManager = (TaskManager)vc.getManagedObject(vc.getServiceInstanceContent().taskManager);
        TaskFilterSpec filterSpec = this.getFilterSpec(activationId);
        ManagedObjectReference taskCollectorRef = vcTaskManager.createCollector(filterSpec);
        TaskHistoryCollector collector = null;
        ManagedObjectReference depotAdditionTask = null;
        try {
            collector = (TaskHistoryCollector)vc.getManagedObject(taskCollectorRef);
            Object[] taskSearchResults = collector.getLatestPage();
            if (ArrayUtil.isNullOrEmpty((Object[])taskSearchResults)) {
                _logger.warn((Object)("No task found for depot creation with activationId " + activationId));
            } else {
                Object relevantTaskInfo = taskSearchResults[0];
                depotAdditionTask = ((TaskInfo)relevantTaskInfo).task;
                if (taskSearchResults.length > 1) {
                    _logger.warn((Object)("More than one task for depot creation with activationId " + activationId));
                }
            }
        }
        finally {
            if (collector != null) {
                collector.remove();
            }
        }
        return depotAdditionTask;
    }

    private TaskFilterSpec getFilterSpec(String activationId) {
        TaskFilterSpec result = new TaskFilterSpec();
        result.setActivationId(new String[]{activationId});
        return result;
    }

    private boolean isDepotNameUnique(String depotName, DepotManager depotManager) throws DatabaseError {
        boolean result = true;
        DepotSpec[] allDepots = depotManager.GetDepots(null);
        if (allDepots != null) {
            for (DepotSpec depot : allDepots) {
                if (!Objects.equals(depot.getName(), depotName)) continue;
                result = false;
                break;
            }
        }
        return result;
    }
}

